/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ScalarTypeBigDecimal
extends ScalarTypeBase<BigDecimal> {
    public ScalarTypeBigDecimal() {
        super(BigDecimal.class, true, 3);
    }

    public void bind(DataBinder binder, BigDecimal value) throws SQLException {
        if (value == null) {
            binder.setNull(3);
        } else {
            binder.setBigDecimal(value);
        }
    }

    public BigDecimal read(DataReader reader) throws SQLException {
        return reader.getBigDecimal();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toBigDecimal(value);
    }

    public BigDecimal toBeanType(Object value) {
        return BasicTypeConverter.toBigDecimal(value);
    }

    public String formatValue(BigDecimal t) {
        return t.toPlainString();
    }

    public BigDecimal parse(String value) {
        return new BigDecimal(value);
    }

    public BigDecimal convertFromMillis(long systemTimeMillis) {
        return BigDecimal.valueOf(systemTimeMillis);
    }

    public boolean isDateTimeCapable() {
        return true;
    }

    public BigDecimal readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return new BigDecimal(dataInput.readDouble());
    }

    public void writeData(DataOutput dataOutput, BigDecimal b) throws IOException {
        if (b == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeDouble(b.doubleValue());
        }
    }

    public BigDecimal jsonRead(JsonParser parser) throws IOException {
        return parser.getDecimalValue();
    }

    public void jsonWrite(JsonGenerator writer, BigDecimal value) throws IOException {
        writer.writeNumber(value);
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.DOUBLE;
    }
}

