/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.server.type.ScalarTypeBaseVarchar;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ScalarTypePath
extends ScalarTypeBaseVarchar<Path> {
    public ScalarTypePath() {
        super(Path.class);
    }

    @Override
    public Path convertFromDbString(String dbValue) {
        try {
            return Paths.get(new URI(dbValue));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error with Path URI [" + dbValue + "] " + e);
        }
    }

    @Override
    public String convertToDbString(Path beanValue) {
        return beanValue.toUri().toString();
    }

    @Override
    public String formatValue(Path path) {
        return this.convertToDbString(path);
    }

    @Override
    public Path parse(String value) {
        return this.convertFromDbString(value);
    }
}

