/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.annotation.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbOffline {
    private static final Logger logger = LoggerFactory.getLogger(DbOffline.class);
    private static final String KEY = "ebean.dboffline";
    private static boolean generateMigration;

    public static void setPlatform(Platform dbPlatform) {
        System.setProperty(KEY, dbPlatform.name());
    }

    public static void setPlatform(String platformName) {
        System.setProperty(KEY, platformName);
    }

    public static String getPlatform() {
        return System.getProperty(KEY);
    }

    public static void asH2() {
        DbOffline.setPlatform(Platform.H2);
    }

    public static boolean isSet() {
        return DbOffline.getPlatform() != null;
    }

    public static boolean isGenerateMigration() {
        return generateMigration;
    }

    public static void setGenerateMigration() {
        generateMigration = true;
    }

    public static void reset() {
        generateMigration = false;
        System.clearProperty(KEY);
        logger.debug("reset");
    }
}

