/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebeaninternal.server.cache.CacheChange;
import io.ebeaninternal.server.cache.CacheChangeBeanRemove;
import io.ebeaninternal.server.cache.CacheChangeBeanUpdate;
import io.ebeaninternal.server.cache.CacheChangeNaturalKeyPut;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheChangeSet {
    private final List<CacheChange> entries = new ArrayList<CacheChange>();
    private final Set<String> touchedTables = new HashSet<String>();
    private final Set<BeanDescriptor<?>> queryCaches = new HashSet();
    private final Set<BeanDescriptor<?>> beanCaches = new HashSet();
    private final Map<BeanDescriptor<?>, CacheChangeBeanRemove> beanRemoveMap = new HashMap();
    private final Map<ManyKey, ManyChange> manyChangeMap = new HashMap<ManyKey, ManyChange>();

    public Set<String> touchedTables() {
        return this.touchedTables;
    }

    public void apply() {
        for (BeanDescriptor<?> beanDescriptor : this.queryCaches) {
            beanDescriptor.clearQueryCache();
        }
        for (BeanDescriptor<?> beanDescriptor : this.beanCaches) {
            beanDescriptor.clearBeanCache();
        }
        for (CacheChange cacheChange : this.entries) {
            cacheChange.apply();
        }
        for (CacheChange cacheChange : this.manyChangeMap.values()) {
            cacheChange.apply();
        }
        for (CacheChange cacheChange : this.beanRemoveMap.values()) {
            cacheChange.apply();
        }
    }

    public void addInvalidate(BeanDescriptor<?> descriptor) {
        this.touchedTables.add(descriptor.getBaseTable());
    }

    public void addInvalidate(Set<String> tables) {
        this.touchedTables.addAll(tables);
    }

    public void addClearQuery(BeanDescriptor<?> descriptor) {
        this.queryCaches.add(descriptor);
        this.touchedTables.add(descriptor.getBaseTable());
    }

    public void addClearBean(BeanDescriptor<?> descriptor) {
        this.beanCaches.add(descriptor);
    }

    public <T> void addManyClear(BeanDescriptor<T> desc, String manyProperty) {
        this.many(desc, manyProperty).setClear();
    }

    public <T> void addManyRemove(BeanDescriptor<T> desc, String manyProperty, Object parentId) {
        this.many(desc, manyProperty).addRemove(parentId);
    }

    public <T> void addManyPut(BeanDescriptor<T> desc, String manyProperty, Object parentId, CachedManyIds entry) {
        this.many(desc, manyProperty).addPut(parentId, entry);
    }

    public void addBeanInsert(String baseTable) {
        this.touchedTables.add(baseTable);
    }

    public <T> void addBeanRemove(BeanDescriptor<T> desc, Object id) {
        CacheChangeBeanRemove entry = this.beanRemoveMap.get(desc);
        if (entry != null) {
            entry.addId(id);
        } else {
            this.beanRemoveMap.put(desc, new CacheChangeBeanRemove(id, desc));
            this.touchedTables.add(desc.getBaseTable());
        }
    }

    public <T> void addBeanRemoveMany(BeanDescriptor<T> desc, Collection<Object> ids) {
        CacheChangeBeanRemove entry = this.beanRemoveMap.get(desc);
        if (entry != null) {
            entry.addIds(ids);
        } else {
            this.beanRemoveMap.put(desc, new CacheChangeBeanRemove(desc, ids));
            this.touchedTables.add(desc.getBaseTable());
        }
    }

    public <T> void addBeanUpdate(BeanDescriptor<T> desc, String key, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        this.touchedTables.add(desc.getBaseTable());
        this.entries.add(new CacheChangeBeanUpdate(desc, key, changes, updateNaturalKey, version));
    }

    public <T> void addNaturalKeyPut(BeanDescriptor<T> desc, String key, String val) {
        this.entries.add(new CacheChangeNaturalKeyPut(desc, key, val));
    }

    private ManyChange many(BeanDescriptor<?> desc, String manyProperty) {
        ManyKey key = new ManyKey(desc, manyProperty);
        return this.manyChangeMap.computeIfAbsent(key, ManyChange::new);
    }

    private static class ManyChange
    implements CacheChange {
        final ManyKey key;
        final Set<Object> removes = new HashSet<Object>();
        final Map<Object, CachedManyIds> puts = new LinkedHashMap<Object, CachedManyIds>();
        boolean clear;

        ManyChange(ManyKey key) {
            this.key = key;
        }

        void setClear() {
            this.clear = true;
            this.removes.clear();
        }

        void addRemove(Object parentId) {
            if (!this.clear) {
                this.removes.add(parentId);
            }
        }

        void addPut(Object parentId, CachedManyIds entry) {
            this.puts.put(parentId, entry);
        }

        @Override
        public void apply() {
            if (this.clear) {
                this.key.cacheClear();
            } else {
                for (Map.Entry<Object, CachedManyIds> entry : this.puts.entrySet()) {
                    this.key.cachePut(entry.getKey(), entry.getValue());
                }
                for (Object parentId : this.removes) {
                    this.key.cacheRemove(parentId);
                }
            }
        }
    }

    private static class ManyKey {
        private final BeanDescriptor<?> desc;
        private final String manyProperty;

        ManyKey(BeanDescriptor<?> desc, String manyProperty) {
            this.desc = desc;
            this.manyProperty = manyProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManyKey manyKey = (ManyKey)o;
            return this.desc.equals(manyKey.desc) && this.manyProperty.equals(manyKey.manyProperty);
        }

        public int hashCode() {
            return 92821 * this.desc.hashCode() + this.manyProperty.hashCode();
        }

        void cacheClear() {
            this.desc.cacheManyPropClear(this.manyProperty);
        }

        void cachePut(Object parentId, CachedManyIds entry) {
            this.desc.cacheManyPropPut(this.manyProperty, parentId, entry);
        }

        void cacheRemove(Object parentId) {
            this.desc.cacheManyPropRemove(this.manyProperty, parentId);
        }
    }
}

