/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.bean.CallOrigin;
import io.ebean.bean.CallStack;
import io.ebeaninternal.server.core.CallOriginFactory;
import java.util.Arrays;

public class DefaultCallOriginFactory
implements CallOriginFactory {
    private static final int IGNORE_LEADING_ELEMENTS = 5;
    private static final String IO_EBEAN = "io.ebean";
    private final int maxCallStack;

    DefaultCallOriginFactory(int maxCallStack) {
        this.maxCallStack = maxCallStack;
    }

    @Override
    public CallOrigin createCallOrigin() {
        int startIndex;
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        for (startIndex = 5; startIndex < stackTrace.length && this.ignore(stackTrace[startIndex]); ++startIndex) {
        }
        int stackLength = stackTrace.length - startIndex;
        if (stackLength > this.maxCallStack) {
            stackLength = this.maxCallStack;
        }
        StackTraceElement[] finalTrace = new StackTraceElement[stackLength];
        System.arraycopy(stackTrace, startIndex, finalTrace, 0, stackLength);
        if (stackLength < 1) {
            throw new RuntimeException("StackTraceElement size 0?  stack: " + Arrays.toString(stackTrace));
        }
        return this.createCallStack(finalTrace);
    }

    private boolean ignore(StackTraceElement element) {
        if (element.getClassName().startsWith(IO_EBEAN)) {
            return true;
        }
        return element.getMethodName().startsWith("_ebean_");
    }

    private CallOrigin createCallStack(StackTraceElement[] finalTrace) {
        return new CallStack(finalTrace, finalTrace[0].hashCode(), this.pathHash(finalTrace));
    }

    private int pathHash(StackTraceElement[] callStack) {
        int hc = 0;
        for (int i = 1; i < callStack.length; ++i) {
            hc = 92821 * hc + callStack[i].hashCode();
        }
        return hc;
    }
}

