/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.RowConsumer;
import io.ebean.RowMapper;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.Transaction;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiSqlBinding;
import io.ebeaninternal.server.core.AbstractSqlQueryRequest;
import io.ebeaninternal.server.core.RelationalQueryEngine;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class RelationalQueryRequest
extends AbstractSqlQueryRequest {
    private final RelationalQueryEngine queryEngine;
    private String[] propertyNames;
    private int estimateCapacity;
    private int rows;

    RelationalQueryRequest(SpiEbeanServer server, RelationalQueryEngine engine, SqlQuery q, Transaction t) {
        super(server, (SpiSqlBinding)q, t);
        this.queryEngine = engine;
    }

    @Override
    protected void setResultSet(ResultSet resultSet, Object planKey) throws SQLException {
        this.resultSet = resultSet;
        this.propertyNames = this.getPropertyNames();
        float initCap = (float)this.propertyNames.length / 0.7f;
        this.estimateCapacity = (int)initCap + 1;
    }

    @Override
    protected void requestComplete() {
        String label = this.query.getLabel();
        if (label != null) {
            long exeMicros = (System.nanoTime() - this.startNano) / 1000L;
            this.queryEngine.collect(label, exeMicros);
        }
    }

    boolean findEachRow(RowConsumer mapper) {
        this.flushJdbcBatchOnQuery();
        this.queryEngine.findEachRow(this, mapper);
        return true;
    }

    <T> List<T> findListMapper(RowMapper<T> mapper) {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findListMapper(this, mapper);
    }

    <T> T findOneMapper(RowMapper<T> mapper) {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findOneMapper(this, mapper);
    }

    public <T> List<T> findSingleAttributeList(Class<T> cls) {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findSingleAttributeList(this, cls);
    }

    public <T> T findSingleAttribute(Class<T> cls) {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findSingleAttribute(this, cls);
    }

    public void findEach(Consumer<SqlRow> consumer) {
        this.flushJdbcBatchOnQuery();
        this.queryEngine.findEach(this, consumer);
    }

    public void findEachWhile(Predicate<SqlRow> consumer) {
        this.flushJdbcBatchOnQuery();
        this.queryEngine.findEach(this, consumer);
    }

    public List<SqlRow> findList() {
        this.flushJdbcBatchOnQuery();
        return this.queryEngine.findList(this);
    }

    private String[] getPropertyNames() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnsPlusOne = metaData.getColumnCount() + 1;
        ArrayList<String> propNames = new ArrayList<String>(columnsPlusOne - 1);
        for (int i = 1; i < columnsPlusOne; ++i) {
            propNames.add(metaData.getColumnLabel(i));
        }
        return propNames.toArray(new String[0]);
    }

    public SqlRow createNewRow() throws SQLException {
        ++this.rows;
        SqlRow sqlRow = this.queryEngine.createSqlRow(this.estimateCapacity);
        int index = 0;
        for (String propertyName : this.propertyNames) {
            Object value = this.resultSet.getObject(++index);
            sqlRow.set(propertyName, value);
        }
        return sqlRow;
    }

    public void logSummary() {
        if (this.transaction.isLogSummary()) {
            long micros = (System.nanoTime() - this.startNano) / 1000L;
            this.transaction.logSummary("SqlQuery  rows[" + this.rows + "] micros[" + micros + "] bind[" + this.bindLog + "]");
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void incrementRows() {
        ++this.rows;
    }

    public <T> List<T> mapList(RowMapper<T> mapper) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.next()) {
            list.add(mapper.map(this.resultSet, this.rows++));
        }
        return list;
    }

    public <T> T mapOne(RowMapper<T> mapper) throws SQLException {
        if (!this.next()) {
            return null;
        }
        return (T)mapper.map(this.resultSet, this.rows++);
    }

    public void mapEach(RowConsumer consumer) throws SQLException {
        while (this.next()) {
            consumer.accept(this.resultSet, this.rows++);
        }
    }
}

