/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.Platform;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DbMigrationInfo {
    private final List<String> preAdd;
    private final List<String> postAdd;
    private final List<String> preAlter;
    private final List<String> postAlter;
    private final List<Platform> platforms;

    public DbMigrationInfo(String[] preAdd, String[] postAdd, String[] preAlter, String[] postAlter, Platform[] platforms) {
        this.preAdd = this.toList(preAdd);
        this.postAdd = this.toList(postAdd);
        this.preAlter = this.toList(preAlter);
        this.postAlter = this.toList(postAlter);
        this.platforms = this.toList(platforms);
    }

    private <T> List<T> toList(T[] scripts) {
        if (scripts.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(scripts));
    }

    public List<String> getPreAdd() {
        return this.preAdd;
    }

    public List<String> getPostAdd() {
        return this.postAdd;
    }

    public List<String> getPreAlter() {
        return this.preAlter;
    }

    public List<String> getPostAlter() {
        return this.postAlter;
    }

    public List<Platform> getPlatforms() {
        return this.platforms;
    }

    public String joinPlatforms() {
        if (this.platforms.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Platform p : this.platforms) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(p.name().toLowerCase());
        }
        return sb.toString();
    }
}

