/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.Aggregation;
import io.ebean.annotation.Formula;
import io.ebean.annotation.Where;
import io.ebean.config.ClassLoadConfig;
import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.parse.InitMetaJacksonAnnotation;
import io.ebeaninternal.server.deploy.parse.ReadValidationAnnotations;
import io.ebeaninternal.server.deploy.parse.ReadValidationAnnotationsJakarta;
import io.ebeaninternal.server.deploy.parse.ReadValidationAnnotationsJavax;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;

class ReadAnnotationConfig {
    private final GeneratedPropertyFactory generatedPropFactory;
    private final String asOfViewSuffix;
    private final String versionsBetweenSuffix;
    private final boolean disableL2Cache;
    private final boolean eagerFetchLobs;
    private final boolean javaxValidationAnnotations;
    private final boolean jakartaValidationAnnotations;
    private final boolean jacksonAnnotations;
    private final boolean idGeneratorAutomatic;
    private final boolean useValidationNotNull;
    private final ReadValidationAnnotations javaxValidation;
    private final ReadValidationAnnotations jakartaValidation;
    private final Set<Class<?>> metaAnnotations = new HashSet();

    ReadAnnotationConfig(GeneratedPropertyFactory generatedPropFactory, String asOfViewSuffix, String versionsBetweenSuffix, DatabaseConfig config) {
        this.generatedPropFactory = generatedPropFactory;
        this.asOfViewSuffix = asOfViewSuffix;
        this.versionsBetweenSuffix = versionsBetweenSuffix;
        this.disableL2Cache = config.isDisableL2Cache();
        this.eagerFetchLobs = config.isEagerFetchLobs();
        this.idGeneratorAutomatic = config.isIdGeneratorAutomatic();
        this.useValidationNotNull = config.isUseValidationNotNull();
        ClassLoadConfig classLoadConfig = generatedPropFactory.getClassLoadConfig();
        this.javaxValidationAnnotations = classLoadConfig.isJavaxValidationAnnotationsPresent();
        this.jakartaValidationAnnotations = classLoadConfig.isJakartaValidationAnnotationsPresent();
        this.jacksonAnnotations = classLoadConfig.isJacksonAnnotationsPresent();
        this.metaAnnotations.add(Column.class);
        this.metaAnnotations.add(Formula.class);
        this.metaAnnotations.add(Formula.List.class);
        this.metaAnnotations.add(Where.class);
        this.metaAnnotations.add(Where.List.class);
        this.metaAnnotations.add(Aggregation.class);
        this.javaxValidation = this.javaxValidationAnnotations ? new ReadValidationAnnotationsJavax(this) : null;
        ReadValidationAnnotations readValidationAnnotations = this.jakartaValidation = this.jakartaValidationAnnotations ? new ReadValidationAnnotationsJakarta(this) : null;
        if (this.jacksonAnnotations) {
            InitMetaJacksonAnnotation.init(this);
        }
    }

    void addMetaAnnotation(Class<?> annotation) {
        this.metaAnnotations.add(annotation);
    }

    boolean checkValidationAnnotations() {
        return this.javaxValidationAnnotations || this.jakartaValidationAnnotations;
    }

    GeneratedPropertyFactory getGeneratedPropFactory() {
        return this.generatedPropFactory;
    }

    String getAsOfViewSuffix() {
        return this.asOfViewSuffix;
    }

    String getVersionsBetweenSuffix() {
        return this.versionsBetweenSuffix;
    }

    boolean isDisableL2Cache() {
        return this.disableL2Cache;
    }

    boolean isEagerFetchLobs() {
        return this.eagerFetchLobs;
    }

    boolean isIdGeneratorAutomatic() {
        return this.idGeneratorAutomatic;
    }

    boolean isJacksonAnnotations() {
        return this.jacksonAnnotations;
    }

    public Set<Class<?>> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    boolean isValidationNotNull(DeployBeanProperty property) {
        if (!this.useValidationNotNull) {
            return false;
        }
        if (this.javaxValidation != null && this.javaxValidation.isValidationNotNull(property)) {
            return true;
        }
        return this.jakartaValidation != null && this.jakartaValidation.isValidationNotNull(property);
    }

    int maxValidationSize(DeployBeanProperty prop) {
        int maxSize = 0;
        if (this.javaxValidation != null) {
            maxSize = Math.max(maxSize, this.javaxValidation.maxSize(prop));
        }
        if (this.jakartaValidation != null) {
            maxSize = Math.max(maxSize, this.jakartaValidation.maxSize(prop));
        }
        return maxSize;
    }
}

