/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadManyBuffer;
import io.ebeaninternal.api.LoadManyContext;
import io.ebeaninternal.api.LoadManyRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.loadcontext.DLoadBaseContext;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

class DLoadManyContext
extends DLoadBaseContext
implements LoadManyContext {
    protected final BeanPropertyAssocMany<?> property;
    private final boolean docStoreMapped;
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    DLoadManyContext(DLoadContext parent, BeanPropertyAssocMany<?> property, String path, OrmQueryProperties queryProps) {
        super(parent, property.getBeanDescriptor(), path, queryProps);
        this.property = property;
        this.docStoreMapped = property.isTargetDocStoreMapped();
        this.bufferList = !this.queryFetch ? null : new ArrayList();
        this.currentBuffer = this.createBuffer(this.batchSize);
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer = new LoadBuffer(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    public void clear() {
        if (this.bufferList != null) {
            this.bufferList.clear();
        }
        this.currentBuffer = this.createBuffer(this.batchSize);
    }

    private void configureQuery(SpiQuery<?> query) {
        this.setLabel(query);
        this.parent.propagateQueryState(query, this.docStoreMapped);
        query.setParentNode(this.objectGraphNode);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
    }

    public BeanPropertyAssocMany<?> getBeanProperty() {
        return this.property;
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.desc;
    }

    public String getName() {
        return this.parent.getEbeanServer().getName();
    }

    public void register(BeanCollection<?> bc) {
        if (this.currentBuffer.isFull()) {
            this.currentBuffer = this.createBuffer(this.batchSize);
        }
        this.currentBuffer.add(bc);
        bc.setLoader((BeanCollectionLoader)this.currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        this.lock.lock();
        try {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (loadBuffer.list.isEmpty()) continue;
                    LoadManyRequest req = new LoadManyRequest(loadBuffer, parentRequest);
                    this.parent.getEbeanServer().loadMany(req);
                }
                if (forEach) {
                    this.clear();
                } else {
                    this.bufferList = null;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class LoadBuffer
    implements BeanCollectionLoader,
    LoadManyBuffer {
        private final ReentrantLock lock = new ReentrantLock();
        private final PersistenceContext persistenceContext;
        private final DLoadManyContext context;
        private final int batchSize;
        private final List<BeanCollection<?>> list;

        LoadBuffer(DLoadManyContext context, int batchSize) {
            this.context = context;
            this.persistenceContext = context.getPersistenceContext();
            this.batchSize = batchSize;
            this.list = new ArrayList(batchSize);
        }

        @Override
        public boolean isUseDocStore() {
            return this.context.parent.useDocStore && this.context.docStoreMapped;
        }

        @Override
        public int getBatchSize() {
            return this.batchSize;
        }

        public boolean isFull() {
            return this.batchSize == this.list.size();
        }

        public void add(BeanCollection<?> bc) {
            this.list.add(bc);
        }

        @Override
        public List<BeanCollection<?>> getBatch() {
            return this.list;
        }

        @Override
        public BeanPropertyAssocMany<?> getBeanProperty() {
            return this.context.property;
        }

        @Override
        public ObjectGraphNode getObjectGraphNode() {
            return this.context.objectGraphNode;
        }

        @Override
        public void configureQuery(SpiQuery<?> query) {
            this.context.configureQuery(query);
        }

        public String getName() {
            return this.context.serverName;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
            this.lock.lock();
            try {
                Object parentId;
                EntityBean ownerBean;
                BeanDescriptor<?> parentDesc;
                boolean useCache;
                boolean bl = useCache = !onlyIds && this.context.hitCache && this.context.property.isUseCache();
                if (useCache && (parentDesc = this.context.desc.getBeanDescriptor((ownerBean = bc.getOwnerBean()).getClass())).cacheManyPropLoad(this.context.property, bc, parentId = parentDesc.getId(ownerBean), this.context.parent.isReadOnly())) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        if (this.list.get(i) != bc) continue;
                        this.list.remove(i);
                        return;
                    }
                    return;
                }
                LoadManyRequest req = new LoadManyRequest(this, onlyIds, useCache);
                this.context.parent.getEbeanServer().loadMany(req);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

