/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CountDistinctOrder;
import io.ebean.OrderBy;
import io.ebean.Query;
import io.ebean.RawSql;
import io.ebean.RawSqlBuilder;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;
import io.ebean.event.readaudit.ReadAuditQueryPlan;
import io.ebean.text.PathProperties;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQuery;
import io.ebeaninternal.server.query.CQueryBuilderRawSql;
import io.ebeaninternal.server.query.CQueryDraftSupport;
import io.ebeaninternal.server.query.CQueryFetchSingleAttribute;
import io.ebeaninternal.server.query.CQueryHistorySupport;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPlanRawSql;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.query.CQueryRowCount;
import io.ebeaninternal.server.query.CQueryUpdate;
import io.ebeaninternal.server.query.DbOrderByTrim;
import io.ebeaninternal.server.query.SqlTree;
import io.ebeaninternal.server.query.SqlTreeBuilder;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryLimitRequest;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.PersistenceException;

class CQueryBuilder {
    private final String columnAliasPrefix;
    private final SqlLimiter sqlLimiter;
    private final CQueryBuilderRawSql rawSqlHandler;
    private final Binder binder;
    private final boolean selectCountWithAlias;
    private final CQueryHistorySupport historySupport;
    private final CQueryDraftSupport draftSupport;
    private final DatabasePlatform dbPlatform;
    private final boolean selectCountWithColumnAlias;

    CQueryBuilder(DatabasePlatform dbPlatform, Binder binder, CQueryHistorySupport historySupport, CQueryDraftSupport draftSupport) {
        this.dbPlatform = dbPlatform;
        this.binder = binder;
        this.draftSupport = draftSupport;
        this.historySupport = historySupport;
        this.columnAliasPrefix = dbPlatform.getColumnAliasPrefix();
        this.sqlLimiter = dbPlatform.getSqlLimiter();
        this.rawSqlHandler = new CQueryBuilderRawSql(this.sqlLimiter, dbPlatform);
        this.selectCountWithAlias = dbPlatform.isSelectCountWithAlias();
        this.selectCountWithColumnAlias = dbPlatform.isSelectCountWithColumnAlias();
    }

    static String prefixOrderByFields(String name, String orderBy) {
        StringBuilder sb = new StringBuilder();
        for (String token : orderBy.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(".");
            sb.append(token.trim());
        }
        return sb.toString();
    }

    <T> CQueryUpdate buildUpdateQuery(boolean deleteRequest, OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        String rootTableAlias = query.getAlias();
        query.setupForDeleteOrUpdate();
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQueryUpdate(request, predicates, queryPlan);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        String sql = deleteRequest ? this.buildDeleteSql(request, rootTableAlias, predicates, sqlTree) : this.buildUpdateSql(request, rootTableAlias, predicates, sqlTree);
        queryPlan = new CQueryPlan(request, sql, sqlTree, predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryUpdate(request, predicates, queryPlan);
    }

    private <T> String buildDeleteSql(OrmQueryRequest<T> request, String rootTableAlias, CQueryPredicates predicates, SqlTree sqlTree) {
        String alias = this.alias(rootTableAlias);
        if (sqlTree.noJoins() && !request.getQuery().hasMaxRowsOrFirstRow()) {
            if (this.dbPlatform.isSupportsDeleteTableAlias()) {
                return this.aliasReplace(this.buildSqlDelete("delete", request, predicates, sqlTree).getSql(), alias);
            }
            if (this.isMySql(this.dbPlatform.getPlatform())) {
                return this.aliasReplace(this.buildSqlDelete("delete " + alias, request, predicates, sqlTree).getSql(), alias);
            }
            return this.aliasStrip(this.buildSqlDelete("delete", request, predicates, sqlTree).getSql());
        }
        String sql = this.buildSqlDelete(null, request, predicates, sqlTree).getSql();
        sql = request.getBeanDescriptor().getDeleteByIdInSql() + "in (" + sql + ")";
        sql = this.aliasReplace(sql, alias);
        return sql;
    }

    private boolean isMySql(Platform platform) {
        return platform.base() == Platform.MYSQL;
    }

    private String alias(String rootTableAlias) {
        return rootTableAlias == null ? "t0" : rootTableAlias;
    }

    private <T> String buildUpdateSql(OrmQueryRequest<T> request, String rootTableAlias, CQueryPredicates predicates, SqlTree sqlTree) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("update ").append(request.getBeanDescriptor().getBaseTable());
        if (rootTableAlias != null) {
            sb.append(" ").append(rootTableAlias);
        }
        sb.append(" set ").append(predicates.getDbUpdateClause());
        String updateClause = sb.toString();
        if (sqlTree.noJoins() && request.isInlineSqlUpdateLimit()) {
            return this.aliasStrip(this.buildSqlUpdate(updateClause, request, predicates, sqlTree).getSql());
        }
        String sql = this.buildSqlUpdate(null, request, predicates, sqlTree).getSql();
        sql = updateClause + " " + request.getBeanDescriptor().getWhereIdInSql() + "in (" + sql + ")";
        sql = this.aliasReplace(sql, this.alias(rootTableAlias));
        return sql;
    }

    private String aliasStrip(String sql) {
        return sql.replace("${RTA}.", "").replace(" ${RTA}", "");
    }

    private String aliasReplace(String sql, String replaceWith) {
        return sql.replace("${RTA}.", replaceWith + ".").replace("${RTA}", replaceWith);
    }

    CQueryFetchSingleAttribute buildFetchAttributeQuery(OrmQueryRequest<?> request) {
        Query query = request.getQuery();
        query.setSingleAttribute();
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQueryFetchSingleAttribute(request, predicates, queryPlan, query.isCountDistinct());
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        SqlLimitResponse s = this.buildSql(null, request, predicates, sqlTree);
        queryPlan = new CQueryPlan(request, s.getSql(), sqlTree, predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryFetchSingleAttribute(request, predicates, queryPlan, query.isCountDistinct());
    }

    <T> CQueryFetchSingleAttribute buildFetchIdsQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setSelectId();
        BeanDescriptor<T> desc = request.getBeanDescriptor();
        if (!query.isIncludeSoftDeletes() && desc.isSoftDelete()) {
            query.addSoftDeletePredicate(desc.getSoftDeletePredicate(this.alias(query.getAlias())));
        }
        return this.buildFetchAttributeQuery(request);
    }

    <T> CQueryHistorySupport getHistorySupport(SpiQuery<T> query) {
        return query.getTemporalMode().isHistory() ? this.historySupport : null;
    }

    <T> CQueryDraftSupport getDraftSupport(SpiQuery<T> query) {
        return query.getTemporalMode() == SpiQuery.TemporalMode.DRAFT ? this.draftSupport : null;
    }

    <T> CQueryRowCount buildRowCountQuery(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        query.setOrder(null);
        query.setFirstRow(0);
        query.setMaxRows(0);
        boolean countDistinct = query.isDistinct();
        boolean withAgg = false;
        if (!countDistinct && !(withAgg = this.includesAggregation(request, (SpiQuery<T>)query))) {
            query.setSelectId();
        }
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQueryRowCount(queryPlan, request, predicates);
        }
        predicates.prepare(true);
        SqlTree sqlTree = this.createSqlTree(request, predicates, this.selectCountWithColumnAlias && withAgg);
        if (SpiQuery.TemporalMode.CURRENT == query.getTemporalMode()) {
            sqlTree.addSoftDeletePredicate((SpiQuery<?>)query);
        }
        boolean wrap = sqlTree.hasMany() || withAgg;
        String sqlSelect = null;
        if (countDistinct) {
            if (sqlTree.isSingleProperty()) {
                request.setInlineCountDistinct();
            }
        } else if (!wrap) {
            sqlSelect = "select count(*)";
        }
        SqlLimitResponse s = this.buildSql(sqlSelect, request, predicates, sqlTree);
        String sql = s.getSql();
        if (!request.isInlineCountDistinct()) {
            if (countDistinct) {
                sql = this.wrapSelectCount(sql);
            } else if (wrap || query.isRawSql()) {
                int pos = sql.lastIndexOf(" order by ");
                if (pos != -1) {
                    sql = sql.substring(0, pos);
                }
                sql = this.wrapSelectCount(sql);
            }
        }
        queryPlan = new CQueryPlan(request, sql, sqlTree, predicates.getLogWhereSql());
        request.putQueryPlan(queryPlan);
        return new CQueryRowCount(queryPlan, request, predicates);
    }

    private <T> boolean includesAggregation(OrmQueryRequest<T> request, SpiQuery<T> query) {
        return request.getBeanDescriptor().includesAggregation(query.getDetail());
    }

    private String wrapSelectCount(String sql) {
        sql = "select count(*) from ( " + sql + ")";
        if (this.selectCountWithAlias) {
            sql = sql + " as c";
        }
        return sql;
    }

    <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        CQueryPredicates predicates = new CQueryPredicates(this.binder, request);
        CQueryPlan queryPlan = request.getQueryPlan();
        if (queryPlan != null) {
            predicates.prepare(false);
            return new CQuery<T>(request, predicates, queryPlan);
        }
        predicates.prepare(true);
        Query query = request.getQuery();
        SqlTree sqlTree = this.createSqlTree(request, predicates);
        if (query.isAsOfQuery()) {
            sqlTree.addAsOfTableAlias((SpiQuery<?>)query);
        } else if (SpiQuery.TemporalMode.CURRENT == query.getTemporalMode()) {
            sqlTree.addSoftDeletePredicate((SpiQuery<?>)query);
        }
        SqlLimitResponse res = this.buildSql(null, request, predicates, sqlTree);
        boolean rawSql = request.isRawSql();
        queryPlan = rawSql ? new CQueryPlanRawSql(request, res, sqlTree, predicates.getLogWhereSql()) : new CQueryPlan(request, res, sqlTree, false, predicates.getLogWhereSql());
        BeanDescriptor<T> desc = request.getBeanDescriptor();
        if (desc.isReadAuditing()) {
            desc.getReadAuditLogger().queryPlan(new ReadAuditQueryPlan(desc.getFullName(), queryPlan.getAuditQueryKey(), queryPlan.getSql()));
        }
        request.putQueryPlan(queryPlan);
        return new CQuery<T>(request, predicates, queryPlan);
    }

    private SqlTree createSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates) {
        return this.createSqlTree(request, predicates, false);
    }

    private SqlTree createSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates, boolean forceColumnAlias) {
        if (request.isNativeSql()) {
            return this.createNativeSqlTree(request, predicates);
        }
        if (request.isRawSql()) {
            return this.createRawSqlSqlTree(request, predicates);
        }
        String colAliasPrefix = forceColumnAlias ? "c" : this.columnAliasPrefix;
        return new SqlTreeBuilder(colAliasPrefix, this, request, predicates).build();
    }

    private String nativeQueryPaging(SpiQuery<?> query, String sql) {
        return this.dbPlatform.getBasicSqlLimiter().limit(sql, query.getFirstRow(), query.getMaxRows());
    }

    private SqlTree createNativeSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates) {
        Query query = request.getQuery();
        String sql = predicates.parseBindParams(query.getNativeSql());
        if (query.hasMaxRowsOrFirstRow()) {
            sql = this.nativeQueryPaging((SpiQuery<?>)query, sql);
        }
        query.setGeneratedSql(sql);
        Connection connection = request.getTransaction().getConnection();
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        try {
            PreparedStatement statement = connection.prepareStatement(sql, 1003, this.dbPlatform.isSupportsResultSetConcurrencyModeUpdatable() ? 1008 : 1007);
            predicates.bind(statement, connection);
            ResultSet resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int cols = 1 + metaData.getColumnCount();
            ArrayList<String> propertyNames = new ArrayList<String>(cols - 1);
            for (int i = 1; i < cols; ++i) {
                String columnName;
                String tableName;
                String schemaName = metaData.getSchemaName(i).toLowerCase();
                String path = desc.findBeanPath(schemaName, tableName = metaData.getTableName(i).toLowerCase(), columnName = metaData.getColumnName(i).toLowerCase());
                if (path != null) {
                    propertyNames.add(path);
                    continue;
                }
                propertyNames.add("$$_IGNORE_COLUMN_$$");
            }
            RawSql rawSql = RawSqlBuilder.resultSet((ResultSet)resultSet, (String[])propertyNames.toArray(new String[0]));
            query.setRawSql(rawSql);
            return this.createRawSqlSqlTree(request, predicates);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private SqlTree createRawSqlSqlTree(OrmQueryRequest<?> request, CQueryPredicates predicates) {
        BeanDescriptor<?> descriptor = request.getBeanDescriptor();
        SpiRawSql.ColumnMapping columnMapping = request.getQuery().getRawSql().getColumnMapping();
        PathProperties pathProps = new PathProperties();
        Iterator<SpiRawSql.ColumnMapping.Column> it = columnMapping.getColumns();
        while (it.hasNext()) {
            String foreignIdPath;
            SpiRawSql.ColumnMapping.Column column = it.next();
            Object propertyName = column.getPropertyName();
            if ("$$_IGNORE_COLUMN_$$".equals(propertyName)) continue;
            ElPropertyValue el = descriptor.getElGetValue((String)propertyName);
            if (el == null && ((String)propertyName).endsWith("Id") && (el = descriptor.getElGetValue(foreignIdPath = this.assocOneIdPath((String)propertyName))) != null) {
                propertyName = foreignIdPath;
            }
            if (el == null) {
                throw new PersistenceException("Property [" + (String)propertyName + "] not found on " + descriptor.getFullName());
            }
            this.addRawColumnMapping(pathProps, column, (String)propertyName, el);
        }
        OrmQueryDetail detail = new OrmQueryDetail();
        for (PathProperties.Props props : pathProps.getPathProps()) {
            detail.fetch(props.getPath(), props.getProperties());
        }
        boolean rawNoId = true;
        BeanProperty idProperty = descriptor.getIdProperty();
        if (idProperty != null && columnMapping.contains(idProperty.getName())) {
            rawNoId = false;
        }
        return new SqlTreeBuilder(request, predicates, detail, rawNoId).build();
    }

    private void addRawColumnMapping(PathProperties pathProps, SpiRawSql.ColumnMapping.Column column, String propertyName, ElPropertyValue el) {
        BeanProperty beanProperty = el.getBeanProperty();
        if (beanProperty.isId()) {
            if (propertyName.contains(".")) {
                propertyName = SplitName.parent((String)propertyName);
            }
        } else if (beanProperty.isDiscriminator()) {
            propertyName = SplitName.parent((String)propertyName);
        } else if (beanProperty instanceof BeanPropertyAssocOne) {
            String msg = "Column [" + column.getDbColumn() + "] mapped to complex Property[" + propertyName + "]";
            msg = msg + ". It should be mapped to a simple property (probably the Id property). ";
            throw new PersistenceException(msg);
        }
        if (propertyName != null) {
            boolean assocProperty = el.isAssocProperty();
            if (!assocProperty) {
                pathProps.addToPath(null, propertyName);
            } else {
                String[] pathProp = SplitName.split((String)propertyName);
                pathProps.addToPath(pathProp[0], pathProp[1]);
            }
        }
    }

    private String assocOneIdPath(String propertyName) {
        return propertyName.substring(0, propertyName.length() - 2) + ".id";
    }

    private SqlLimitResponse buildSql(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
        Query query = request.getQuery();
        if (query.isNativeSql()) {
            return new SqlLimitResponse(query.getGeneratedSql());
        }
        if (query.isRawSql()) {
            return this.rawSqlHandler.buildSql(request, predicates, query.getRawSql().getSql());
        }
        return new BuildReq(selectClause, request, predicates, select).buildSql();
    }

    private SqlLimitResponse buildSqlDelete(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
        return new BuildReq(selectClause, request, predicates, select).buildSql();
    }

    private SqlLimitResponse buildSqlUpdate(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
        return new BuildReq(selectClause, request, predicates, select, true).buildSql();
    }

    boolean isPlatformDistinctOn() {
        return this.dbPlatform.isPlatform(Platform.POSTGRES);
    }

    String fromForUpdate(SpiQuery<?> query) {
        Query.LockWait mode = query.getForUpdateLockWait();
        if (mode == null) {
            return null;
        }
        return this.dbPlatform.fromForUpdate(mode);
    }

    private class BuildReq {
        private final StringBuilder sb = new StringBuilder(500);
        private final String selectClause;
        private final OrmQueryRequest<?> request;
        private final SpiQuery<?> query;
        private final CQueryPredicates predicates;
        private final SqlTree select;
        private final boolean updateStatement;
        private final boolean distinct;
        private final boolean countSingleAttribute;
        private final String dbOrderBy;
        private boolean useSqlLimiter;
        private boolean hasWhere;

        private BuildReq(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select) {
            this(selectClause, request, predicates, select, false);
        }

        private BuildReq(String selectClause, OrmQueryRequest<?> request, CQueryPredicates predicates, SqlTree select, boolean updateStatement) {
            this.selectClause = selectClause;
            this.request = request;
            this.query = request.getQuery();
            this.predicates = predicates;
            this.select = select;
            this.updateStatement = updateStatement;
            this.distinct = this.query.isDistinct() || select.isSqlDistinct();
            this.dbOrderBy = predicates.getDbOrderBy();
            this.countSingleAttribute = this.query.isCountDistinct() && this.query.isSingleAttribute();
        }

        private void appendSelect() {
            if (this.selectClause != null) {
                this.sb.append(this.selectClause);
            } else {
                OrderBy<?> orderBy;
                boolean bl = this.useSqlLimiter = this.query.hasMaxRowsOrFirstRow() && this.select.getManyProperty() == null;
                if (!this.useSqlLimiter) {
                    this.appendSelectDistinct();
                }
                if (this.countSingleAttribute) {
                    this.sb.append("r1.attribute_, count(*) from (select ");
                    if (this.distinct) {
                        this.sb.append("distinct t0.");
                        this.sb.append(this.request.getBeanDescriptor().getIdProperty().getDbColumn()).append(", ");
                    }
                    this.sb.append(this.select.getSelectSql()).append(" as attribute_");
                } else {
                    this.sb.append(this.select.getSelectSql());
                }
                if (this.request.isInlineCountDistinct()) {
                    this.sb.append(")");
                }
                if (this.distinct && this.dbOrderBy != null && !this.query.isSingleAttribute() && (orderBy = this.query.getOrderBy()) != null && orderBy.supportsSelect()) {
                    this.sb.append(", ").append(DbOrderByTrim.trim(this.dbOrderBy));
                }
            }
        }

        private void appendSelectDistinct() {
            this.sb.append("select ");
            if (this.distinct && !this.countSingleAttribute) {
                if (this.request.isInlineCountDistinct()) {
                    this.sb.append("count(");
                }
                this.sb.append("distinct ");
                String distinctOn = this.select.getDistinctOn();
                if (distinctOn != null) {
                    this.sb.append("on (").append(distinctOn).append(") ");
                }
            }
        }

        private void appendFrom() {
            if (this.selectClause == null || !this.selectClause.startsWith("update")) {
                this.sb.append(" from ");
                this.sb.append(this.select.getFromSql());
            }
        }

        private void appendAndOrWhere() {
            if (this.hasWhere) {
                this.sb.append(" and ");
            } else {
                this.sb.append(" where ");
                this.hasWhere = true;
            }
        }

        private void appendInheritanceWhere() {
            String inheritanceWhere = this.select.getInheritanceWhereSql();
            if (!inheritanceWhere.isEmpty()) {
                this.sb.append(" where");
                this.sb.append(inheritanceWhere);
                this.hasWhere = true;
            }
        }

        private void appendHistoryAsOfPredicate() {
            if (this.query.isAsOfBaseTable() && !CQueryBuilder.this.historySupport.isStandardsBased()) {
                this.appendAndOrWhere();
                this.sb.append(CQueryBuilder.this.historySupport.getAsOfPredicate(this.request.getBaseTableAlias()));
            }
        }

        private void appendFindId() {
            if (this.request.isFindById() || this.query.getId() != null) {
                this.appendAndOrWhere();
                BeanDescriptor<?> desc = this.request.getBeanDescriptor();
                String idSql = desc.getIdBinderIdSql(this.query.getAlias());
                if (idSql.isEmpty()) {
                    throw new IllegalStateException("Executing FindById query on entity bean " + desc.getName() + " that doesn't have an @Id property??");
                }
                if (this.updateStatement) {
                    idSql = idSql.replace("t0.", "");
                }
                this.sb.append(idSql).append(" ");
                this.hasWhere = true;
            }
        }

        private void appendToWhere(String predicate) {
            if (this.hasValue(predicate)) {
                this.appendAndOrWhere();
                this.sb.append(predicate);
            }
        }

        private void appendSoftDelete() {
            List<String> softDeletePredicates = this.query.getSoftDeletePredicates();
            if (softDeletePredicates != null) {
                this.appendAndOrWhere();
                for (int i = 0; i < softDeletePredicates.size(); ++i) {
                    if (i > 0) {
                        this.sb.append(" and ");
                    }
                    this.sb.append(softDeletePredicates.get(i));
                }
            }
        }

        private SqlLimitResponse buildSql() {
            int maxRows;
            String dbHaving;
            String groupBy;
            this.appendSelect();
            this.appendFrom();
            this.appendInheritanceWhere();
            this.appendHistoryAsOfPredicate();
            this.appendFindId();
            this.appendToWhere(this.predicates.getDbWhere());
            this.appendToWhere(this.predicates.getDbFilterMany());
            if (!this.query.isIncludeSoftDeletes()) {
                this.appendSoftDelete();
            }
            if ((groupBy = this.select.getGroupBy()) != null) {
                this.sb.append(" group by ").append(groupBy);
            }
            if (this.hasValue(dbHaving = this.predicates.getDbHaving())) {
                this.sb.append(" having ").append(dbHaving);
            }
            if (this.dbOrderBy != null && !this.query.isCountDistinct()) {
                this.sb.append(" order by ").append(this.dbOrderBy);
            }
            if (this.countSingleAttribute) {
                this.sb.append(") r1 group by r1.attribute_");
                this.sb.append(this.toSql(this.query.getCountDistinctOrder()));
            }
            if (this.useSqlLimiter) {
                OrmQueryLimitRequest r = new OrmQueryLimitRequest(this.sb.toString(), this.dbOrderBy, this.query, CQueryBuilder.this.dbPlatform, this.distinct);
                return CQueryBuilder.this.sqlLimiter.limit((SqlLimitRequest)r);
            }
            if (this.updateStatement && (maxRows = this.query.getMaxRows()) > 0) {
                this.sb.append(" limit ").append(maxRows);
            }
            return new SqlLimitResponse(CQueryBuilder.this.dbPlatform.completeSql(this.sb.toString(), this.query));
        }

        private String toSql(CountDistinctOrder orderBy) {
            switch (orderBy) {
                case ATTR_ASC: {
                    return " order by r1.attribute_";
                }
                case ATTR_DESC: {
                    return " order by r1.attribute_ desc";
                }
                case COUNT_ASC_ATTR_ASC: {
                    return " order by count(*), r1.attribute_";
                }
                case COUNT_ASC_ATTR_DESC: {
                    return " order by count(*), r1.attribute_ desc";
                }
                case COUNT_DESC_ATTR_ASC: {
                    return " order by count(*) desc, r1.attribute_";
                }
                case COUNT_DESC_ATTR_DESC: {
                    return " order by count(*) desc, r1.attribute_ desc";
                }
            }
            throw new IllegalArgumentException("Illegal enum: " + orderBy);
        }

        private boolean hasValue(String s) {
            return s != null && !s.isEmpty();
        }
    }
}

