/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.QueryPlanRequest;
import io.ebean.metric.TimedMetric;
import io.ebeaninternal.api.ExtraMetrics;
import io.ebeaninternal.api.QueryPlanManager;
import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.query.CQueryBindCapture;
import io.ebeaninternal.server.query.CQueryPlanRequest;
import io.ebeaninternal.server.query.QueryPlanLogger;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.type.bindcapture.BindCapture;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryPlanManager
implements QueryPlanManager {
    private static final Logger log = LoggerFactory.getLogger(CQueryPlanManager.class);
    private static final Object dummy = new Object();
    private final ConcurrentHashMap<CQueryBindCapture, Object> plans = new ConcurrentHashMap();
    private final TransactionManager transactionManager;
    private final QueryPlanLogger planLogger;
    private final TimedMetric timeCollection;
    private final TimedMetric timeBindCapture;
    private long defaultThreshold;

    public CQueryPlanManager(TransactionManager transactionManager, long defaultThreshold, QueryPlanLogger planLogger, ExtraMetrics extraMetrics) {
        this.transactionManager = transactionManager;
        this.defaultThreshold = defaultThreshold;
        this.planLogger = planLogger;
        this.timeCollection = extraMetrics.getPlanCollect();
        this.timeBindCapture = extraMetrics.getBindCapture();
    }

    @Override
    public void setDefaultThreshold(long thresholdMicros) {
        this.defaultThreshold = thresholdMicros;
    }

    @Override
    public SpiQueryBindCapture createBindCapture(SpiQueryPlan queryPlan) {
        return new CQueryBindCapture(this, queryPlan, this.defaultThreshold);
    }

    public void notifyBindCapture(CQueryBindCapture planBind, long startNanos) {
        this.plans.put(planBind, dummy);
        this.timeBindCapture.addSinceNanos(startNanos);
    }

    @Override
    public List<MetaQueryPlan> collect(QueryPlanRequest request) {
        if (this.plans.isEmpty()) {
            return Collections.emptyList();
        }
        return this.collectPlans(request);
    }

    private List<MetaQueryPlan> collectPlans(QueryPlanRequest request) {
        List<MetaQueryPlan> list;
        block9: {
            Connection connection = this.transactionManager.getQueryPlanConnection();
            try {
                CQueryPlanRequest req = new CQueryPlanRequest(connection, request, ((ConcurrentHashMap.KeySetView)this.plans.keySet()).iterator());
                while (req.hasNext()) {
                    req.nextCapture();
                }
                list = req.getPlans();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error("Error during query plan collection", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            connection.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiDbQueryPlan collectPlan(Connection connection, SpiQueryPlan queryPlan, BindCapture last) {
        long startNanos = System.nanoTime();
        try {
            SpiDbQueryPlan spiDbQueryPlan = this.planLogger.collectPlan(connection, queryPlan, last);
            return spiDbQueryPlan;
        }
        finally {
            this.timeCollection.addSinceNanos(startNanos);
        }
    }
}

