/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.PropertyJoin;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.query.CQueryBuilder;
import io.ebeaninternal.server.query.CQueryDraftSupport;
import io.ebeaninternal.server.query.CQueryHistorySupport;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.query.DbOrderByTrim;
import io.ebeaninternal.server.query.DefaultDbSqlContext;
import io.ebeaninternal.server.query.ExtraJoin;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTree;
import io.ebeaninternal.server.query.SqlTreeAlias;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreeNodeBean;
import io.ebeaninternal.server.query.SqlTreeNodeExtraJoin;
import io.ebeaninternal.server.query.SqlTreeNodeFormulaWhereJoin;
import io.ebeaninternal.server.query.SqlTreeNodeManyRoot;
import io.ebeaninternal.server.query.SqlTreeNodeManyWhereJoin;
import io.ebeaninternal.server.query.SqlTreeNodeRoot;
import io.ebeaninternal.server.query.SqlTreeProperties;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlTreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlTreeBuilder.class);
    private final SpiQuery<?> query;
    private final STreeType desc;
    private final OrmQueryDetail queryDetail;
    private final CQueryPredicates predicates;
    private final boolean subQuery;
    private final boolean distinctOnPlatform;
    private STreePropertyAssocMany manyProperty;
    private final SqlTreeAlias alias;
    private final DefaultDbSqlContext ctx;
    private final HashSet<String> selectIncludes = new HashSet();
    private final ManyWhereJoins manyWhereJoins;
    private final TableJoin includeJoin;
    private final boolean rawSql;
    private final boolean rawNoId;
    private final boolean disableLazyLoad;
    private final SpiQuery.TemporalMode temporalMode;
    private SqlTreeNode rootNode;
    private boolean sqlDistinct;

    SqlTreeBuilder(OrmQueryRequest<?> request, CQueryPredicates predicates, OrmQueryDetail queryDetail, boolean rawNoId) {
        this.rawSql = true;
        this.desc = request.getBeanDescriptor();
        this.rawNoId = rawNoId;
        this.disableLazyLoad = request.getQuery().isDisableLazyLoading();
        this.query = null;
        this.subQuery = false;
        this.distinctOnPlatform = false;
        this.queryDetail = queryDetail;
        this.predicates = predicates;
        this.temporalMode = SpiQuery.TemporalMode.CURRENT;
        this.includeJoin = null;
        this.manyWhereJoins = null;
        this.alias = null;
        this.ctx = null;
    }

    SqlTreeBuilder(String columnAliasPrefix, CQueryBuilder builder, OrmQueryRequest<?> request, CQueryPredicates predicates) {
        this.rawSql = false;
        this.rawNoId = false;
        this.desc = request.getBeanDescriptor();
        this.query = request.getQuery();
        this.temporalMode = SpiQuery.TemporalMode.of(this.query);
        this.disableLazyLoad = this.query.isDisableLazyLoading();
        this.subQuery = SpiQuery.Type.SUBQUERY == this.query.getType() || SpiQuery.Type.ID_LIST == this.query.getType() || SpiQuery.Type.DELETE == this.query.getType() || this.query.isCountDistinct();
        this.includeJoin = this.query.getM2mIncludeJoin();
        this.manyWhereJoins = this.query.getManyWhereJoins();
        this.queryDetail = this.query.getDetail();
        this.predicates = predicates;
        this.alias = new SqlTreeAlias(request.getBaseTableAlias(), this.temporalMode);
        this.distinctOnPlatform = builder.isPlatformDistinctOn();
        String fromForUpdate = builder.fromForUpdate(this.query);
        CQueryHistorySupport historySupport = builder.getHistorySupport(this.query);
        CQueryDraftSupport draftSupport = builder.getDraftSupport(this.query);
        String colAlias = this.subQuery ? null : columnAliasPrefix;
        this.ctx = new DefaultDbSqlContext(this.alias, colAlias, historySupport, draftSupport, fromForUpdate);
    }

    public SqlTree build() {
        this.buildRoot(this.desc);
        String distinctOn = null;
        String selectSql = null;
        String fromSql = null;
        String inheritanceWhereSql = null;
        String groupBy = null;
        STreeProperty[] encryptedProps = null;
        if (!this.rawSql) {
            selectSql = this.buildSelectClause();
            fromSql = this.buildFromClause();
            inheritanceWhereSql = this.buildWhereClause();
            groupBy = this.buildGroupByClause();
            distinctOn = this.buildDistinctOn();
            encryptedProps = this.ctx.getEncryptedProps();
        }
        boolean includeJoins = this.alias != null && this.alias.isIncludeJoins();
        return new SqlTree(this.rootNode, distinctOn, selectSql, fromSql, groupBy, inheritanceWhereSql, encryptedProps, this.manyProperty, includeJoins);
    }

    private String buildSelectClause() {
        if (this.rawSql) {
            return "Not Used";
        }
        this.rootNode.appendSelect(this.ctx, this.subQuery);
        return this.trimComma(this.ctx.getContent());
    }

    private String buildGroupByClause() {
        if (this.rawSql || !this.rootNode.isAggregation() && this.query.getHavingExpressions() == null) {
            return null;
        }
        this.ctx.startGroupBy();
        this.rootNode.appendGroupBy(this.ctx, this.subQuery);
        return this.trimComma(this.ctx.getContent());
    }

    private String buildDistinctOn() {
        if (this.rawSql || !this.distinctOnPlatform || !this.sqlDistinct || SpiQuery.Type.COUNT == this.query.getType()) {
            return null;
        }
        this.ctx.startGroupBy();
        this.rootNode.appendDistinctOn(this.ctx, this.subQuery);
        String idCols = this.trimComma(this.ctx.getContent());
        return idCols == null ? null : SqlTreeBuilder.mergeOnDistinct(idCols, this.predicates.getDbOrderBy());
    }

    static String mergeOnDistinct(String idCols, String dbOrderBy) {
        String[] split;
        if (dbOrderBy == null) {
            return idCols;
        }
        dbOrderBy = DbOrderByTrim.trim(dbOrderBy);
        StringBuilder sb = new StringBuilder(dbOrderBy.length() + idCols.length() + 2);
        sb.append(dbOrderBy);
        for (String col : split = idCols.split(",")) {
            if (dbOrderBy.contains(col = col.trim())) continue;
            sb.append(", ").append(col);
        }
        return sb.toString();
    }

    private String trimComma(String groupBy) {
        if (groupBy.length() < ", ".length()) {
            return null;
        }
        return groupBy.substring(", ".length());
    }

    private String buildWhereClause() {
        if (this.rawSql) {
            return "Not Used";
        }
        this.rootNode.appendWhere(this.ctx);
        return this.ctx.getContent();
    }

    private String buildFromClause() {
        if (this.rawSql) {
            return "Not Used";
        }
        this.rootNode.appendFrom(this.ctx, SqlJoinType.AUTO);
        return this.ctx.getContent();
    }

    private void buildRoot(STreeType desc) {
        this.rootNode = this.buildSelectChain(null, null, desc, null);
        if (!this.rawSql) {
            this.alias.addJoin(this.queryDetail.getFetchPaths(), desc);
            this.alias.addJoin(this.predicates.getPredicateIncludes(), desc);
            this.alias.addManyWhereJoins(this.manyWhereJoins.getPropertyNames());
            this.alias.buildAlias();
            this.predicates.parseTableAlias(this.alias);
        }
    }

    private SqlTreeNode buildSelectChain(String prefix, STreePropertyAssoc prop, STreeType desc, List<SqlTreeNode> joinList) {
        String propPrefix;
        ArrayList<SqlTreeNode> myJoinList = new ArrayList<SqlTreeNode>();
        ArrayList<STreePropertyAssocOne> extraProps = new ArrayList<STreePropertyAssocOne>();
        for (STreePropertyAssocOne sTreePropertyAssocOne : desc.propsOne()) {
            propPrefix = SplitName.add((String)prefix, (String)sTreePropertyAssocOne.getName());
            if (!this.isIncludeBean(propPrefix)) continue;
            this.selectIncludes.add(propPrefix);
            if (!sTreePropertyAssocOne.hasForeignKey()) {
                extraProps.add(sTreePropertyAssocOne);
            }
            this.buildSelectChain(propPrefix, sTreePropertyAssocOne, sTreePropertyAssocOne.target(), myJoinList);
        }
        for (STreePropertyAssoc sTreePropertyAssoc : desc.propsMany()) {
            propPrefix = SplitName.add((String)prefix, (String)sTreePropertyAssoc.getName());
            if (!this.isIncludeMany(propPrefix, (STreePropertyAssocMany)sTreePropertyAssoc)) continue;
            this.selectIncludes.add(propPrefix);
            this.buildSelectChain(propPrefix, sTreePropertyAssoc, sTreePropertyAssoc.target(), myJoinList);
        }
        OrmQueryProperties queryProps = this.queryDetail.getChunk(prefix, false);
        SqlTreeProperties props = this.getBaseSelect(desc, queryProps);
        if (prefix == null && !this.rawSql) {
            if (props.requireSqlDistinct(this.manyWhereJoins)) {
                this.sqlDistinct = true;
            }
            this.addManyWhereJoins(myJoinList);
        }
        extraProps.forEach(props::add);
        SqlTreeNode selectNode = this.buildNode(prefix, prop, desc, myJoinList, props);
        if (joinList != null) {
            joinList.add(selectNode);
        }
        return selectNode;
    }

    private void addManyWhereJoins(List<SqlTreeNode> myJoinList) {
        STreeProperty beanProperty;
        Collection<PropertyJoin> includes = this.manyWhereJoins.getPropertyJoins();
        for (PropertyJoin joinProp : includes) {
            beanProperty = (STreePropertyAssoc)this.desc.findPropertyFromPath(joinProp.getProperty());
            SqlTreeNodeManyWhereJoin nodeJoin = new SqlTreeNodeManyWhereJoin(joinProp.getProperty(), (STreePropertyAssoc)beanProperty, joinProp.getSqlJoinType(), this.temporalMode);
            myJoinList.add(nodeJoin);
        }
        if (this.manyWhereJoins.isFormulaWithJoin()) {
            for (String property : this.manyWhereJoins.getFormulaJoinProperties()) {
                beanProperty = this.desc.findPropertyFromPath(property);
                myJoinList.add(new SqlTreeNodeFormulaWhereJoin(beanProperty, SqlJoinType.OUTER));
            }
        }
    }

    private SqlTreeNode buildNode(String prefix, STreePropertyAssoc prop, STreeType desc, List<SqlTreeNode> myList, SqlTreeProperties props) {
        if (prefix == null) {
            String baseTable;
            this.buildExtraJoins(desc, myList);
            BeanPropertyAssocMany<?> lazyLoadMany = this.query == null ? null : this.query.getLazyLoadMany();
            boolean withId = !this.rawNoId && !this.subQuery && (this.query == null || this.query.isWithId());
            String string = baseTable = this.query == null ? null : this.query.getBaseTable();
            if (baseTable == null) {
                baseTable = desc.getBaseTable(this.temporalMode);
            }
            return new SqlTreeNodeRoot(desc, props, myList, withId, this.includeJoin, lazyLoadMany, this.temporalMode, this.disableLazyLoad, this.sqlDistinct, baseTable);
        }
        if (prop instanceof STreePropertyAssocMany) {
            return new SqlTreeNodeManyRoot(prefix, (STreePropertyAssocMany)prop, props, myList, this.temporalMode, this.disableLazyLoad);
        }
        boolean withId = this.isNotSingleAttribute();
        return new SqlTreeNodeBean(prefix, prop, props, myList, withId, this.temporalMode, this.disableLazyLoad);
    }

    private void buildExtraJoins(STreeType desc, List<SqlTreeNode> myList) {
        if (this.rawSql) {
            return;
        }
        Set<String> predicateIncludes = this.predicates.getPredicateIncludes();
        if (predicateIncludes == null) {
            return;
        }
        predicateIncludes.removeAll(this.manyWhereJoins.getPropertyNames());
        predicateIncludes.addAll(this.predicates.getOrderByIncludes());
        IncludesDistiller extraJoinDistill = new IncludesDistiller(desc, this.selectIncludes, predicateIncludes, this.temporalMode);
        Collection extraJoins = extraJoinDistill.getExtraJoinRootNodes();
        if (!extraJoins.isEmpty()) {
            for (SqlTreeNodeExtraJoin extraJoin : extraJoins) {
                myList.add(extraJoin);
                if (!extraJoin.isManyJoin()) continue;
                this.sqlDistinct = true;
            }
        }
    }

    private void addPropertyToSubQuery(SqlTreeProperties selectProps, STreeType desc, String propName) {
        int pos;
        STreeProperty p = desc.findProperty(propName);
        if (p == null) {
            logger.error("property [" + propName + "]not found on " + desc + " for query - excluding it.");
        } else if (p instanceof STreePropertyAssoc && p.isEmbedded() && (pos = propName.indexOf(46)) > -1) {
            String name = propName.substring(pos + 1);
            p = ((STreePropertyAssoc)p).target().findProperty(name);
        }
        selectProps.add(p);
    }

    private void addProperty(SqlTreeProperties selectProps, STreeType desc, OrmQueryProperties queryProps, String propName) {
        if (this.subQuery) {
            this.addPropertyToSubQuery(selectProps, desc, propName);
            return;
        }
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            if (!selectProps.containsProperty(baseName)) {
                STreeProperty p = desc.findPropertyWithDynamic(baseName, null);
                if (p == null) {
                    p = desc.findPropertyWithDynamic(propName, null);
                    if (p != null) {
                        selectProps.add(p);
                    } else {
                        logger.error("property [" + propName + "] not found on " + desc + " for query - excluding it.");
                    }
                } else if (p.isEmbedded() || p instanceof STreePropertyAssoc && !queryProps.isIncludedBeanJoin(p.getName())) {
                    selectProps.add(p);
                } else {
                    logger.error("property [" + p.getFullBeanName() + "] expected to be an embedded or *ToOne bean for query - excluding it.");
                }
            }
        } else {
            STreeProperty p = desc.findPropertyWithDynamic(propName, queryProps.getPath());
            if (p == null) {
                logger.error("property [" + propName + "] not found on " + desc + " for query - excluding it.");
                p = desc.findProperty("id");
                selectProps.add(p);
            } else if (!p.isId() || !this.excludeIdProperty()) {
                if (p instanceof STreePropertyAssoc) {
                    if (!queryProps.isIncludedBeanJoin(p.getName())) {
                        selectProps.add(p);
                    }
                } else {
                    selectProps.add(p);
                }
            }
        }
    }

    private SqlTreeProperties getBaseSelectPartial(STreeType desc, OrmQueryProperties queryProps) {
        Set<String> selectQueryJoin;
        SqlTreeProperties selectProps = new SqlTreeProperties();
        Set<String> selectInclude = queryProps.getIncluded();
        for (String propName : selectInclude) {
            if (propName.isEmpty()) continue;
            this.addProperty(selectProps, desc, queryProps, propName);
        }
        if (!selectProps.isAggregationManyToOne() && (selectQueryJoin = queryProps.getSelectQueryJoin()) != null) {
            for (String joinProperty : selectQueryJoin) {
                if (selectInclude.contains(joinProperty)) continue;
                this.addProperty(selectProps, desc, queryProps, joinProperty);
            }
        }
        return selectProps;
    }

    private SqlTreeProperties getBaseSelect(STreeType desc, OrmQueryProperties queryProps) {
        boolean partial;
        boolean bl = partial = queryProps != null && !queryProps.allProperties();
        if (partial) {
            return this.getBaseSelectPartial(desc, queryProps);
        }
        SqlTreeProperties selectProps = new SqlTreeProperties();
        selectProps.setAllProperties();
        selectProps.add(desc.propsBaseScalar());
        selectProps.add(desc.propsEmbedded());
        for (STreePropertyAssocOne propertyAssocOne : desc.propsOne()) {
            if (queryProps != null && queryProps.isIncludedBeanJoin(propertyAssocOne.getName()) && propertyAssocOne.hasForeignKey() && !propertyAssocOne.isFormula()) continue;
            selectProps.add(propertyAssocOne);
        }
        InheritInfo inheritInfo = desc.getInheritInfo();
        if (inheritInfo != null) {
            inheritInfo.addChildrenProperties(selectProps);
        }
        return selectProps;
    }

    private boolean isIncludeMany(String propName, STreePropertyAssocMany manyProp) {
        if (this.queryDetail.isJoinsEmpty()) {
            return false;
        }
        if (this.queryDetail.includesPath(propName)) {
            if (this.manyProperty != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not joining [" + propName + "] as already joined to a Many[" + this.manyProperty + "].");
                }
                return false;
            }
            this.manyProperty = manyProp;
            return true;
        }
        return false;
    }

    private boolean isIncludeBean(String prefix) {
        if (this.queryDetail.includesPath(prefix)) {
            String[] splitNames = SplitName.split((String)prefix);
            this.queryDetail.includeBeanJoin(splitNames[0], splitNames[1]);
            return true;
        }
        return false;
    }

    private boolean excludeIdProperty() {
        return this.query == null || !this.query.isSingleAttribute() && !this.query.isManualId();
    }

    private boolean isNotSingleAttribute() {
        return this.query == null || !this.query.isSingleAttribute();
    }

    private static class IncludesDistiller {
        private final STreeType desc;
        private final Set<String> selectIncludes;
        private final Set<String> predicateIncludes;
        private final SpiQuery.TemporalMode temporalMode;
        private final Map<String, SqlTreeNodeExtraJoin> joinRegister = new HashMap<String, SqlTreeNodeExtraJoin>();
        private final Map<String, SqlTreeNodeExtraJoin> rootRegister = new HashMap<String, SqlTreeNodeExtraJoin>();

        private IncludesDistiller(STreeType desc, Set<String> selectIncludes, Set<String> predicateIncludes, SpiQuery.TemporalMode temporalMode) {
            this.desc = desc;
            this.selectIncludes = selectIncludes;
            this.predicateIncludes = predicateIncludes;
            this.temporalMode = temporalMode;
        }

        private Collection<SqlTreeNodeExtraJoin> getExtraJoinRootNodes() {
            Object[] extras = this.findExtras();
            if (extras.length == 0) {
                return this.rootRegister.values();
            }
            Arrays.sort(extras);
            for (Object extra : extras) {
                this.createExtraJoin((String)extra);
            }
            return this.rootRegister.values();
        }

        private void createExtraJoin(String includeProp) {
            SqlTreeNodeExtraJoin extraJoin = this.createJoinLeaf(includeProp);
            if (extraJoin != null) {
                SqlTreeNodeExtraJoin root = this.findExtraJoinRoot(includeProp, extraJoin);
                this.rootRegister.put(root.getName(), root);
            }
        }

        private SqlTreeNodeExtraJoin createJoinLeaf(String propertyName) {
            ExtraJoin extra = this.desc.extraJoin(propertyName);
            if (extra == null) {
                return null;
            }
            SqlTreeNodeExtraJoin extraJoin = new SqlTreeNodeExtraJoin(propertyName, extra.getProperty(), extra.isContainsMany(), this.temporalMode);
            this.joinRegister.put(propertyName, extraJoin);
            return extraJoin;
        }

        private SqlTreeNodeExtraJoin findExtraJoinRoot(String includeProp, SqlTreeNodeExtraJoin childJoin) {
            int dotPos;
            while ((dotPos = includeProp.lastIndexOf(46)) != -1) {
                String parentPropertyName = includeProp.substring(0, dotPos);
                if (this.selectIncludes.contains(parentPropertyName)) {
                    return childJoin;
                }
                SqlTreeNodeExtraJoin parentJoin = this.joinRegister.get(parentPropertyName);
                if (parentJoin == null) {
                    parentJoin = this.createJoinLeaf(parentPropertyName);
                }
                parentJoin.addChild(childJoin);
                childJoin = parentJoin;
                includeProp = parentPropertyName;
            }
            return childJoin;
        }

        private String[] findExtras() {
            ArrayList<String> extras = new ArrayList<String>();
            for (String predProp : this.predicateIncludes) {
                if (this.selectIncludes.contains(predProp)) continue;
                extras.add(predProp);
            }
            return extras.toArray(new String[0]);
        }
    }
}

