/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebean.TransactionCallback;
import io.ebean.annotation.DocStoreMode;
import io.ebean.bean.PersistenceContext;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TxnProfileEventCodes;
import io.ebeaninternal.server.core.PersistDeferredRelationship;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.lib.Str;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.BatchedSqlException;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TChangeLogHolder;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeanservice.docstore.api.DocStoreTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcTransaction
implements SpiTransaction,
TxnProfileEventCodes {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTransaction.class);
    private static final Object PLACEHOLDER = new Object();
    private static final String illegalStateMessage = "Transaction is Inactive";
    final TransactionManager manager;
    private final String id;
    private final boolean logSql;
    private final boolean logSummary;
    private String label;
    private final boolean explicit;
    private final DatabasePlatform.OnQueryOnly onQueryOnly;
    private boolean active;
    private boolean rollbackOnly;
    private boolean nestedUseSavepoint;
    Connection connection;
    private BatchControl batchControl;
    private TransactionEvent event;
    private PersistenceContext persistenceContext;
    private boolean persistCascade = true;
    private boolean queryOnly = true;
    private boolean localReadOnly;
    private Boolean updateAllLoadedProperties;
    private boolean oldBatchMode;
    private boolean batchMode;
    private boolean batchOnCascadeMode;
    private int batchSize = -1;
    private boolean batchFlushOnQuery = true;
    private Boolean batchGetGeneratedKeys;
    private Boolean batchFlushOnMixed;
    private final String logPrefix;
    private Object tenantId;
    private int depth;
    private boolean autoCommit;
    private IdentityHashMap<Object, Object> persistingBeans;
    private HashSet<Integer> deletingBeansHash;
    private HashMap<String, String> m2mIntersectionSave;
    private Map<String, Object> userObjects;
    private List<TransactionCallback> callbackList;
    private boolean batchOnCascadeSet;
    private TChangeLogHolder changeLogHolder;
    private List<PersistDeferredRelationship> deferredList;
    private DocStoreMode docStoreMode;
    private int docStoreBatchSize;
    private Boolean skipCache;
    private final boolean skipCacheAfterWrite;
    DocStoreTransaction docStoreTxn;
    private ProfileStream profileStream;
    private ProfileLocation profileLocation;
    private final long startNanos;
    private boolean autoPersistUpdates;

    JdbcTransaction(String id, boolean explicit, Connection connection, TransactionManager manager) {
        try {
            this.active = true;
            this.id = id;
            this.logPrefix = JdbcTransaction.deriveLogPrefix(id);
            this.explicit = explicit;
            this.manager = manager;
            this.connection = connection;
            this.persistenceContext = new DefaultPersistenceContext();
            this.startNanos = System.nanoTime();
            if (manager == null) {
                this.logSql = false;
                this.logSummary = false;
                this.skipCacheAfterWrite = true;
                this.batchMode = false;
                this.batchOnCascadeMode = false;
                this.onQueryOnly = DatabasePlatform.OnQueryOnly.ROLLBACK;
            } else {
                this.autoPersistUpdates = explicit && manager.isAutoPersistUpdates();
                this.logSql = manager.isLogSql();
                this.logSummary = manager.isLogSummary();
                this.skipCacheAfterWrite = manager.isSkipCacheAfterWrite();
                this.batchMode = manager.isPersistBatch();
                this.batchOnCascadeMode = manager.isPersistBatchOnCascade();
                this.onQueryOnly = manager.getOnQueryOnly();
            }
            this.checkAutoCommit(connection);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public long getStartNanoTime() {
        return this.startNanos;
    }

    @Override
    public long profileOffset() {
        return this.profileStream == null ? 0L : this.profileStream.offset();
    }

    @Override
    public void profileEvent(SpiProfileTransactionEvent event) {
        if (this.profileStream != null) {
            event.profile();
        }
    }

    @Override
    public void setProfileStream(ProfileStream profileStream) {
        this.profileStream = profileStream;
    }

    @Override
    public ProfileStream profileStream() {
        return this.profileStream;
    }

    @Override
    public void setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
    }

    @Override
    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    void checkAutoCommit(Connection connection) throws SQLException {
        if (connection != null) {
            this.autoCommit = connection.getAutoCommit();
            if (this.autoCommit) {
                connection.setAutoCommit(false);
            }
        }
    }

    private static String deriveLogPrefix(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("txn[");
        if (id != null) {
            sb.append(id);
        }
        sb.append("] ");
        return sb.toString();
    }

    public void setAutoPersistUpdates(boolean autoPersistUpdates) {
        this.autoPersistUpdates = autoPersistUpdates;
        this.batchMode = true;
    }

    @Override
    public boolean isAutoPersistUpdates() {
        return this.autoPersistUpdates;
    }

    @Override
    public boolean isSkipCacheExplicit() {
        return this.skipCache != null && this.skipCache == false;
    }

    public boolean isSkipCache() {
        if (this.skipCache != null) {
            return this.skipCache;
        }
        return this.skipCacheAfterWrite && !this.queryOnly;
    }

    public void setSkipCache(boolean skipCache) {
        this.skipCache = skipCache;
    }

    @Override
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public String toString() {
        if (this.active) {
            return this.logPrefix;
        }
        return this.logPrefix + "(inactive)";
    }

    @Override
    public void addBeanChange(BeanChange beanChange) {
        if (this.changeLogHolder == null) {
            this.changeLogHolder = new TChangeLogHolder(this, 100);
        }
        this.changeLogHolder.addBeanChange(beanChange);
    }

    @Override
    public void sendChangeLog(ChangeSet changesRequest) {
        if (this.manager != null) {
            this.manager.sendChangeLog(changesRequest);
        }
    }

    public void register(TransactionCallback callback) {
        if (this.callbackList == null) {
            this.callbackList = new ArrayList<TransactionCallback>(4);
        }
        this.callbackList.add(callback);
    }

    private void withEachCallback(Consumer<TransactionCallback> consumer) {
        if (this.callbackList != null) {
            for (int i = 0; i < this.callbackList.size(); ++i) {
                try {
                    consumer.accept(this.callbackList.get(i));
                    continue;
                }
                catch (Exception e) {
                    logger.error("Error executing transaction callback", (Throwable)e);
                }
            }
        }
    }

    private void firePreRollback() {
        this.withEachCallback(TransactionCallback::preRollback);
    }

    private void firePostRollback() {
        this.withEachCallback(TransactionCallback::postRollback);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postRollback();
        }
    }

    private void firePreCommit() {
        this.withEachCallback(TransactionCallback::preCommit);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.preCommit();
        }
    }

    private void firePostCommit() {
        this.withEachCallback(TransactionCallback::postCommit);
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postCommit();
        }
    }

    @Override
    public int getDocStoreBatchSize() {
        return this.docStoreBatchSize;
    }

    public void setDocStoreBatchSize(int docStoreBatchSize) {
        this.docStoreBatchSize = docStoreBatchSize;
    }

    @Override
    public DocStoreMode getDocStoreMode() {
        return this.docStoreMode;
    }

    public void setDocStoreMode(DocStoreMode docStoreMode) {
        this.docStoreMode = docStoreMode;
    }

    @Override
    public void registerDeferred(PersistDeferredRelationship derived) {
        if (this.deferredList == null) {
            this.deferredList = new ArrayList<PersistDeferredRelationship>();
        }
        this.deferredList.add(derived);
    }

    @Override
    public void registerDeleteBean(Integer persistingBean) {
        if (this.deletingBeansHash == null) {
            this.deletingBeansHash = new HashSet();
        }
        this.deletingBeansHash.add(persistingBean);
    }

    @Override
    public boolean isRegisteredDeleteBean(Integer persistingBean) {
        return this.deletingBeansHash != null && this.deletingBeansHash.contains(persistingBean);
    }

    @Override
    public void unregisterBeans() {
        this.persistingBeans.clear();
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        if (this.persistingBeans == null) {
            this.persistingBeans = new IdentityHashMap();
        }
        return this.persistingBeans.put(bean, PLACEHOLDER) != null;
    }

    @Override
    public boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        if (this.m2mIntersectionSave == null) {
            this.m2mIntersectionSave = new HashMap();
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        String existingBean = this.m2mIntersectionSave.get(intersectionTable);
        if (existingBean == null) {
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        return existingBean.equals(beanName);
    }

    @Override
    public void depth(int diff) {
        this.depth += diff;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public void markNotQueryOnly() {
        this.queryOnly = false;
    }

    public boolean isReadOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.localReadOnly = readOnly;
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setUpdateAllLoadedProperties(boolean updateAllLoadedProperties) {
        this.updateAllLoadedProperties = updateAllLoadedProperties;
    }

    @Override
    public Boolean isUpdateAllLoadedProperties() {
        return this.updateAllLoadedProperties;
    }

    public void setBatchMode(boolean batchMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchOnCascade(boolean batchMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchOnCascadeMode = batchMode;
    }

    public boolean isBatchOnCascade() {
        return this.batchOnCascadeMode;
    }

    @Override
    public Boolean getBatchGetGeneratedKeys() {
        return this.batchGetGeneratedKeys;
    }

    public void setGetGeneratedKeys(boolean getGeneratedKeys) {
        this.batchGetGeneratedKeys = getGeneratedKeys;
        if (this.batchControl != null) {
            this.batchControl.setGetGeneratedKeys(getGeneratedKeys);
        }
    }

    public void setFlushOnMixed(boolean batchFlushOnMixed) {
        this.batchFlushOnMixed = batchFlushOnMixed;
        if (this.batchControl != null) {
            this.batchControl.setBatchFlushOnMixed(batchFlushOnMixed);
        }
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.batchControl != null) {
            this.batchControl.setBatchSize(batchSize);
        }
    }

    public boolean isFlushOnQuery() {
        return this.batchFlushOnQuery;
    }

    public void setFlushOnQuery(boolean batchFlushOnQuery) {
        this.batchFlushOnQuery = batchFlushOnQuery;
    }

    @Override
    public boolean isBatchThisRequest() {
        return this.batchMode;
    }

    @Override
    public void checkBatchEscalationOnCollection() {
        if (!this.batchMode && this.batchOnCascadeMode) {
            this.batchMode = true;
            this.batchOnCascadeSet = true;
        }
    }

    @Override
    public void flushBatchOnCollection() {
        if (this.batchOnCascadeSet) {
            this.batchFlushReset();
            this.batchMode = false;
        }
    }

    private void batchFlush() {
        if (this.batchControl != null) {
            try {
                this.batchControl.flushOnCommit();
            }
            catch (BatchedSqlException e) {
                throw this.translate(e.getMessage(), e.getCause());
            }
        }
    }

    private void batchFlushReset() {
        if (this.batchControl != null) {
            try {
                this.batchControl.flushReset();
            }
            catch (BatchedSqlException e) {
                throw this.translate(e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public PersistenceException translate(String message, SQLException cause) {
        if (this.manager != null) {
            return this.manager.translate(message, cause);
        }
        return new PersistenceException(message, (Throwable)cause);
    }

    @Override
    public void flushBatchOnCascade() {
        this.batchFlushReset();
        this.batchMode = this.oldBatchMode;
    }

    @Override
    public void flushBatchOnRollback() {
        this.internalBatchClear();
        this.batchMode = this.oldBatchMode;
    }

    private void internalBatchClear() {
        if (this.batchControl != null) {
            this.batchControl.clear();
        }
    }

    @Override
    public boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        if (this.batchMode) {
            return false;
        }
        if (this.batchOnCascadeMode) {
            this.oldBatchMode = false;
            this.batchMode = true;
            this.batchFlushReset();
            request.setSkipBatchForTopLevel();
            return true;
        }
        this.batchFlushReset();
        return false;
    }

    @Override
    public BatchControl getBatchControl() {
        return this.batchControl;
    }

    @Override
    public void setBatchControl(BatchControl batchControl) {
        this.queryOnly = false;
        this.batchControl = batchControl;
        if (this.batchGetGeneratedKeys != null) {
            batchControl.setGetGeneratedKeys(this.batchGetGeneratedKeys);
        }
        if (this.batchSize != -1) {
            batchControl.setBatchSize(this.batchSize);
        }
        if (this.batchFlushOnMixed != null) {
            batchControl.setBatchFlushOnMixed(this.batchFlushOnMixed);
        }
    }

    public void flush() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.internalBatchFlush();
    }

    public void flushBatch() {
        this.flush();
    }

    private void internalBatchFlush() {
        if (this.autoPersistUpdates) {
            this.manager.flushTransparent(this.persistenceContext, this);
        }
        this.batchFlush();
        if (this.deferredList != null) {
            for (PersistDeferredRelationship deferred : this.deferredList) {
                deferred.execute(this);
            }
            this.batchFlush();
            this.deferredList.clear();
        }
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext context) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.persistenceContext = context;
    }

    @Override
    public TransactionEvent getEvent() {
        this.queryOnly = false;
        if (this.event == null) {
            this.event = new TransactionEvent();
        }
        return this.event;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public boolean isLogSql() {
        return this.logSql;
    }

    @Override
    public boolean isLogSummary() {
        return this.logSummary;
    }

    @Override
    public void logSql(String msg) {
        this.manager.log().sql().debug(Str.add(this.logPrefix, msg));
    }

    @Override
    public void logSummary(String msg) {
        this.manager.log().sum().debug(Str.add(this.logPrefix, msg));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object getTenantId() {
        return this.tenantId;
    }

    @Override
    public Connection getInternalConnection() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        return this.connection;
    }

    public Connection getConnection() {
        this.queryOnly = false;
        return this.getInternalConnection();
    }

    void deactivate() {
        try {
            if (this.localReadOnly) {
                this.connection.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            logger.error("Error setting to readOnly?", (Throwable)e);
        }
        try {
            if (this.autoCommit) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            logger.error("Error setting to readOnly?", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            logger.error("Error closing connection", (Throwable)ex);
        }
        this.connection = null;
        this.active = false;
        this.profileEnd();
    }

    void notifyCommit() {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfCommit(this);
            }
        }
    }

    private void connectionEndForQueryOnly() {
        try {
            if (this.onQueryOnly == DatabasePlatform.OnQueryOnly.COMMIT) {
                this.performCommit();
            } else {
                this.performRollback();
            }
        }
        catch (SQLException e) {
            logger.error("Error when ending a query only transaction via " + this.onQueryOnly, (Throwable)e);
        }
    }

    void performRollback() throws SQLException {
        long offset = this.profileOffset();
        this.connection.rollback();
        if (this.profileStream != null) {
            this.profileStream.addEvent("r", offset);
        }
    }

    void performCommit() throws SQLException {
        long offset = this.profileOffset();
        this.connection.commit();
        if (this.profileStream != null) {
            this.profileStream.addEvent("c", offset);
        }
    }

    private void profileEnd() {
        if (this.manager != null) {
            long exeMicros = (System.nanoTime() - this.startNanos) / 1000L;
            if (this.profileLocation != null) {
                this.profileLocation.add(exeMicros);
            } else if (this.label != null) {
                this.manager.collectMetricNamed(exeMicros, this.label);
            }
            this.manager.collectMetric(exeMicros);
            if (this.profileStream != null) {
                this.profileStream.end(this.manager);
            }
        }
    }

    private void flushCommitAndNotify() throws SQLException {
        this.preCommit();
        this.performCommit();
        this.postCommit();
    }

    @Override
    public void postCommit() {
        this.firePostCommit();
        this.notifyCommit();
    }

    @Override
    public void preCommit() {
        this.internalBatchFlush();
        this.firePreCommit();
    }

    public void commitAndContinue() {
        if (this.rollbackOnly) {
            return;
        }
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.flushCommitAndNotify();
            this.event = new TransactionEvent();
        }
        catch (Exception e) {
            this.doRollback(e);
            throw this.wrapIfNeeded(e);
        }
    }

    public void commit() {
        if (this.rollbackOnly) {
            this.rollback();
            return;
        }
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            if (this.queryOnly && !this.autoPersistUpdates) {
                this.connectionEndForQueryOnly();
            } else {
                this.flushCommitAndNotify();
            }
        }
        catch (Exception e) {
            this.doRollback(e);
            throw this.wrapIfNeeded(e);
        }
        finally {
            this.deactivate();
        }
    }

    private RuntimeException wrapIfNeeded(Exception e) {
        if (e instanceof PersistenceException) {
            return (PersistenceException)((Object)e);
        }
        return new RollbackException((Throwable)e);
    }

    void notifyRollback(Throwable cause) {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfRollback(this, cause);
            }
        }
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public boolean isNestedUseSavepoint() {
        return this.nestedUseSavepoint;
    }

    public void setNestedUseSavepoint() {
        this.nestedUseSavepoint = true;
    }

    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    public void rollback(Throwable cause) throws PersistenceException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.doRollback(cause);
        }
        finally {
            this.deactivate();
        }
    }

    private void doRollback(Throwable cause) {
        this.internalBatchClear();
        this.firePreRollback();
        try {
            this.performRollback();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            this.postRollback(cause);
        }
    }

    @Override
    public void postRollback(Throwable cause) {
        this.firePostRollback();
        this.notifyRollback(cause);
    }

    public void end() throws PersistenceException {
        if (this.isActive()) {
            this.rollback();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPersistCascade() {
        return this.persistCascade;
    }

    public void setPersistCascade(boolean persistCascade) {
        this.persistCascade = persistCascade;
    }

    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.getEvent().add(tableName, inserts, updates, deletes);
    }

    @Override
    public DocStoreTransaction getDocStoreTransaction() {
        if (this.docStoreTxn == null) {
            this.queryOnly = false;
            this.docStoreTxn = this.manager.createDocStoreTransaction(this.docStoreBatchSize);
        }
        return this.docStoreTxn;
    }

    public void putUserObject(String name, Object value) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, value);
    }

    public Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    public void close() {
        this.end();
    }
}

