/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebeaninternal.json.ModifyAwareList;
import io.ebeaninternal.json.ModifyAwareMap;
import io.ebeaninternal.json.ModifyAwareSet;
import io.ebeaninternal.server.type.CheckMarkedDirty;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonObjectMapper {
    public static ScalarType<?> createTypeFor(boolean postgres, AnnotatedField field, ObjectMapper objectMapper, int dbType, DocPropertyType docType) {
        Class type = field.getRawType();
        String pgType = ScalarTypeJsonObjectMapper.getPostgresType(postgres, dbType);
        if (Set.class.equals((Object)type)) {
            return new OmSet(objectMapper, field, dbType, pgType, docType);
        }
        if (List.class.equals((Object)type)) {
            return new OmList(objectMapper, field, dbType, pgType, docType);
        }
        if (Map.class.equals((Object)type)) {
            return new OmMap(objectMapper, field, dbType, pgType);
        }
        return new GenericObject(objectMapper, field, dbType, pgType);
    }

    private static String getPostgresType(boolean postgres, int dbType) {
        if (postgres) {
            switch (dbType) {
                case 5001: {
                    return "json";
                }
                case 5002: {
                    return "jsonb";
                }
            }
        }
        return null;
    }

    private static class OmSet
    extends Base<Set> {
        public OmSet(ObjectMapper objectMapper, AnnotatedField field, int dbType, String pgType, DocPropertyType docType) {
            super(Set.class, objectMapper, field, dbType, pgType, docType);
        }

        @Override
        public Set read(DataReader reader) throws SQLException {
            Set value = (Set)super.read(reader);
            return value == null ? null : new ModifyAwareSet(value);
        }
    }

    private static class OmList
    extends Base<List> {
        public OmList(ObjectMapper objectMapper, AnnotatedField field, int dbType, String pgType, DocPropertyType docType) {
            super(List.class, objectMapper, field, dbType, pgType, docType);
        }

        @Override
        public List read(DataReader reader) throws SQLException {
            List value = (List)super.read(reader);
            return value == null ? null : new ModifyAwareList(value);
        }
    }

    private static class OmMap
    extends Base<Map> {
        public OmMap(ObjectMapper objectMapper, AnnotatedField field, int dbType, String pgType) {
            super(Map.class, objectMapper, field, dbType, pgType, DocPropertyType.OBJECT);
        }

        @Override
        public Map read(DataReader reader) throws SQLException {
            Map value = (Map)super.read(reader);
            return value == null ? null : new ModifyAwareMap(value);
        }
    }

    private static class GenericObject
    extends Base<Object> {
        public GenericObject(ObjectMapper objectMapper, AnnotatedField field, int dbType, String pgType) {
            super(Object.class, objectMapper, field, dbType, pgType, DocPropertyType.OBJECT);
        }
    }

    private static abstract class Base<T>
    extends ScalarTypeBase<T> {
        private final ObjectWriter objectWriter;
        private final ObjectMapper objectReader;
        private JavaType deserType;
        private final String pgType;
        private final DocPropertyType docType;

        public Base(Class<T> cls, ObjectMapper objectMapper, AnnotatedField field, int dbType, String pgType, DocPropertyType docType) {
            super(cls, false, dbType);
            this.pgType = pgType;
            this.docType = docType;
            this.objectReader = objectMapper;
            JavaType javaType = field.getType();
            DeserializationConfig deserConfig = objectMapper.getDeserializationConfig();
            AnnotationIntrospector ai = deserConfig.getAnnotationIntrospector();
            if (ai != null && javaType != null && !javaType.hasRawClass(Object.class)) {
                try {
                    this.deserType = ai.refineDeserializationType((MapperConfig)deserConfig, (Annotated)field, javaType);
                }
                catch (JsonMappingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.deserType = javaType;
            }
            SerializationConfig serConfig = objectMapper.getSerializationConfig();
            ai = deserConfig.getAnnotationIntrospector();
            if (ai != null && javaType != null && !javaType.hasRawClass(Object.class)) {
                try {
                    JavaType serType = ai.refineSerializationType((MapperConfig)serConfig, (Annotated)field, javaType);
                    this.objectWriter = objectMapper.writerFor(serType);
                }
                catch (JsonMappingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.objectWriter = objectMapper.writerFor(javaType);
            }
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public boolean isDirty(Object value) {
            return CheckMarkedDirty.isDirty(value);
        }

        public T read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return (T)this.objectReader.readValue(json, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, json, (Exception)e);
            }
        }

        public void bind(DataBinder binder, T value) throws SQLException {
            if (this.pgType != null) {
                String rawJson = value == null ? null : this.formatValue(value);
                binder.setObject(PostgresHelper.asObject(this.pgType, rawJson));
            } else if (value == null) {
                binder.setNull(12);
            } else {
                try {
                    String json = this.objectWriter.writeValueAsString(value);
                    binder.setString(json);
                }
                catch (JsonProcessingException e) {
                    throw new SQLException("Unable to create JSON", e);
                }
            }
        }

        public Object toJdbcType(Object value) {
            return value;
        }

        public T toBeanType(Object value) {
            return (T)value;
        }

        public String formatValue(T value) {
            try {
                return this.objectWriter.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new PersistenceException("Unable to create JSON", (Throwable)e);
            }
        }

        public T parse(String value) {
            try {
                return (T)this.objectReader.readValue(value, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, value, (Exception)e);
            }
        }

        public DocPropertyType getDocType() {
            return this.docType;
        }

        public boolean isDateTimeCapable() {
            return false;
        }

        public T convertFromMillis(long dateTime) {
            throw new IllegalStateException("Not supported");
        }

        public T jsonRead(JsonParser parser) throws IOException {
            return (T)this.objectReader.readValue(parser, this.deserType);
        }

        public void jsonWrite(JsonGenerator writer, T value) throws IOException {
            this.objectWriter.writeValue(writer, value);
        }

        public T readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        public void writeData(DataOutput dataOutput, T value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }
}

