/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.MonthDay;

public class ScalarTypeMonthDay
extends ScalarTypeBase<MonthDay> {
    protected final int year;

    public ScalarTypeMonthDay() {
        this(2000);
    }

    public ScalarTypeMonthDay(int year) {
        super(MonthDay.class, false, 91);
        this.year = year;
    }

    private MonthDay convertFromDate(Date ts) {
        LocalDate localDate = ts.toLocalDate();
        return MonthDay.of(localDate.getMonthValue(), localDate.getDayOfMonth());
    }

    private Date convertToDate(MonthDay value) {
        return Date.valueOf(LocalDate.of(2000, value.getMonthValue(), value.getDayOfMonth()));
    }

    public MonthDay read(DataReader reader) throws SQLException {
        Date ts = reader.getDate();
        return ts == null ? null : this.convertFromDate(ts);
    }

    public void bind(DataBinder binder, MonthDay value) throws SQLException {
        if (value == null) {
            binder.setNull(91);
        } else {
            binder.setDate(this.convertToDate(value));
        }
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Date) {
            return value;
        }
        return this.convertToDate((MonthDay)value);
    }

    public MonthDay toBeanType(Object value) {
        if (value instanceof MonthDay) {
            return (MonthDay)value;
        }
        if (value == null) {
            return null;
        }
        return this.convertFromDate((Date)value);
    }

    public String formatValue(MonthDay value) {
        return value.toString();
    }

    public MonthDay parse(String value) {
        return MonthDay.parse(value);
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public MonthDay convertFromMillis(long dateTime) {
        throw new RuntimeException("Not supported on this type");
    }

    public MonthDay readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        int month = dataInput.readInt();
        int day = dataInput.readInt();
        return MonthDay.of(month, day);
    }

    public void writeData(DataOutput dataOutput, MonthDay value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.write(value.getMonthValue());
            dataOutput.write(value.getDayOfMonth());
        }
    }

    public MonthDay jsonRead(JsonParser parser) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    public void jsonWrite(JsonGenerator writer, MonthDay value) throws IOException {
        writer.writeString(this.format(value));
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.KEYWORD;
    }
}

