/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.Database;
import io.ebean.config.BackgroundExecutorWrapper;
import io.ebean.config.ContainerConfig;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DatabaseConfigProvider;
import io.ebean.config.EntityClassRegister;
import io.ebean.config.NamingConvention;
import io.ebean.config.TenantMode;
import io.ebean.config.UnderscoreNamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.event.ShutdownManager;
import io.ebean.service.SpiContainer;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.core.DatabasePlatformFactory;
import io.ebeaninternal.server.core.DefaultServer;
import io.ebeaninternal.server.core.InitDataSource;
import io.ebeaninternal.server.core.InternalConfiguration;
import io.ebeaninternal.server.core.bootup.BootupClassPathSearch;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.executor.DefaultBackgroundExecutor;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;

public final class DefaultContainer
implements SpiContainer {
    private static final System.Logger log = CoreLog.log;
    private final ReentrantLock lock = new ReentrantLock();
    private final ClusterManager clusterManager;

    public DefaultContainer(ContainerConfig containerConfig) {
        this.clusterManager = new ClusterManager(containerConfig);
        ShutdownManager.registerContainer((SpiContainer)this);
    }

    public void shutdown() {
        this.clusterManager.shutdown();
        ShutdownManager.shutdown();
    }

    public SpiEbeanServer createServer(String name) {
        DatabaseConfig config = new DatabaseConfig();
        config.setName(name);
        config.loadFromProperties();
        return this.createServer(config);
    }

    private SpiBackgroundExecutor createBackgroundExecutor(DatabaseConfig config) {
        String namePrefix = "ebean-" + config.getName();
        int schedulePoolSize = config.getBackgroundExecutorSchedulePoolSize();
        int shutdownSecs = config.getBackgroundExecutorShutdownSecs();
        BackgroundExecutorWrapper wrapper = config.getBackgroundExecutorWrapper();
        return new DefaultBackgroundExecutor(schedulePoolSize, shutdownSecs, namePrefix, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiEbeanServer createServer(DatabaseConfig config) {
        this.lock.lock();
        try {
            long start = System.currentTimeMillis();
            this.applyConfigServices(config);
            this.setNamingConvention(config);
            BootupClasses bootupClasses = this.bootupClasses(config);
            boolean online = true;
            if (config.isDocStoreOnly()) {
                config.setDatabasePlatform(new DatabasePlatform());
            } else {
                TenantMode tenantMode = config.getTenantMode();
                if (TenantMode.DB != tenantMode) {
                    this.setDataSource(config);
                    if (!tenantMode.isDynamicDataSource()) {
                        online = this.checkDataSource(config);
                    }
                }
            }
            this.setDatabasePlatform(config);
            if (config.getDbEncrypt() != null) {
                config.getDatabasePlatform().setDbEncrypt(config.getDbEncrypt());
            }
            config.getNamingConvention().setDatabasePlatform(config.getDatabasePlatform());
            SpiBackgroundExecutor executor = this.createBackgroundExecutor(config);
            InternalConfiguration c = new InternalConfiguration(online, this.clusterManager, executor, config, bootupClasses);
            DefaultServer server = new DefaultServer(c, c.cacheManager());
            if (!DbOffline.isGenerateMigration()) {
                this.startServer(online, server);
            }
            DbOffline.reset();
            log.log(System.Logger.Level.INFO, "Started database[{0}] platform[{1}] in {2}ms", config.getName(), config.getDatabasePlatform().platform(), System.currentTimeMillis() - start);
            DefaultServer defaultServer = server;
            return defaultServer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void applyConfigServices(DatabaseConfig config) {
        if (config.isDefaultServer()) {
            for (DatabaseConfigProvider configProvider : ServiceLoader.load(DatabaseConfigProvider.class)) {
                configProvider.apply(config);
            }
        }
        if (config.isAutoLoadModuleInfo()) {
            boolean found = false;
            for (EntityClassRegister loader : ServiceLoader.load(EntityClassRegister.class)) {
                config.addAll(loader.classesFor(config.getName(), config.isDefaultServer()));
                found = true;
            }
            if (!found) {
                this.checkMissingModulePathProvides();
            }
        }
    }

    private void checkMissingModulePathProvides() {
        URL servicesFile = ClassLoader.getSystemResource("META-INF/services/io.ebean.config.EntityClassRegister");
        if (servicesFile != null) {
            log.log(System.Logger.Level.ERROR, "module-info.java is probably missing 'provides io.ebean.config.EntityClassRegister with EbeanEntityRegister' clause. EntityClassRegister exists but was not service loaded.");
        }
    }

    private void startServer(boolean online, DefaultServer server) {
        server.executePlugins(online);
        server.initialise();
        if (online && this.clusterManager.isClustering()) {
            this.clusterManager.registerServer((Database)server);
        }
        server.start();
    }

    private BootupClasses bootupClasses(DatabaseConfig config) {
        BootupClasses bootup = this.bootupClasses1(config);
        bootup.addIdGenerators(config.getIdGenerators());
        bootup.addPersistControllers(config.getPersistControllers());
        bootup.addPostLoaders(config.getPostLoaders());
        bootup.addPostConstructListeners(config.getPostConstructListeners());
        bootup.addFindControllers(config.getFindControllers());
        bootup.addPersistListeners(config.getPersistListeners());
        bootup.addQueryAdapters(config.getQueryAdapters());
        bootup.addServerConfigStartup(config.getServerConfigStartupListeners());
        bootup.addChangeLogInstances(config);
        bootup.runServerConfigStartup(config);
        return bootup;
    }

    private BootupClasses bootupClasses1(DatabaseConfig config) {
        List entityClasses = config.getClasses();
        if (config.isDisableClasspathSearch() || entityClasses != null && !entityClasses.isEmpty()) {
            return new BootupClasses(entityClasses);
        }
        return BootupClassPathSearch.search(config);
    }

    private void setNamingConvention(DatabaseConfig config) {
        if (config.getNamingConvention() == null) {
            config.setNamingConvention((NamingConvention)new UnderscoreNamingConvention());
        }
    }

    private void setDatabasePlatform(DatabaseConfig config) {
        DatabasePlatform platform = config.getDatabasePlatform();
        if (platform == null) {
            if (config.getTenantMode().isDynamicDataSource()) {
                throw new IllegalStateException("DatabasePlatform must be explicitly set on DatabaseConfig for TenantMode " + config.getTenantMode());
            }
            platform = new DatabasePlatformFactory().create(config);
            config.setDatabasePlatform(platform);
        }
        platform.configure(config.getPlatformConfig());
    }

    private void setDataSource(DatabaseConfig config) {
        if (this.isOfflineMode(config)) {
            log.log(System.Logger.Level.DEBUG, "... DbOffline using platform [{0}]", DbOffline.getPlatform());
        } else {
            InitDataSource.init(config);
        }
    }

    private boolean isOfflineMode(DatabaseConfig config) {
        return config.isDbOffline() || DbOffline.isSet();
    }

    private boolean checkDataSource(DatabaseConfig config) {
        boolean bl;
        block13: {
            if (this.isOfflineMode(config)) {
                return false;
            }
            if (config.getDataSource() == null) {
                if (config.getDataSourceConfig().isOffline()) {
                    return false;
                }
                throw new RuntimeException("DataSource not set?");
            }
            if (config.skipDataSourceCheck()) {
                return true;
            }
            Connection connection = config.getDataSource().getConnection();
            try {
                if (connection.getAutoCommit()) {
                    log.log(System.Logger.Level.WARNING, "DataSource [{0}] has autoCommit defaulting to true!", config.getName());
                }
                bl = true;
                if (connection == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
            connection.close();
        }
        return bl;
    }
}

