/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonToken;
import io.ebean.ValuePair;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.MutableValueInfo;
import io.ebean.bean.PersistenceContext;
import io.ebean.config.EncryptKey;
import io.ebean.config.dbplatform.DbEncryptFunction;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.plugin.Property;
import io.ebean.text.StringParser;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanPropertyOverride;
import io.ebeaninternal.server.deploy.DbMigrationInfo;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedWhenCreated;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedWhenModified;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.el.ElPropertyChainBuilder;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.properties.BeanPropertyGetter;
import io.ebeaninternal.server.properties.BeanPropertySetter;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.SqlBeanLoad;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.type.LocalEncryptedType;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeBoolean;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import io.ebeaninternal.server.type.ScalarTypeLogicalType;
import io.ebeaninternal.util.ValueUtil;
import io.ebeanservice.docstore.api.mapping.DocMappingBuilder;
import io.ebeanservice.docstore.api.mapping.DocPropertyMapping;
import io.ebeanservice.docstore.api.mapping.DocPropertyOptions;
import io.ebeanservice.docstore.api.support.DocStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public class BeanProperty
implements ElPropertyValue,
Property,
STreeProperty {
    private static final String ENC_PREFIX = " zx__";
    private final boolean id;
    private final boolean importedPrimaryKey;
    private final boolean unidirectionalShadow;
    private final boolean discriminator;
    final boolean embedded;
    private final boolean version;
    private final boolean naturalKey;
    private final boolean nullable;
    private final boolean unique;
    private final boolean dbRead;
    private final boolean dbInsertable;
    private final boolean dbUpdatable;
    private final boolean secondaryTable;
    private final TableJoin secondaryTableJoin;
    private final String secondaryTableJoinPrefix;
    private final boolean inherited;
    private final Class<?> owningType;
    private final boolean local;
    private final boolean lob;
    private final boolean fetchEager;
    final boolean isTransient;
    final String name;
    final int propertyIndex;
    private final Field field;
    private final Class<?> propertyType;
    private final String dbBind;
    final String dbColumn;
    private final String elPrefix;
    final String elPlaceHolder;
    final String elPlaceHolderEncrypted;
    private final String sqlFormulaSelect;
    final String sqlFormulaJoin;
    private final String aggregation;
    private final boolean formula;
    private final boolean dbEncrypted;
    private final boolean localEncrypted;
    private final int dbEncryptedType;
    private final int dbType;
    final boolean excludedFromHistory;
    private final GeneratedProperty generatedProperty;
    private final BeanPropertyGetter getter;
    private final BeanPropertySetter setter;
    final BeanDescriptor<?> descriptor;
    final ScalarType scalarType;
    private final DocPropertyOptions docOptions;
    private final int dbLength;
    private final int dbScale;
    private final String dbColumnDefn;
    private final String dbColumnDefault;
    private final List<DbMigrationInfo> dbMigrationInfos;
    private final String dbComment;
    private final DbEncryptFunction dbEncryptFunction;
    private int deployOrder;
    final boolean jsonSerialize;
    final boolean jsonDeserialize;
    private final boolean unmappedJson;
    private final boolean tenantId;
    private final boolean draft;
    private final boolean draftOnly;
    private final boolean draftDirty;
    private final boolean draftReset;
    private final boolean softDelete;
    private final String softDeleteDbSet;
    private final String softDeleteDbPredicate;

    public BeanProperty(DeployBeanProperty deploy) {
        this(null, deploy);
    }

    public BeanProperty(BeanDescriptor<?> descriptor, DeployBeanProperty deploy) {
        this.descriptor = descriptor;
        this.name = InternString.intern(deploy.getName());
        this.propertyIndex = deploy.getPropertyIndex();
        this.unidirectionalShadow = deploy.isUndirectionalShadow();
        this.importedPrimaryKey = deploy.isImportedPrimaryKey();
        this.discriminator = deploy.isDiscriminator();
        this.localEncrypted = deploy.isLocalEncrypted();
        this.dbEncrypted = deploy.isDbEncrypted();
        this.dbEncryptedType = deploy.getDbEncryptedType();
        this.dbEncryptFunction = deploy.getDbEncryptFunction();
        this.dbBind = deploy.getDbBind();
        this.dbRead = deploy.isDbRead();
        this.dbInsertable = deploy.isDbInsertable();
        this.dbUpdatable = deploy.isDbUpdateable();
        this.excludedFromHistory = deploy.isExcludedFromHistory();
        this.unmappedJson = deploy.isUnmappedJson();
        this.tenantId = deploy.isTenantId();
        this.draft = deploy.isDraft();
        this.draftDirty = deploy.isDraftDirty();
        this.draftOnly = deploy.isDraftOnly();
        this.draftReset = deploy.isDraftReset();
        this.secondaryTable = deploy.isSecondaryTable();
        if (this.secondaryTable) {
            this.secondaryTableJoin = new TableJoin(deploy.getSecondaryTableJoin());
            this.secondaryTableJoinPrefix = deploy.getSecondaryTableJoinPrefix();
        } else {
            this.secondaryTableJoin = null;
            this.secondaryTableJoinPrefix = null;
        }
        this.fetchEager = deploy.isFetchEager();
        this.isTransient = deploy.isTransient();
        this.nullable = deploy.isNullable();
        this.unique = deploy.isUnique();
        this.naturalKey = deploy.isNaturalKey();
        this.dbLength = deploy.getDbLength();
        this.dbScale = deploy.getDbScale();
        this.dbColumnDefn = InternString.intern(deploy.getDbColumnDefn());
        this.dbColumnDefault = deploy.getDbColumnDefaultSqlLiteral();
        this.dbMigrationInfos = deploy.getDbMigrationInfos();
        this.inherited = false;
        this.owningType = deploy.getOwningType();
        this.local = deploy.isLocal();
        this.version = deploy.isVersionColumn();
        this.embedded = deploy.isEmbedded();
        this.id = deploy.isId();
        this.generatedProperty = deploy.getGeneratedProperty();
        this.getter = deploy.getGetter();
        this.setter = deploy.getSetter();
        this.aggregation = deploy.parseAggregation();
        this.dbColumn = this.tableAliasIntern(descriptor, deploy.getDbColumn(), false, null);
        this.dbComment = deploy.getDbComment();
        this.sqlFormulaJoin = InternString.intern(deploy.getSqlFormulaJoin());
        this.sqlFormulaSelect = InternString.intern(deploy.getSqlFormulaSelect());
        this.formula = this.sqlFormulaSelect != null;
        this.dbType = deploy.getDbType();
        this.scalarType = deploy.getScalarType();
        this.lob = BeanProperty.isLobType(this.dbType);
        this.propertyType = deploy.getPropertyType();
        this.field = deploy.getField();
        this.docOptions = deploy.getDocPropertyOptions();
        this.elPlaceHolder = this.tableAliasIntern(descriptor, deploy.getElPlaceHolder(), false, null);
        this.elPlaceHolderEncrypted = this.tableAliasIntern(descriptor, deploy.getElPlaceHolder(), this.dbEncrypted, this.dbColumn);
        this.elPrefix = deploy.getElPrefix();
        this.softDelete = deploy.isSoftDelete();
        if (this.softDelete) {
            ScalarTypeBoolean.BooleanBase boolType = (ScalarTypeBoolean.BooleanBase)this.scalarType;
            this.softDeleteDbSet = this.dbColumn + "=" + boolType.getDbTrueLiteral();
            this.softDeleteDbPredicate = "." + this.dbColumn + " = " + boolType.getDbFalseLiteral();
        } else {
            this.softDeleteDbSet = null;
            this.softDeleteDbPredicate = null;
        }
        this.jsonSerialize = deploy.isJsonSerialize();
        this.jsonDeserialize = deploy.isJsonDeserialize();
    }

    private String tableAliasIntern(BeanDescriptor<?> descriptor, String s, boolean dbEncrypted, String dbColumn) {
        if (s != null && descriptor != null) {
            s = s.replace("${ta}.", "${}");
            s = s.replace("${ta}", "${}");
            if (dbEncrypted) {
                s = this.dbEncryptFunction.getDecryptSql(s);
                String namedParam = ":encryptkey_" + descriptor.baseTable() + "___" + dbColumn;
                s = s.replace("?", namedParam);
            }
        }
        return InternString.intern(s);
    }

    public BeanProperty override(BeanPropertyOverride override) {
        return new BeanProperty(this, override);
    }

    protected BeanProperty(BeanProperty source, BeanPropertyOverride override) {
        this.descriptor = source.descriptor;
        this.propertyIndex = source.propertyIndex;
        this.name = source.name();
        this.dbColumn = override.getDbColumn();
        this.nullable = override.isDbNullable();
        this.dbLength = override.getDbLength();
        this.dbScale = override.getDbScale();
        this.dbColumnDefn = InternString.intern(override.getDbColumnDefn());
        this.sqlFormulaJoin = null;
        this.sqlFormulaSelect = null;
        this.formula = false;
        this.aggregation = null;
        this.excludedFromHistory = source.excludedFromHistory;
        this.tenantId = source.tenantId;
        this.draft = source.draft;
        this.draftDirty = source.draftDirty;
        this.draftOnly = source.draftOnly;
        this.draftReset = source.draftReset;
        this.softDelete = source.softDelete;
        this.softDeleteDbSet = source.softDeleteDbSet;
        this.softDeleteDbPredicate = source.softDeleteDbPredicate;
        this.fetchEager = source.fetchEager;
        this.importedPrimaryKey = source.importedPrimaryKey;
        this.unidirectionalShadow = source.unidirectionalShadow;
        this.discriminator = source.discriminator;
        this.localEncrypted = source.isLocalEncrypted();
        this.isTransient = source.isTransient();
        this.secondaryTable = source.isSecondaryTable();
        this.secondaryTableJoin = source.secondaryTableJoin;
        this.secondaryTableJoinPrefix = source.secondaryTableJoinPrefix;
        this.dbComment = source.dbComment;
        this.dbBind = source.dbBind();
        this.dbEncrypted = source.isDbEncrypted();
        this.dbEncryptedType = source.dbEncryptedType();
        this.dbEncryptFunction = source.dbEncryptFunction;
        this.dbRead = source.isDbRead();
        this.dbInsertable = source.isDbInsertable();
        this.dbUpdatable = source.isDbUpdatable();
        this.unique = source.isUnique();
        this.naturalKey = source.isNaturalKey();
        this.dbColumnDefault = source.dbColumnDefault;
        this.dbMigrationInfos = source.dbMigrationInfos;
        this.inherited = source.isInherited();
        this.owningType = source.owningType;
        this.local = this.owningType.equals(this.descriptor.type());
        this.version = source.isVersion();
        this.embedded = source.isEmbedded();
        this.id = source.isId();
        this.generatedProperty = source.generatedProperty();
        this.getter = source.getter;
        this.setter = source.setter;
        this.dbType = source.dbType(true);
        this.scalarType = source.scalarType;
        this.lob = BeanProperty.isLobType(this.dbType);
        this.propertyType = source.type();
        this.field = source.field();
        this.docOptions = source.docOptions;
        this.unmappedJson = source.unmappedJson;
        this.elPrefix = override.replace(source.elPrefix, source.dbColumn);
        this.elPlaceHolder = override.replace(source.elPlaceHolder, source.dbColumn);
        this.elPlaceHolderEncrypted = override.replace(source.elPlaceHolderEncrypted, source.dbColumn);
        this.jsonSerialize = source.jsonSerialize;
        this.jsonDeserialize = source.jsonDeserialize;
    }

    public void initialise(BeanDescriptorInitContext initContext) {
        if (!this.isTransient && this.scalarType == null) {
            throw new RuntimeException("No ScalarType assigned to " + this.descriptor.fullName() + "." + this.name());
        }
    }

    public int deployOrder() {
        return this.deployOrder;
    }

    public void setDeployOrder(int deployOrder) {
        this.deployOrder = deployOrder;
    }

    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        return null;
    }

    public BeanDescriptor<?> descriptor() {
        return this.descriptor;
    }

    public boolean isScalar() {
        return true;
    }

    public boolean isDDLColumn() {
        return !this.formula && !this.secondaryTable && this.aggregation == null;
    }

    @Override
    public boolean isFormula() {
        return this.formula;
    }

    public boolean isDiscriminator() {
        return this.discriminator;
    }

    public boolean isMutableScalarType() {
        return this.scalarType != null && this.scalarType.mutable();
    }

    public EncryptKey encryptKey() {
        return this.descriptor.encryptKey(this);
    }

    @Override
    public String encryptKeyAsString() {
        return this.encryptKey().getStringValue();
    }

    public String decryptProperty(String propertyName) {
        return this.dbEncryptFunction.getDecryptSql(propertyName);
    }

    private String decryptSqlWithColumnAlias(String tableAlias) {
        return this.dbEncryptFunction.getDecryptSql(tableAlias + "." + this.dbColumn()) + ENC_PREFIX + tableAlias + "_" + this.dbColumn();
    }

    @Override
    public int fetchPreference() {
        return 1000;
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType, String manyWhere) {
        if (this.formula && this.sqlFormulaJoin != null) {
            ctx.appendFormulaJoin(this.sqlFormulaJoin, joinType, manyWhere);
        } else if (this.secondaryTableJoin != null) {
            String relativePrefix = ctx.relativePrefix(this.secondaryTableJoinPrefix);
            this.secondaryTableJoin.addJoin(joinType, relativePrefix, ctx);
        }
    }

    public String secondaryTableJoinPrefix() {
        return this.secondaryTableJoinPrefix;
    }

    @Override
    public boolean isAggregation() {
        return this.aggregation != null;
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        if (this.aggregation != null) {
            ctx.appendFormulaSelect(this.aggregation);
        } else if (this.formula) {
            ctx.appendFormulaSelect(this.sqlFormulaSelect);
        } else if (!this.isTransient && !this.ignoreDraftOnlyProperty(ctx.isDraftQuery())) {
            if (this.secondaryTableJoin != null) {
                ctx.pushTableAlias(ctx.relativePrefix(this.secondaryTableJoinPrefix));
            }
            if (this.dbEncrypted) {
                ctx.appendRawColumn(this.decryptSqlWithColumnAlias(ctx.peekTableAlias()));
                ctx.addEncryptedProp(this);
            } else {
                ctx.appendColumn(this.dbColumn);
            }
            if (this.secondaryTableJoin != null) {
                ctx.popTableAlias();
            }
        }
    }

    public boolean isMany() {
        return false;
    }

    public boolean isAssignableFrom(Class<?> type) {
        return this.owningType.isAssignableFrom(type);
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        ctx.dataReader().incrementPos(1);
    }

    @Override
    public void load(SqlBeanLoad sqlBeanLoad) {
        sqlBeanLoad.load(this);
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        if (prefix == null) {
            selectChain.add(this.name);
        } else {
            selectChain.add(prefix + "." + this.name);
        }
    }

    public Object read(DataReader reader) throws SQLException {
        return this.scalarType.read(reader);
    }

    public Object readSet(DataReader reader, EntityBean bean) throws SQLException {
        try {
            Object value = this.scalarType.read(reader);
            if (bean != null) {
                this.setValue(bean, value);
            }
            return value;
        }
        catch (Exception e) {
            throw new PersistenceException("Error readSet on " + this.descriptor + "." + this.name, (Throwable)e);
        }
    }

    public Object read(DbReadContext ctx) throws SQLException {
        return this.scalarType.read(ctx.dataReader());
    }

    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        return this.readSet(ctx.dataReader(), bean);
    }

    public void bind(DataBind b, Object value) throws SQLException {
        this.scalarType.bind((DataBinder)b, value);
    }

    public void writeData(DataOutput dataOutput, Object value) throws IOException {
        this.scalarType.writeData(dataOutput, value);
    }

    public Object readData(DataInput dataInput) throws IOException {
        return this.scalarType.readData(dataInput);
    }

    @Override
    public BeanProperty beanProperty() {
        return this;
    }

    public Property property() {
        return this;
    }

    private boolean isInherited() {
        return this.inherited;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void publish(EntityBean draftBean, EntityBean liveBean) {
        if (!this.version && !this.draftOnly) {
            Object value = this.getValueIntercept(draftBean);
            this.setValueIntercept(liveBean, value);
        }
    }

    String softDeleteDbSet() {
        return this.softDeleteDbSet;
    }

    String softDeleteDbPredicate(String tableAlias) {
        return tableAlias + this.softDeleteDbPredicate;
    }

    void setSoftDeleteValue(EntityBean bean) {
        this.setValue(bean, true);
        bean._ebean_getIntercept().setChangedProperty(this.propertyIndex);
    }

    public void setValueChanged(EntityBean bean, Object value) {
        this.setValue(bean, value);
        bean._ebean_getIntercept().setChangedProperty(this.propertyIndex);
    }

    public void addTenant(SpiQuery<?> query, Object tenantId) {
        query.where().eq(this.name, tenantId);
    }

    public void setTenantValue(EntityBean entityBean, Object tenantId) {
        this.setValue(entityBean, tenantId);
    }

    public void setValue(EntityBean bean, Object value) {
        try {
            this.setter.set(bean, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.setterErrorMsg(bean, value, "set "), ex);
        }
    }

    public void setValueIntercept(EntityBean bean, Object value) {
        try {
            this.setter.setIntercept(bean, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.setterErrorMsg(bean, value, "setIntercept "), ex);
        }
    }

    private String setterErrorMsg(EntityBean bean, Object value, String prefix) {
        String beanType = bean == null ? "null" : bean.getClass().getName();
        return prefix + this.name + " on [" + this.descriptor + "] arg[" + value + "] type[" + beanType + "] threw error";
    }

    public boolean isCacheDataInclude() {
        return true;
    }

    public Object getCacheDataValue(EntityBean bean) {
        return this.cacheDataConvert(this.getValue(bean));
    }

    public Object getCacheDataValueOrig(EntityBeanIntercept ebi) {
        return this.cacheDataConvert(ebi.getOrigValue(this.propertyIndex));
    }

    private Object cacheDataConvert(Object value) {
        if (value == null || this.scalarType.binary()) {
            return value;
        }
        return this.scalarType.format(value);
    }

    public String format(Object value) {
        return this.scalarType.format(value);
    }

    public Object parse(String value) {
        return this.scalarType.parse(value);
    }

    public MutableValueInfo createMutableInfo(String json) {
        throw new UnsupportedOperationException();
    }

    public void setCacheDataValue(EntityBean bean, Object cacheData, PersistenceContext context) {
        if (cacheData instanceof String) {
            cacheData = this.scalarType.parse((String)cacheData);
        }
        this.setValue(bean, cacheData);
    }

    Object naturalKeyVal(Map<String, Object> values) {
        return values.get(this.name);
    }

    public Object value(Object bean) {
        return this.getValue((EntityBean)bean);
    }

    public Object getValue(EntityBean bean) {
        try {
            return this.getter.get(bean);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "get " + this.name + " on [" + this.descriptor + "] type[" + beanType + "] threw error.";
            throw new RuntimeException(msg, ex);
        }
    }

    public Object getValueIntercept(EntityBean bean) {
        try {
            return this.getter.getIntercept(bean);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "getIntercept " + this.name + " on [" + this.descriptor + "] type[" + beanType + "] threw error.";
            throw new RuntimeException(msg, ex);
        }
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        return this.convertToLogicalType(value);
    }

    public void pathSet(Object bean, Object value) {
        if (bean != null) {
            Object logicalVal = this.convertToLogicalType(value);
            this.setValueIntercept((EntityBean)bean, logicalVal);
        }
    }

    public Object pathGet(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getValueIntercept((EntityBean)bean);
    }

    @Override
    public Object pathGetNested(Object bean) {
        throw new RuntimeException("Not expected to call this");
    }

    @Override
    public String name() {
        return this.name;
    }

    public int propertyIndex() {
        return this.propertyIndex;
    }

    @Override
    public String elName() {
        return this.name;
    }

    @Override
    public boolean containsFormulaWithJoin() {
        return this.formula && this.sqlFormulaJoin != null;
    }

    @Override
    public boolean containsManySince(String sinceProperty) {
        return this.containsMany();
    }

    @Override
    public boolean containsMany() {
        return this.aggregation != null;
    }

    @Override
    public String assocIsEmpty(SpiExpressionRequest request, String path) {
        throw new RuntimeException("Not Supported or Expected");
    }

    public Object[] assocIdValues(EntityBean bean) {
        return null;
    }

    public String assocIdExpression(String prefix, String operator) {
        return null;
    }

    @Override
    public String assocIdInExpr(String prefix) {
        return null;
    }

    @Override
    public String assocIdInValueExpr(boolean not, int size) {
        return null;
    }

    public boolean isImportedPrimaryKey() {
        return this.importedPrimaryKey;
    }

    @Override
    public boolean isAssocMany() {
        return false;
    }

    @Override
    public boolean isAssocId() {
        return false;
    }

    @Override
    public boolean isAssocProperty() {
        return false;
    }

    @Override
    public String elPlaceholder(boolean encrypted) {
        return encrypted ? this.elPlaceHolderEncrypted : this.elPlaceHolder;
    }

    @Override
    public String elPrefix() {
        return this.elPrefix;
    }

    @Override
    public String fullName() {
        return this.descriptor.fullName() + "." + this.name;
    }

    boolean checkMutable(Object value, boolean alreadyDirty, EntityBeanIntercept ebi) {
        return alreadyDirty || value != null && this.scalarType.isDirty(value);
    }

    public boolean isArrayType() {
        return this.scalarType instanceof ScalarTypeArray;
    }

    public ScalarType<Object> scalarType() {
        return this.scalarType;
    }

    public StringParser stringParser() {
        return this.scalarType;
    }

    public int jdbcType() {
        return this.scalarType == null ? 0 : this.scalarType.jdbcType();
    }

    public int dbLength() {
        return this.dbLength;
    }

    public int dbScale() {
        return this.dbScale;
    }

    public String dbColumnDefn() {
        return this.dbColumnDefn;
    }

    public Set<String> dbCheckConstraintValues() {
        if (this.scalarType instanceof ScalarTypeEnum) {
            return ((ScalarTypeEnum)this.scalarType).getDbCheckConstraintValues();
        }
        return null;
    }

    public String renderDbType(DbPlatformType dbType, boolean strict) {
        if (this.dbColumnDefn != null) {
            if (this.dbColumnDefn.endsWith(";")) {
                return this.dbColumnDefn + dbType.renderType(this.dbLength, this.dbScale, strict);
            }
            return this.dbColumnDefn;
        }
        return dbType.renderType(this.dbLength, this.dbScale, strict);
    }

    public String dbColumnDefault() {
        return this.dbColumnDefault;
    }

    public List<DbMigrationInfo> dbMigrationInfos() {
        return this.dbMigrationInfos;
    }

    private Field field() {
        return this.field;
    }

    public GeneratedProperty generatedProperty() {
        return this.generatedProperty;
    }

    public boolean isNaturalKey() {
        return this.naturalKey;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isDDLNotNull() {
        return this.isVersion() || this.generatedProperty != null && this.generatedProperty.isDDLNotNullable();
    }

    boolean isGeneratedOnInsert() {
        return this.generatedProperty != null && this.generatedProperty.includeInInsert();
    }

    boolean isGeneratedWhenCreated() {
        return this.generatedProperty instanceof GeneratedWhenCreated;
    }

    boolean isGeneratedWhenModified() {
        return this.generatedProperty instanceof GeneratedWhenModified;
    }

    public boolean isGenerated() {
        return this.id || this.generatedProperty != null;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isLoadProperty(boolean draftQuery) {
        return !this.ignoreDraftOnlyProperty(draftQuery) && (!this.isTransient || this.formula);
    }

    private boolean ignoreDraftOnlyProperty(boolean draftQuery) {
        return this.draftOnly && !draftQuery;
    }

    public boolean isVersion() {
        return this.version;
    }

    @Override
    public String dbColumn() {
        return this.dbColumn;
    }

    public String dbComment() {
        return this.dbComment;
    }

    public int dbType(boolean platformTypes) {
        if (platformTypes || !(this.scalarType instanceof ScalarTypeLogicalType)) {
            return this.dbType;
        }
        return ((ScalarTypeLogicalType)this.scalarType).getLogicalType();
    }

    private Object convertToLogicalType(Object value) {
        if (this.scalarType != null) {
            return this.scalarType.toBeanType(value);
        }
        return value;
    }

    public boolean isFetchEager() {
        return this.fetchEager;
    }

    public boolean isLob() {
        return this.lob;
    }

    @Override
    public boolean isDbLob() {
        if (this.lob) {
            return true;
        }
        switch (this.dbType) {
            case 5001: 
            case 5002: {
                return this.dbLength == 0;
            }
            case 5004: 
            case 5005: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLobType(int type) {
        switch (type) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public String dbBind() {
        return this.dbBind;
    }

    @Override
    public Object localEncrypt(Object value) {
        return ((LocalEncryptedType)this.scalarType).localEncrypt(value);
    }

    @Override
    public boolean isLocalEncrypted() {
        return this.localEncrypted;
    }

    @Override
    public boolean isDbEncrypted() {
        return this.dbEncrypted;
    }

    public int dbEncryptedType() {
        return this.dbEncryptedType;
    }

    public boolean isExcludedFromHistory() {
        return this.excludedFromHistory;
    }

    public boolean isUnmappedJson() {
        return this.unmappedJson;
    }

    public boolean isTenantId() {
        return this.tenantId;
    }

    public boolean isDraftOnly() {
        return this.draftOnly;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isDraftDirty() {
        return this.draftDirty;
    }

    boolean isDraftReset() {
        return this.draftReset;
    }

    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public boolean isDbInsertable() {
        return this.dbInsertable;
    }

    public boolean isDbUpdatable() {
        return this.dbUpdatable;
    }

    private boolean isDbRead() {
        return this.dbRead;
    }

    public boolean isSecondaryTable() {
        return this.secondaryTable;
    }

    public Class<?> type() {
        return this.propertyType;
    }

    @Override
    public boolean isId() {
        return this.id;
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }

    public String toString() {
        return this.name;
    }

    public void docStoreInclude(boolean includeByDefault, DocStructure docStructure) {
        if (includeByDefault) {
            docStructure.addProperty(this.name);
        }
    }

    public boolean isJsonSerialize() {
        return this.jsonSerialize;
    }

    public void jsonWriteForInsert(SpiJsonWriter writeJson, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Object value = this.getValue(bean);
        if (value != null) {
            this.jsonWriteScalar(writeJson, value);
        }
    }

    public void jsonWriteValue(SpiJsonWriter writeJson, Object value) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        this.jsonWriteVal(writeJson, value);
    }

    public void jsonWrite(SpiJsonWriter writeJson, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        this.jsonWriteVal(writeJson, this.getValueIntercept(bean));
    }

    private void jsonWriteVal(SpiJsonWriter writeJson, Object value) throws IOException {
        if (value == null) {
            writeJson.writeNullField(this.name);
        } else {
            this.jsonWriteScalar(writeJson, value);
        }
    }

    private void jsonWriteScalar(SpiJsonWriter writeJson, Object value) throws IOException {
        if (this.scalarType != null) {
            writeJson.writeFieldName(this.name);
            this.scalarType.jsonWrite(writeJson.gen(), value);
        } else {
            writeJson.writeValueUsingObjectMapper(this.name, value);
        }
    }

    public void jsonRead(SpiJsonReader ctx, EntityBean bean) throws IOException {
        JsonToken event = ctx.nextToken();
        if (JsonToken.VALUE_NULL == event) {
            if (this.jsonDeserialize) {
                if (ctx.intercept()) {
                    this.setValueIntercept(bean, null);
                } else {
                    this.setValue(bean, null);
                }
            }
        } else {
            Object objValue;
            if (this.scalarType != null) {
                objValue = this.scalarType.jsonRead(ctx.parser());
            } else {
                try {
                    objValue = ctx.readValueUsingObjectMapper(this.propertyType);
                }
                catch (IOException e) {
                    objValue = null;
                    String msg = "Error trying to use Jackson ObjectMapper to read transient property " + this.fullName() + " - consider marking this property with @JsonIgnore";
                    CoreLog.log.log(System.Logger.Level.ERROR, msg, (Throwable)e);
                }
            }
            if (this.jsonDeserialize) {
                if (ctx.intercept()) {
                    this.setValueIntercept(bean, objValue);
                } else {
                    this.setValue(bean, objValue);
                }
            }
        }
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        Object newVal = newBean == null ? null : this.getValue(newBean);
        Object oldVal = oldBean == null ? null : this.getValue(oldBean);
        this.diffVal(prefix, map, newVal, oldVal);
    }

    void diffVal(String prefix, Map<String, ValuePair> map, Object newVal, Object oldVal) {
        if (!ValueUtil.areEqual(newVal, oldVal)) {
            String propName = prefix == null ? this.name : prefix + "." + this.name;
            map.put(propName, new ValuePair(newVal, oldVal));
        }
    }

    public void docStoreMapping(DocMappingBuilder mapping, String prefix) {
        if (mapping.includesProperty(prefix, this.name)) {
            DocPropertyOptions options;
            DocPropertyType type = this.scalarType.docType();
            if (this.isKeywordType(type, options = this.docOptions.copy())) {
                type = DocPropertyType.KEYWORD;
            }
            mapping.add(new DocPropertyMapping(this.name, type, options));
        }
    }

    private boolean isKeywordType(DocPropertyType type, DocPropertyOptions docOptions) {
        return type == DocPropertyType.TEXT && (docOptions.isCode() || this.id || this.discriminator);
    }

    public void merge(EntityBean bean, EntityBean existing) {
    }

    public void registerColumn(BeanDescriptor<?> desc, String prefix) {
        String path = SplitName.add((String)prefix, (String)this.name);
        if (this.formula && this.dbColumn != null) {
            String[] split = this.dbColumn.split("}");
            if (split.length == 2) {
                desc.registerColumn(split[1], path);
            } else {
                desc.registerColumn(this.dbColumn, path);
            }
        } else if (this.dbColumn != null) {
            desc.registerColumn(this.dbColumn, path);
        }
    }
}

