/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.BinaryWritable;
import io.ebeaninternal.api.BinaryWriteContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RemoteTableMod
implements BinaryWritable {
    private final long timestamp;
    private final Set<String> tables;

    public RemoteTableMod(Set<String> tables) {
        this.tables = tables;
        this.timestamp = System.currentTimeMillis();
    }

    private RemoteTableMod(long timestamp, Set<String> tables) {
        this.timestamp = timestamp;
        this.tables = tables;
    }

    public String toString() {
        return "TableMod " + this.timestamp + "; " + this.tables;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Set<String> getTables() {
        return this.tables;
    }

    public static RemoteTableMod readBinaryMessage(BinaryReadContext dataInput) throws IOException {
        long timestamp = dataInput.readLong();
        int count = dataInput.readInt();
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        for (int i = 0; i < count; ++i) {
            tables.add(dataInput.readUTF());
        }
        return new RemoteTableMod(timestamp, tables);
    }

    @Override
    public void writeBinary(BinaryWriteContext out) throws IOException {
        DataOutputStream os = out.start(4);
        os.writeLong(this.timestamp);
        os.writeInt(this.tables.size());
        for (String table : this.tables) {
            os.writeUTF(table);
        }
    }
}

