/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTransactionProxy;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.util.Str;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.persistence.PersistenceException;

final class SavepointTransaction
extends SpiTransactionProxy {
    private static final int STATE_COMMITTED = 1;
    private static final int STATE_ROLLED_BACK = 2;
    private final TransactionManager manager;
    private final Savepoint savepoint;
    private final Connection connection;
    private final String logPrefix;
    private final String spPrefix;
    private boolean rollbackOnly;
    private int state;
    private TransactionEvent event;

    SavepointTransaction(SpiTransaction transaction, TransactionManager manager) throws SQLException {
        this.manager = manager;
        this.transaction = transaction;
        this.connection = transaction.getInternalConnection();
        this.savepoint = this.connection.setSavepoint();
        if (manager.isTxnDebug()) {
            int savepointId = manager.isSupportsSavepointId() ? this.savepoint.getSavepointId() : 0;
            this.spPrefix = "sp[" + savepointId + "] ";
        } else {
            this.spPrefix = "sp[] ";
        }
        this.logPrefix = transaction.getLogPrefix() + this.spPrefix;
    }

    @Override
    public TransactionEvent getEvent() {
        if (this.event == null) {
            this.event = new TransactionEvent();
        }
        return this.event;
    }

    @Override
    public String getLogPrefix() {
        return this.logPrefix;
    }

    @Override
    public void logSql(String msg) {
        this.transaction.logSql(Str.add(this.spPrefix, msg));
    }

    @Override
    public void logSummary(String msg) {
        this.transaction.logSummary(Str.add(this.spPrefix, msg));
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public void commit() {
        if (this.rollbackOnly) {
            this.rollbackSavepoint(null);
        } else {
            this.commitSavepoint();
        }
    }

    public void rollbackAndContinue() {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws PersistenceException {
        this.rollbackSavepoint(null);
    }

    public void rollback(Throwable e) throws PersistenceException {
        this.rollbackSavepoint(e);
    }

    private void commitSavepoint() {
        try {
            this.connection.releaseSavepoint(this.savepoint);
            this.state = 1;
            this.manager.notifyOfCommit(this);
        }
        catch (SQLException e) {
            throw new PersistenceException("Error trying to commit/release Savepoint", (Throwable)e);
        }
    }

    private void rollbackSavepoint(Throwable cause) throws PersistenceException {
        try {
            this.connection.rollback(this.savepoint);
            this.state = 2;
            this.manager.notifyOfRollback(this, cause);
        }
        catch (SQLException e) {
            throw new PersistenceException("Error trying to rollback Savepoint", (Throwable)e);
        }
    }

    public void end() {
        if (this.state == 0) {
            this.rollback();
        }
    }

    public void close() {
        this.end();
    }
}

