/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.common.BeanList;
import io.ebean.common.BeanSet;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanCollectionHelp;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanListHelp;
import io.ebeaninternal.server.deploy.BeanListHelpElement;
import io.ebeaninternal.server.deploy.BeanMapHelp;
import io.ebeaninternal.server.deploy.BeanMapHelpElement;
import io.ebeaninternal.server.deploy.BeanMapQueryHelp;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanSetHelp;
import io.ebeaninternal.server.deploy.BeanSetHelpElement;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.query.CQueryCollectionAdd;

public final class BeanCollectionHelpFactory {
    private static final CQueryCollectionAdd LIST_HELP = new ListAdd();
    private static final CQueryCollectionAdd SET_HELP = new SetAdd();

    public static <T> BeanCollectionHelp<T> create(BeanPropertyAssocMany<T> many) {
        boolean elementCollection = many.isElementCollection();
        switch (many.manyType()) {
            case LIST: {
                return elementCollection ? new BeanListHelpElement<T>(many) : new BeanListHelp<T>(many);
            }
            case SET: {
                return elementCollection ? new BeanSetHelpElement<T>(many) : new BeanSetHelp<T>(many);
            }
            case MAP: {
                return elementCollection ? new BeanMapHelpElement<T>(many) : new BeanMapHelp<T>(many);
            }
        }
        throw new RuntimeException("Invalid type " + many.manyType());
    }

    public static <T> CQueryCollectionAdd<T> create(SpiQuery.Type manyType, OrmQueryRequest<T> request) {
        if (manyType == SpiQuery.Type.LIST) {
            return LIST_HELP;
        }
        if (manyType == SpiQuery.Type.SET) {
            return SET_HELP;
        }
        if (manyType == SpiQuery.Type.MAP) {
            BeanDescriptor<T> target = request.descriptor();
            ElPropertyValue elProperty = target.elGetValue(request.query().getMapKey());
            return new BeanMapQueryHelp(elProperty);
        }
        return null;
    }

    private static final class SetAdd<T>
    implements CQueryCollectionAdd<T> {
        private SetAdd() {
        }

        @Override
        public BeanCollection<T> createEmptyNoParent() {
            return new BeanSet();
        }

        @Override
        public void add(BeanCollection<?> collection, EntityBean bean, boolean withCheck) {
            collection.internalAdd((Object)bean);
        }
    }

    private static final class ListAdd<T>
    implements CQueryCollectionAdd<T> {
        private ListAdd() {
        }

        @Override
        public BeanCollection<T> createEmptyNoParent() {
            return new BeanList();
        }

        @Override
        public void add(BeanCollection<?> collection, EntityBean bean, boolean withCheck) {
            collection.internalAdd((Object)bean);
        }
    }
}

