/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Transaction;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.ExportedProperty;
import io.ebeaninternal.server.deploy.visitor.BaseTablePropertyVisitor;
import io.ebeaninternal.server.deploy.visitor.VisitProperties;
import io.ebeaninternal.server.util.Str;
import java.util.List;

class BeanPropertyAssocManySqlHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final ExportedProperty[] exportedProperties;
    private final boolean hasJoinTable;
    private final BeanDescriptor<?> descriptor;
    private final String exportedPropertyBindProto;
    private final String deleteByParentIdSql;
    private final String deleteByParentIdInSql;
    private final String elementCollectionInsertSql;

    BeanPropertyAssocManySqlHelp(BeanPropertyAssocMany<T> many, ExportedProperty[] exportedProperties) {
        this.many = many;
        this.exportedProperties = exportedProperties;
        this.hasJoinTable = many.hasJoinTable();
        this.descriptor = many.descriptor();
        this.exportedPropertyBindProto = this.deriveExportedPropertyBindProto();
        String delStmt = this.hasJoinTable ? "delete from " + many.inverseJoin.getTable() + " where " : "delete from " + many.targetTable() + " where ";
        this.deleteByParentIdSql = delStmt + this.deriveWhereParentIdSql(false, "");
        this.deleteByParentIdInSql = delStmt + this.deriveWhereParentIdSql(true, "");
        this.elementCollectionInsertSql = many.isElementCollection() ? this.elementCollectionInsert() : null;
    }

    private String elementCollectionInsert() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("insert into ").append(this.many.targetTable()).append(" (");
        this.append(sb);
        Cols cols = new Cols(sb);
        VisitProperties.visit(this.many.targetDescriptor, cols);
        sb.append(") values (");
        this.appendBind(sb, this.exportedProperties.length, true);
        this.appendBind(sb, cols.colCount, false);
        sb.append(")");
        return sb.toString();
    }

    SpiSqlUpdate insertElementCollection() {
        return new DefaultSqlUpdate(this.elementCollectionInsertSql);
    }

    String lazyFetchOrderBy(String fetchOrderBy) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            String fkTableAlias = this.hasJoinTable ? "int_" : "t0";
            sb.append(fkTableAlias).append(".").append(this.exportedProperties[i].getForeignDbColumn());
        }
        sb.append(", ").append(fetchOrderBy);
        return sb.toString().trim();
    }

    void addWhereParentIdIn(SpiQuery<?> query, List<Object> parentIds) {
        String tableAlias;
        String string = tableAlias = this.hasJoinTable ? "int_." : "t0.";
        if (this.hasJoinTable) {
            query.setM2MIncludeJoin(this.many.inverseJoin);
        }
        String rawWhere = this.deriveWhereParentIdSql(true, tableAlias);
        String expr = this.descriptor.parentIdInExpr(parentIds.size(), rawWhere);
        this.many.bindParentIdsIn(expr, parentIds, query);
    }

    List<Object> findIdsByParentId(Object parentId, Transaction t, List<Object> excludeDetailIds, boolean hard) {
        String rawWhere = this.deriveWhereParentIdSql(false, "");
        SpiEbeanServer server = this.descriptor.ebeanServer();
        SpiQuery q = this.many.newQuery(server);
        this.many.bindParentIdEq(rawWhere, parentId, q);
        if (hard) {
            q.setIncludeSoftDeletes();
        }
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            q.where().not(q.getExpressionFactory().idIn(excludeDetailIds));
        }
        return server.findIds(q, t);
    }

    List<Object> findIdsByParentIdList(List<Object> parentIds, Transaction t, List<Object> excludeDetailIds, boolean hard) {
        String rawWhere = this.deriveWhereParentIdSql(true, "");
        String inClause = this.buildInClauseBinding(parentIds.size(), this.exportedPropertyBindProto);
        String expr = rawWhere + inClause;
        SpiEbeanServer server = this.descriptor.ebeanServer();
        SpiQuery q = this.many.newQuery(server);
        this.many.bindParentIdsIn(expr, parentIds, q);
        if (hard) {
            q.setIncludeSoftDeletes();
        }
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            q.where().not(q.getExpressionFactory().idIn(excludeDetailIds));
        }
        return server.findIds(q, t);
    }

    SpiSqlUpdate deleteByParentId(Object parentId) {
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(this.deleteByParentIdSql);
        this.many.bindParentId(sqlDelete, parentId);
        return sqlDelete;
    }

    SpiSqlUpdate deleteByParentIdList(List<Object> parentIds) {
        String sql = Str.add(this.deleteByParentIdInSql, this.buildInClauseBinding(parentIds.size(), this.exportedPropertyBindProto));
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sql);
        this.many.bindParentIds(delete, parentIds);
        return delete;
    }

    private void appendBind(StringBuilder sb, int count, boolean skipComma) {
        for (int i = 0; i < count; ++i) {
            if (!skipComma || i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
    }

    private void append(StringBuilder sb) {
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fkColumn);
        }
    }

    private String deriveWhereParentIdSql(boolean inClause, String tableAlias) {
        StringBuilder sb = new StringBuilder();
        if (inClause) {
            sb.append("(");
        }
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            if (i > 0) {
                sb.append(inClause ? "," : " and ");
            }
            sb.append(tableAlias).append(fkColumn);
            if (inClause) continue;
            sb.append("=? ");
        }
        if (inClause) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String buildInClauseBinding(int size, String bindProto) {
        if (this.descriptor.isSimpleId()) {
            return this.descriptor.idBinder().getIdInValueExpr(false, size);
        }
        StringBuilder sb = new StringBuilder(10 + size * (bindProto.length() + 1));
        sb.append(" in");
        sb.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(bindProto);
        }
        sb.append(") ");
        return sb.toString();
    }

    private String deriveExportedPropertyBindProto() {
        if (this.exportedProperties.length == 1) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    private static class Cols
    extends BaseTablePropertyVisitor {
        int colCount;
        private final StringBuilder sb;

        private Cols(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
            this.sb.append(",").append(p.dbColumn());
            ++this.colCount;
        }

        @Override
        public void visitOneImported(BeanPropertyAssocOne<?> p) {
        }

        @Override
        public void visitScalar(BeanProperty p, boolean allowNonNull) {
            this.sb.append(",").append(p.dbColumn());
            ++this.colCount;
        }

        @Override
        public void visitEnd() {
        }
    }
}

