/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.NamedParamHelp;
import io.ebeaninternal.server.expression.Op;
import java.io.IOException;

final class InRangeExpression
extends AbstractExpression {
    private final Object valueHigh;
    private final Object valueLow;

    InRangeExpression(String propertyName, Object valueLow, Object valueHigh) {
        super(propertyName);
        this.valueLow = valueLow;
        this.valueHigh = valueHigh;
    }

    private Object low() {
        return NamedParamHelp.value(this.valueLow);
    }

    private Object high() {
        return NamedParamHelp.value(this.valueHigh);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeRange(this.propName, Op.GT_EQ, this.low(), Op.LT, this.high());
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.beanProperty().encryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
            request.addBindValue(this.low());
            request.addBindEncryptKey(encryptKey);
            request.addBindValue(this.high());
            return;
        }
        request.addBindValue(this.low());
        request.addBindValue(this.high());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.beanProperty().decryptProperty(this.propName);
        }
        request.append("(").append(pname).append(" >= ? and ").append(pname).append(" < ?)");
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("InRange[").append(this.propName).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.low()).add(this.high());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InRangeExpression that = (InRangeExpression)other;
        return this.low().equals(that.low()) && this.high().equals(that.high());
    }
}

