/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadManyBuffer;
import io.ebeaninternal.api.LoadManyContext;
import io.ebeaninternal.api.LoadManyRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.loadcontext.DLoadBaseContext;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

final class DLoadManyContext
extends DLoadBaseContext
implements LoadManyContext {
    private final BeanPropertyAssocMany<?> property;
    private final boolean docStoreMapped;
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    DLoadManyContext(DLoadContext parent, BeanPropertyAssocMany<?> property, String path, OrmQueryProperties queryProps) {
        super(parent, property.descriptor(), path, queryProps);
        this.property = property;
        this.docStoreMapped = property.isTargetDocStoreMapped();
        this.bufferList = !this.queryFetch ? null : new ArrayList();
        this.currentBuffer = this.createBuffer(this.batchSize);
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer;
        LoadBuffer loadBuffer = buffer = this.parent.useReferences ? new LoadBufferWeakRef(this, size) : new LoadBufferHardRef(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    private void clear() {
        if (this.bufferList != null) {
            this.bufferList.clear();
        }
        this.currentBuffer = this.createBuffer(this.batchSize);
    }

    private void configureQuery(SpiQuery<?> query) {
        this.setLabel(query);
        this.parent.propagateQueryState(query, this.docStoreMapped);
        query.setParentNode(this.objectGraphNode);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
    }

    public BeanPropertyAssocMany<?> getBeanProperty() {
        return this.property;
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.desc;
    }

    public String getName() {
        return this.parent.getEbeanServer().name();
    }

    public void register(BeanCollection<?> bc) {
        if (this.currentBuffer.isFull()) {
            this.currentBuffer = this.createBuffer(this.batchSize);
        }
        this.currentBuffer.add(bc);
        bc.setLoader((BeanCollectionLoader)this.currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        this.lock.lock();
        try {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (loadBuffer.size() <= 0) continue;
                    LoadManyRequest req = new LoadManyRequest(loadBuffer, parentRequest);
                    this.parent.getEbeanServer().loadMany(req);
                }
                if (forEach) {
                    this.clear();
                } else {
                    this.bufferList = null;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class LoadBufferWeakRef
    extends LoadBuffer {
        private final Reference<BeanCollection<?>>[] list;
        private int size;

        LoadBufferWeakRef(DLoadManyContext context, int batchSize) {
            super(context, batchSize);
            this.list = new Reference[batchSize];
        }

        @Override
        public void add(BeanCollection<?> bc) {
            this.list[this.size++] = new WeakReference(bc);
        }

        @Override
        void clear() {
            Arrays.fill(this.list, null);
            this.size = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public BeanCollection<?> get(int i) {
            Reference<BeanCollection<?>> ref = this.list[i];
            if (ref == null) {
                return null;
            }
            BeanCollection<?> bc = ref.get();
            if (bc == null) {
                this.list[i] = null;
            }
            return bc;
        }

        @Override
        public boolean removeFromBuffer(BeanCollection<?> collection) {
            for (int i = 0; i < this.size; ++i) {
                if (this.list[i] == null) continue;
                BeanCollection<?> bc = this.list[i].get();
                if (bc == null) {
                    this.list[i] = null;
                }
                if (bc != collection) continue;
                this.list[i] = null;
                return true;
            }
            return false;
        }
    }

    static class LoadBufferHardRef
    extends LoadBuffer {
        private final BeanCollection<?>[] list;
        private int size;

        LoadBufferHardRef(DLoadManyContext context, int batchSize) {
            super(context, batchSize);
            this.list = new BeanCollection[batchSize];
        }

        @Override
        public void add(BeanCollection<?> bc) {
            this.list[this.size++] = bc;
        }

        @Override
        void clear() {
            Arrays.fill(this.list, null);
            this.size = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public BeanCollection<?> get(int i) {
            return this.list[i];
        }

        @Override
        public boolean removeFromBuffer(BeanCollection<?> collection) {
            for (int i = 0; i < this.size; ++i) {
                if (this.list[i] != collection) continue;
                this.list[i] = null;
                return true;
            }
            return false;
        }
    }

    static abstract class LoadBuffer
    implements BeanCollectionLoader,
    LoadManyBuffer {
        private final ReentrantLock lock = new ReentrantLock();
        private final PersistenceContext persistenceContext;
        private final DLoadManyContext context;
        final int batchSize;

        LoadBuffer(DLoadManyContext context, int batchSize) {
            this.context = context;
            this.persistenceContext = context.getPersistenceContext();
            this.batchSize = batchSize;
        }

        @Override
        public boolean isUseDocStore() {
            return this.context.parent.useDocStore && this.context.docStoreMapped;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        public boolean isFull() {
            return this.batchSize() == this.size();
        }

        public abstract void add(BeanCollection<?> var1);

        abstract void clear();

        @Override
        public BeanPropertyAssocMany<?> getBeanProperty() {
            return this.context.property;
        }

        @Override
        public ObjectGraphNode getObjectGraphNode() {
            return this.context.objectGraphNode;
        }

        @Override
        public void configureQuery(SpiQuery<?> query) {
            this.context.configureQuery(query);
        }

        public String name() {
            return this.context.serverName;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
            this.lock.lock();
            try {
                Object parentId;
                String parentKey;
                EntityBean ownerBean;
                BeanDescriptor<?> parentDesc;
                boolean useCache;
                boolean bl = useCache = !onlyIds && this.context.hitCache && this.context.property.isUseCache();
                if (useCache && (parentDesc = this.context.desc.descriptor((ownerBean = bc.getOwnerBean()).getClass())).cacheManyPropLoad(this.context.property, bc, parentKey = parentDesc.cacheKey(parentId = parentDesc.getId(ownerBean)), this.context.parent.isReadOnly())) {
                    if (this.removeFromBuffer(bc)) {
                        bc.setLoader((BeanCollectionLoader)this.context.parent.getEbeanServer());
                    }
                    return;
                }
                this.context.parent.getEbeanServer().loadMany(new LoadManyRequest(this, onlyIds, useCache));
                this.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

