/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.json.ModifyAwareMap;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.TypeJsonManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

final class ScalarTypePostgresHstore
extends ScalarTypeBase<Map> {
    ScalarTypePostgresHstore() {
        super(Map.class, false, 5000);
    }

    public boolean mutable() {
        return true;
    }

    public boolean isDirty(Object value) {
        return TypeJsonManager.checkIsDirty(value);
    }

    public Map read(DataReader reader) throws SQLException {
        Object value = reader.getObject();
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new RuntimeException("Expecting Hstore to return as Map but got type " + value.getClass());
        }
        return new ModifyAwareMap((Map)value);
    }

    public void bind(DataBinder binder, Map value) throws SQLException {
        binder.setObject((Object)value);
    }

    public Object toJdbcType(Object value) {
        return value;
    }

    public Map toBeanType(Object value) {
        return (Map)value;
    }

    public String formatValue(Map v) {
        try {
            return EJson.write((Object)v);
        }
        catch (IOException e) {
            throw new TextException((Exception)e);
        }
    }

    public Map parse(String value) {
        try {
            return EJson.parseObject((String)value);
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as Object", value, (Exception)e);
        }
    }

    public Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    public void writeData(DataOutput dataOutput, Map map) throws IOException {
        if (map == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(map));
        }
    }

    public void jsonWrite(JsonGenerator writer, Map value) throws IOException {
        EJson.write((Object)value, (JsonGenerator)writer);
    }

    public Map jsonRead(JsonParser parser) throws IOException {
        return EJson.parseObject((JsonParser)parser, (JsonToken)parser.getCurrentToken());
    }

    public DocPropertyType docType() {
        return DocPropertyType.OBJECT;
    }
}

