/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocManyJsonTransient;
import java.io.IOException;

class BeanPropertyAssocManyJsonHelp {
    private final BeanPropertyAssocMany<?> many;
    private final BeanPropertyAssocManyJsonTransient jsonTransient;

    BeanPropertyAssocManyJsonHelp(BeanPropertyAssocMany<?> many) {
        this.many = many;
        boolean objectMapperPresent = many.descriptor().config().getClassLoadConfig().isJacksonObjectMapperPresent();
        this.jsonTransient = !objectMapperPresent ? null : new BeanPropertyAssocManyJsonTransient();
    }

    public void jsonRead(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        if (!this.many.jsonDeserialize) {
            return;
        }
        JsonParser parser = readJson.parser();
        JsonToken event = parser.nextToken();
        if (JsonToken.VALUE_NULL == event) {
            return;
        }
        if (this.many.isTransient()) {
            this.jsonReadTransientUsingObjectMapper(readJson, parentBean);
            return;
        }
        if (JsonToken.START_ARRAY != event && JsonToken.START_OBJECT != event) {
            throw new JsonParseException(parser, "Unexpected token " + String.valueOf(event) + " - expecting start array or object");
        }
        if (readJson.intercept()) {
            this.many.setValueIntercept(parentBean, this.many.jsonReadCollection(readJson, parentBean));
        } else {
            this.many.setValue(parentBean, this.many.jsonReadCollection(readJson, parentBean));
        }
    }

    private void jsonReadTransientUsingObjectMapper(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        if (this.jsonTransient == null) {
            throw new IllegalStateException("Jackson ObjectMapper is required to read this Transient property " + this.many.fullName());
        }
        this.jsonTransient.jsonReadUsingObjectMapper(this.many, readJson, parentBean);
    }
}

