/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPersistListener;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;

final class PersistListenerManager {
    private final List<BeanPersistListener> list;

    PersistListenerManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPersistListeners();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    <T> void addPersistListeners(DeployBeanDescriptor<T> deployDesc) {
        for (BeanPersistListener listener : this.list) {
            if (!listener.isRegisterFor(deployDesc.getBeanType())) continue;
            CoreLog.log.log(System.Logger.Level.DEBUG, "BeanPersistListener on[{0}] {1}", deployDesc.getFullName(), listener.getClass().getName());
            deployDesc.addPersistListener(listener);
        }
    }
}

