/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.annotation.DbEnumType;
import io.ebean.annotation.DbEnumValue;
import io.ebean.annotation.EnumValue;
import io.ebean.annotation.MutationDetection;
import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.JsonConfig;
import io.ebean.config.PlatformConfig;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ExtraTypeFactory;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarJsonManager;
import io.ebean.core.type.ScalarJsonMapper;
import io.ebean.core.type.ScalarJsonRequest;
import io.ebean.core.type.ScalarType;
import io.ebean.core.type.ScalarTypeSet;
import io.ebean.core.type.ScalarTypeSetFactory;
import io.ebean.types.Cidr;
import io.ebean.types.Inet;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.GeoTypeProvider;
import io.ebeaninternal.server.core.ServiceUtil;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.type.AttributeConverterAdapter;
import io.ebeaninternal.server.type.DefaultTypeFactory;
import io.ebeaninternal.server.type.EnumToDbValueMap;
import io.ebeaninternal.server.type.GeoTypeBinder;
import io.ebeaninternal.server.type.InitObjectMapper;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.PlatformArrayTypeJsonList;
import io.ebeaninternal.server.type.PlatformArrayTypeJsonSet;
import io.ebeaninternal.server.type.ScalarTypeArrayList;
import io.ebeaninternal.server.type.ScalarTypeArrayListH2;
import io.ebeaninternal.server.type.ScalarTypeArraySet;
import io.ebeaninternal.server.type.ScalarTypeArraySetH2;
import io.ebeaninternal.server.type.ScalarTypeBigDecimal;
import io.ebeaninternal.server.type.ScalarTypeBool;
import io.ebeaninternal.server.type.ScalarTypeByte;
import io.ebeaninternal.server.type.ScalarTypeBytesBinary;
import io.ebeaninternal.server.type.ScalarTypeBytesBlob;
import io.ebeaninternal.server.type.ScalarTypeBytesLongVarbinary;
import io.ebeaninternal.server.type.ScalarTypeBytesVarbinary;
import io.ebeaninternal.server.type.ScalarTypeChar;
import io.ebeaninternal.server.type.ScalarTypeCharArray;
import io.ebeaninternal.server.type.ScalarTypeCidr;
import io.ebeaninternal.server.type.ScalarTypeClass;
import io.ebeaninternal.server.type.ScalarTypeClob;
import io.ebeaninternal.server.type.ScalarTypeCurrency;
import io.ebeaninternal.server.type.ScalarTypeDate;
import io.ebeaninternal.server.type.ScalarTypeDayOfWeek;
import io.ebeaninternal.server.type.ScalarTypeDouble;
import io.ebeaninternal.server.type.ScalarTypeDuration;
import io.ebeaninternal.server.type.ScalarTypeDurationWithNanos;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import io.ebeaninternal.server.type.ScalarTypeEnumStandard;
import io.ebeaninternal.server.type.ScalarTypeEnumWithMapping;
import io.ebeaninternal.server.type.ScalarTypeFile;
import io.ebeaninternal.server.type.ScalarTypeFloat;
import io.ebeaninternal.server.type.ScalarTypeInet;
import io.ebeaninternal.server.type.ScalarTypeInetAddress;
import io.ebeaninternal.server.type.ScalarTypeInetAddressPostgres;
import io.ebeaninternal.server.type.ScalarTypeInstant;
import io.ebeaninternal.server.type.ScalarTypeInteger;
import io.ebeaninternal.server.type.ScalarTypeJsonList;
import io.ebeaninternal.server.type.ScalarTypeJsonMap;
import io.ebeaninternal.server.type.ScalarTypeJsonSet;
import io.ebeaninternal.server.type.ScalarTypeJsonString;
import io.ebeaninternal.server.type.ScalarTypeLocalDate;
import io.ebeaninternal.server.type.ScalarTypeLocalDateNative;
import io.ebeaninternal.server.type.ScalarTypeLocalDateTime;
import io.ebeaninternal.server.type.ScalarTypeLocalTime;
import io.ebeaninternal.server.type.ScalarTypeLocalTimeWithNanos;
import io.ebeaninternal.server.type.ScalarTypeLocale;
import io.ebeaninternal.server.type.ScalarTypeLong;
import io.ebeaninternal.server.type.ScalarTypeLongVarchar;
import io.ebeaninternal.server.type.ScalarTypeMonth;
import io.ebeaninternal.server.type.ScalarTypeMonthDay;
import io.ebeaninternal.server.type.ScalarTypeNotFound;
import io.ebeaninternal.server.type.ScalarTypeOffsetDateTime;
import io.ebeaninternal.server.type.ScalarTypeOffsetTime;
import io.ebeaninternal.server.type.ScalarTypePath;
import io.ebeaninternal.server.type.ScalarTypePeriod;
import io.ebeaninternal.server.type.ScalarTypePostgresHstore;
import io.ebeaninternal.server.type.ScalarTypeShort;
import io.ebeaninternal.server.type.ScalarTypeString;
import io.ebeaninternal.server.type.ScalarTypeTime;
import io.ebeaninternal.server.type.ScalarTypeTimeZone;
import io.ebeaninternal.server.type.ScalarTypeTimestamp;
import io.ebeaninternal.server.type.ScalarTypeURI;
import io.ebeaninternal.server.type.ScalarTypeURL;
import io.ebeaninternal.server.type.ScalarTypeUUIDBase;
import io.ebeaninternal.server.type.ScalarTypeUUIDBinary;
import io.ebeaninternal.server.type.ScalarTypeUUIDNative;
import io.ebeaninternal.server.type.ScalarTypeUUIDVarchar;
import io.ebeaninternal.server.type.ScalarTypeWrapper;
import io.ebeaninternal.server.type.ScalarTypeYear;
import io.ebeaninternal.server.type.ScalarTypeYearMonthDate;
import io.ebeaninternal.server.type.ScalarTypeZoneId;
import io.ebeaninternal.server.type.ScalarTypeZoneOffset;
import io.ebeaninternal.server.type.ScalarTypeZonedDateTime;
import io.ebeaninternal.server.type.TypeJsonManager;
import io.ebeaninternal.server.type.TypeManager;
import io.ebeaninternal.server.type.TypeReflectHelper;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeConverter;
import javax.persistence.EnumType;

public final class DefaultTypeManager
implements TypeManager {
    private static final System.Logger log = CoreLog.internal;
    private final Map<Class<?>, ScalarTypeSet<?>> typeSets = new HashMap();
    private final ConcurrentHashMap<Class<?>, ScalarType<?>> typeMap;
    private final ConcurrentHashMap<Integer, ScalarType<?>> nativeMap;
    private final ConcurrentHashMap<String, ScalarType<?>> logicalMap;
    private final DefaultTypeFactory extraTypeFactory;
    private final ScalarType<?> fileType = new ScalarTypeFile();
    private final ScalarType<?> hstoreType = new ScalarTypePostgresHstore();
    private final JsonConfig.DateTime jsonDateTime;
    private final JsonConfig.Date jsonDate;
    private final Object objectMapper;
    private final boolean objectMapperPresent;
    private final boolean postgres;
    private final ScalarJsonManager jsonManager;
    private final boolean offlineMigrationGeneration;
    private final EnumType defaultEnumType;
    private final DatabasePlatform databasePlatform;
    private final PlatformArrayTypeFactory arrayTypeListFactory;
    private final PlatformArrayTypeFactory arrayTypeSetFactory;
    private final ScalarJsonMapper jsonMapper;
    private GeoTypeBinder geoTypeBinder;

    public DefaultTypeManager(DatabaseConfig config, BootupClasses bootupClasses) {
        this.jsonDateTime = config.getJsonDateTime();
        this.jsonDate = config.getJsonDate();
        this.typeMap = new ConcurrentHashMap();
        this.nativeMap = new ConcurrentHashMap();
        this.logicalMap = new ConcurrentHashMap();
        this.databasePlatform = config.getDatabasePlatform();
        this.postgres = PostgresHelper.isPostgresCompatible((DatabasePlatform)config.getDatabasePlatform());
        this.objectMapperPresent = config.getClassLoadConfig().isJacksonObjectMapperPresent();
        this.objectMapper = this.objectMapperPresent ? this.initObjectMapper(config) : null;
        this.jsonManager = this.objectMapperPresent ? new TypeJsonManager(this.postgres, this.objectMapper, config.getJsonMutationDetection()) : null;
        this.extraTypeFactory = new DefaultTypeFactory(config);
        this.arrayTypeListFactory = this.arrayTypeListFactory(config.getDatabasePlatform());
        this.arrayTypeSetFactory = this.arrayTypeSetFactory(config.getDatabasePlatform());
        this.offlineMigrationGeneration = DbOffline.isGenerateMigration();
        this.defaultEnumType = config.getDefaultEnumType();
        ServiceLoader<ScalarJsonMapper> mappers = ServiceLoader.load(ScalarJsonMapper.class);
        this.jsonMapper = mappers.findFirst().orElse(null);
        this.initialiseStandard(config);
        this.initialiseJavaTimeTypes(config);
        this.loadTypesFromProviders(config, this.objectMapper);
        this.loadGeoTypeBinder(config);
        if (bootupClasses != null) {
            this.initialiseCustomScalarTypes(bootupClasses);
            this.initialiseScalarConverters(bootupClasses);
            this.initialiseAttributeConverters(bootupClasses);
        }
    }

    private void loadGeoTypeBinder(DatabaseConfig config) {
        GeoTypeProvider provider = (GeoTypeProvider)config.getServiceObject(GeoTypeProvider.class);
        if (provider == null) {
            provider = ServiceUtil.service(GeoTypeProvider.class);
        }
        if (provider != null) {
            this.geoTypeBinder = provider.createBinder(config);
        }
    }

    private PlatformArrayTypeFactory arrayTypeListFactory(DatabasePlatform databasePlatform) {
        if (databasePlatform.nativeArrayType()) {
            return ScalarTypeArrayList.factory();
        }
        if (databasePlatform.isPlatform(Platform.H2)) {
            return ScalarTypeArrayListH2.factory();
        }
        return new PlatformArrayTypeJsonList();
    }

    private PlatformArrayTypeFactory arrayTypeSetFactory(DatabasePlatform databasePlatform) {
        if (databasePlatform.nativeArrayType()) {
            return ScalarTypeArraySet.factory();
        }
        if (databasePlatform.isPlatform(Platform.H2)) {
            return ScalarTypeArraySetH2.factory();
        }
        return new PlatformArrayTypeJsonSet();
    }

    private void loadTypesFromProviders(DatabaseConfig config, Object objectMapper) {
        for (ExtraTypeFactory plugin : ServiceLoader.load(ExtraTypeFactory.class)) {
            for (ScalarType type : plugin.createTypes(config, objectMapper)) {
                this.add(type);
            }
        }
        for (ScalarTypeSetFactory factory : ServiceLoader.load(ScalarTypeSetFactory.class)) {
            ScalarTypeSet typeSet = factory.createTypeSet(config, objectMapper);
            if (typeSet == null) continue;
            this.typeSets.put(typeSet.type(), typeSet);
            ScalarType defaultType = typeSet.defaultType();
            if (defaultType == null) continue;
            this.typeMap.put(typeSet.type(), defaultType);
        }
    }

    private boolean hstoreSupport() {
        return this.databasePlatform.isPlatform(Platform.POSTGRES);
    }

    private void add(ScalarType<?> scalarType) {
        this.typeMap.put(scalarType.type(), scalarType);
        this.logAdd(scalarType);
    }

    private void logAdd(ScalarType<?> scalarType) {
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            log.log(System.Logger.Level.TRACE, "ScalarType register {0} for {1}", scalarType.getClass().getName(), scalarType.type().getName());
        }
    }

    @Override
    public ScalarType<?> type(String cast) {
        return this.logicalMap.get(cast);
    }

    @Override
    public ScalarType<?> type(int jdbcType) {
        return this.nativeMap.get(jdbcType);
    }

    @Override
    public ScalarType<?> type(Type propertyType, Class<?> propertyClass) {
        ParameterizedType pt;
        Type rawType;
        if (propertyType instanceof ParameterizedType && (List.class == (rawType = (pt = (ParameterizedType)propertyType).getRawType()) || Set.class == rawType)) {
            return this.dbArrayType((Class)rawType, propertyType, true);
        }
        return this.type(propertyClass);
    }

    @Override
    public ScalarType<?> type(Class<?> type) {
        ScalarType<?> found = this.typeMap.get(type);
        if (found == null) {
            if (type.getName().equals("org.joda.time.LocalTime")) {
                throw new IllegalStateException("ScalarType of Joda LocalTime not defined. 1) Check ebean-joda-time dependency has been added  2) Check DatabaseConfig.jodaLocalTimeMode is set to either 'normal' or 'utc'.  UTC is the old mode using UTC timezone but local time zone is now preferred as 'normal' mode.");
            }
            found = this.checkInheritedTypes(type);
        }
        return found != ScalarTypeNotFound.INSTANCE ? found : null;
    }

    private ScalarType<?> checkInheritedTypes(Class<?> type) {
        for (Class<?> parent = type; parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            ScalarType<?> found = this.typeMap.get(parent);
            if (found != null && found != ScalarTypeNotFound.INSTANCE) {
                this.typeMap.put(type, found);
                return found;
            }
            for (Class<?> iface : parent.getInterfaces()) {
                found = this.checkInheritedTypes(iface);
                if (found == null || found == ScalarTypeNotFound.INSTANCE) continue;
                this.typeMap.put(type, found);
                return found;
            }
        }
        this.typeMap.put(type, ScalarTypeNotFound.INSTANCE);
        return ScalarTypeNotFound.INSTANCE;
    }

    @Override
    public GeoTypeBinder geoTypeBinder() {
        return this.geoTypeBinder;
    }

    @Override
    public ScalarType<?> dbMapType() {
        return this.hstoreSupport() ? this.hstoreType : ScalarTypeJsonMap.typeFor(false, 12, false);
    }

    @Override
    public ScalarType<?> dbArrayType(Class<?> type, Type genericType, boolean nullable) {
        Type valueType = this.valueType(genericType);
        if (type.equals(List.class)) {
            return this.dbArrayTypeList(valueType, nullable);
        }
        if (type.equals(Set.class)) {
            return this.dbArrayTypeSet(valueType, nullable);
        }
        throw new IllegalStateException("@DbArray does not support type " + String.valueOf(type));
    }

    private ScalarType<?> dbArrayTypeSet(Type valueType, boolean nullable) {
        if (this.isEnumType(valueType)) {
            return this.arrayTypeSetFactory.typeForEnum(this.enumType(this.asEnumClass(valueType), null), nullable);
        }
        return this.arrayTypeSetFactory.typeFor(valueType, nullable);
    }

    private ScalarType<?> dbArrayTypeList(Type valueType, boolean nullable) {
        if (this.isEnumType(valueType)) {
            return this.arrayTypeListFactory.typeForEnum(this.enumType(this.asEnumClass(valueType), null), nullable);
        }
        return this.arrayTypeListFactory.typeFor(valueType, nullable);
    }

    private Class<? extends Enum<?>> asEnumClass(Type valueType) {
        return TypeReflectHelper.asEnumClass(valueType);
    }

    private boolean isEnumType(Type valueType) {
        return TypeReflectHelper.isEnumType(valueType);
    }

    @Override
    public ScalarType<?> dbJsonType(DeployBeanProperty prop, int dbType, int dbLength) {
        ScalarTypeSet<?> typeSet;
        Class markerAnnotation;
        Class<?> type = prop.getPropertyType();
        if (type.equals(String.class)) {
            return ScalarTypeJsonString.typeFor(this.postgres, dbType);
        }
        if (this.jsonMapper != null && (markerAnnotation = this.jsonMapper.markerAnnotation()) != null && !prop.getMetaAnnotations(markerAnnotation).isEmpty()) {
            return this.createJsonObjectMapperType(prop, dbType, this.docPropertyType(prop, type));
        }
        Type genericType = prop.getGenericType();
        if (type.equals(List.class) && this.isValueTypeSimple(genericType)) {
            return ScalarTypeJsonList.typeFor(this.postgres, dbType, this.docType(genericType), prop.isNullable(), this.keepSource(prop));
        }
        if (type.equals(Set.class) && this.isValueTypeSimple(genericType)) {
            return ScalarTypeJsonSet.typeFor(this.postgres, dbType, this.docType(genericType), prop.isNullable(), this.keepSource(prop));
        }
        if (type.equals(Map.class) && this.isMapValueTypeObject(genericType)) {
            return ScalarTypeJsonMap.typeFor(this.postgres, dbType, this.keepSource(prop));
        }
        if (this.objectMapperPresent && prop.getMutationDetection() == MutationDetection.DEFAULT && (typeSet = this.typeSets.get(type)) != null) {
            return typeSet.forType(dbType);
        }
        return this.createJsonObjectMapperType(prop, dbType, DocPropertyType.OBJECT);
    }

    private boolean keepSource(DeployBeanProperty prop) {
        if (prop.getMutationDetection() == MutationDetection.DEFAULT) {
            prop.setMutationDetection(this.jsonManager.mutationDetection());
        }
        return prop.getMutationDetection() == MutationDetection.SOURCE;
    }

    private DocPropertyType docPropertyType(DeployBeanProperty prop, Class<?> type) {
        return type.equals(List.class) || type.equals(Set.class) ? this.docType(prop.getGenericType()) : DocPropertyType.OBJECT;
    }

    private DocPropertyType docType(Type genericType) {
        ScalarType<?> found;
        if (genericType instanceof Class && (found = this.type((Class)genericType)) != null) {
            return found.docType();
        }
        return DocPropertyType.OBJECT;
    }

    private boolean isValueTypeSimple(Type collectionType) {
        Type typeArg = TypeReflectHelper.getValueType(collectionType);
        return String.class.equals((Object)typeArg) || Long.class.equals((Object)typeArg);
    }

    private Type valueType(Type collectionType) {
        return TypeReflectHelper.getValueType(collectionType);
    }

    private boolean isMapValueTypeObject(Type genericType) {
        Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
        return Object.class.equals((Object)typeArgs[1]) || "?".equals(typeArgs[1].toString());
    }

    private ScalarType<?> createJsonObjectMapperType(DeployBeanProperty prop, int dbType, DocPropertyType docType) {
        if (this.jsonMapper == null) {
            throw new IllegalArgumentException("Unsupported @DbJson mapping - Jackson ObjectMapper not present for " + String.valueOf(prop));
        }
        if (MutationDetection.DEFAULT == prop.getMutationDetection()) {
            prop.setMutationDetection(this.jsonManager.mutationDetection());
        }
        ScalarJsonRequest req = new ScalarJsonRequest(this.jsonManager, dbType, docType, prop.getDesc().getBeanType(), prop.getMutationDetection(), prop.getName());
        return this.jsonMapper.createType(req);
    }

    @Override
    public ScalarType<?> type(Class<?> type, int jdbcType) {
        if (File.class.equals(type)) {
            return this.fileType;
        }
        ScalarType<?> scalarType = this.lobTypes(jdbcType);
        if (scalarType != null) {
            return scalarType;
        }
        scalarType = this.type(type);
        if (scalarType != null && (jdbcType == 0 || scalarType.jdbcType() == jdbcType)) {
            return scalarType;
        }
        if (type.equals(Date.class)) {
            return this.extraTypeFactory.createUtilDate(this.jsonDateTime, this.jsonDate, jdbcType);
        }
        if (type.equals(Calendar.class)) {
            return this.extraTypeFactory.createCalendar(this.jsonDateTime, jdbcType);
        }
        throw new IllegalArgumentException("Unmatched ScalarType for " + String.valueOf(type) + " jdbcType:" + jdbcType);
    }

    private ScalarType<?> lobTypes(int jdbcType) {
        return this.type(jdbcType);
    }

    public Object convert(Object value, int toJdbcType) {
        if (value == null) {
            return null;
        }
        ScalarType<?> type = this.nativeMap.get(toJdbcType);
        if (type != null) {
            return type.toJdbcType(value);
        }
        return value;
    }

    boolean isIntegerType(String s) {
        if (this.isLeadingZeros(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isLeadingZeros(String s) {
        return s.length() > 1 && s.charAt(0) == '0';
    }

    private ScalarTypeEnum<?> enumTypeEnumValue(Class<?> enumType) {
        boolean integerType = true;
        LinkedHashMap<String, String> nameValueMap = new LinkedHashMap<String, String>();
        for (Field field : enumType.getDeclaredFields()) {
            EnumValue enumValue = (EnumValue)AnnotationUtil.get((AnnotatedElement)field, EnumValue.class);
            if (enumValue == null) continue;
            nameValueMap.put(field.getName(), enumValue.value());
            if (!integerType || this.isIntegerType(enumValue.value())) continue;
            integerType = false;
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, 0, true);
    }

    @Override
    public ScalarType<?> enumType(Class<? extends Enum<?>> enumType, EnumType type) {
        ScalarType<?> scalarType = this.type(enumType);
        if (scalarType instanceof ScalarTypeWrapper) {
            return scalarType;
        }
        ScalarTypeEnum<?> scalarEnum = (ScalarTypeEnum<?>)scalarType;
        if (scalarEnum != null && !scalarEnum.isOverrideBy(type)) {
            if (type != null && !scalarEnum.isCompatible(type)) {
                throw new IllegalStateException("Error mapping Enum type:" + String.valueOf(enumType) + " It is mapped using 2 different modes when only one is supported (ORDINAL, STRING or an Ebean mapping)");
            }
            return scalarEnum;
        }
        scalarEnum = this.enumTypePerExtensions(enumType);
        if (scalarEnum == null) {
            scalarEnum = this.enumTypePerSpec(enumType, type);
        }
        this.add(scalarEnum);
        return scalarEnum;
    }

    private ScalarTypeEnum<?> enumTypePerSpec(Class<?> enumType, EnumType type) {
        if (type == null) {
            if (this.defaultEnumType == EnumType.ORDINAL) {
                return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
            }
            return new ScalarTypeEnumStandard.StringEnum(enumType);
        }
        if (type == EnumType.ORDINAL) {
            return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
        }
        return new ScalarTypeEnumStandard.StringEnum(enumType);
    }

    private ScalarTypeEnum<?> enumTypePerExtensions(Class<? extends Enum<?>> enumType) {
        for (Method method : enumType.getMethods()) {
            DbEnumValue dbValue = (DbEnumValue)AnnotationUtil.get((AnnotatedElement)method, DbEnumValue.class);
            if (dbValue == null) continue;
            boolean integerValues = DbEnumType.INTEGER == dbValue.storage();
            return this.enumTypeDbValue(enumType, method, integerValues, dbValue.length(), dbValue.withConstraint());
        }
        return this.enumTypeEnumValue(enumType);
    }

    private ScalarTypeEnum<?> enumTypeDbValue(Class<? extends Enum<?>> enumType, Method method, boolean integerType, int length, boolean withConstraint) {
        LinkedHashMap<String, String> nameValueMap = new LinkedHashMap<String, String>();
        for (Enum<?> enumConstant : enumType.getEnumConstants()) {
            try {
                Object value = method.invoke(enumConstant, new Object[0]);
                nameValueMap.put(enumConstant.name(), value.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error trying to invoke DbEnumValue method on " + String.valueOf(enumConstant), e);
            }
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, length, withConstraint);
    }

    private ScalarTypeEnum<?> createEnumScalarType(Class enumType, Map<String, String> nameValueMap, boolean integerType, int dbColumnLength, boolean withConstraint) {
        EnumToDbValueMap<?> beanDbMap = EnumToDbValueMap.create(integerType);
        int maxValueLen = 0;
        for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
            String name = entry.getKey().trim();
            String value = entry.getValue();
            maxValueLen = Math.max(maxValueLen, value.length());
            Object enumValue = Enum.valueOf(enumType, name);
            beanDbMap.add(enumValue, value, name);
        }
        if (dbColumnLength == 0 && !integerType) {
            dbColumnLength = maxValueLen;
        }
        return new ScalarTypeEnumWithMapping(beanDbMap, enumType, dbColumnLength, withConstraint);
    }

    private void initialiseCustomScalarTypes(BootupClasses bootupClasses) {
        for (Class<ScalarType<?>> cls : bootupClasses.getScalarTypes()) {
            try {
                ScalarType<?> scalarType;
                if (this.objectMapper == null) {
                    scalarType = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    try {
                        scalarType = cls.getDeclaredConstructor(ObjectMapper.class).newInstance(this.objectMapper);
                    }
                    catch (NoSuchMethodException e) {
                        scalarType = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                this.add(scalarType);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error loading ScalarType " + cls.getName(), (Throwable)e);
            }
        }
    }

    private Object initObjectMapper(DatabaseConfig config) {
        Object objectMapper = config.getObjectMapper();
        if (objectMapper == null) {
            objectMapper = InitObjectMapper.init();
            config.setObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    private void initialiseScalarConverters(BootupClasses bootupClasses) {
        for (Class<ScalarTypeConverter<?, ?>> foundType : bootupClasses.getScalarConverters()) {
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(foundType, ScalarTypeConverter.class);
                if (paramTypes.length != 2) {
                    throw new IllegalStateException("Expected 2 generics paramtypes but got: " + Arrays.toString(paramTypes));
                }
                Class<?> logicalType = paramTypes[0];
                Object persistType = paramTypes[1];
                ScalarType<?> wrappedType = this.type((Class<?>)persistType);
                if (wrappedType == null) {
                    throw new IllegalStateException("Could not find ScalarType for: " + String.valueOf(paramTypes[1]));
                }
                ScalarTypeConverter<?, ?> converter = foundType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ScalarTypeWrapper stw = new ScalarTypeWrapper(logicalType, wrappedType, converter);
                log.log(System.Logger.Level.DEBUG, "Register ScalarTypeWrapper from {0} -> {1} using:{2}", logicalType, persistType, foundType);
                this.add(stw);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error registering ScalarTypeConverter " + foundType.getName(), (Throwable)e);
            }
        }
    }

    private void initialiseAttributeConverters(BootupClasses bootupClasses) {
        for (Class<AttributeConverter<?, ?>> foundType : bootupClasses.getAttributeConverters()) {
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(foundType, AttributeConverter.class);
                if (paramTypes.length != 2) {
                    throw new IllegalStateException("Expected 2 generics paramtypes but got: " + Arrays.toString(paramTypes));
                }
                Class<?> logicalType = paramTypes[0];
                Object persistType = paramTypes[1];
                ScalarType<?> wrappedType = this.type((Class<?>)persistType);
                if (wrappedType == null) {
                    throw new IllegalStateException("Could not find ScalarType for: " + String.valueOf(paramTypes[1]));
                }
                AttributeConverter<?, ?> converter = foundType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ScalarTypeWrapper stw = new ScalarTypeWrapper(logicalType, wrappedType, new AttributeConverterAdapter(converter));
                log.log(System.Logger.Level.DEBUG, "Register ScalarTypeWrapper from {0} -> {1} using:{2}", logicalType, persistType, foundType);
                this.add(stw);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error registering AttributeConverter " + foundType.getName(), (Throwable)e);
            }
        }
    }

    private void initialiseJavaTimeTypes(DatabaseConfig config) {
        ZoneId zoneId = this.zoneId(config);
        this.typeMap.put(Path.class, (ScalarType<?>)new ScalarTypePath());
        this.addType(Period.class, (ScalarType<?>)new ScalarTypePeriod());
        if (config.getDatabasePlatform().supportsNativeJavaTime()) {
            this.addType(LocalDate.class, (ScalarType<?>)new ScalarTypeLocalDateNative(this.jsonDate));
        } else {
            this.addType(LocalDate.class, (ScalarType<?>)new ScalarTypeLocalDate(this.jsonDate));
        }
        this.addType(LocalDateTime.class, (ScalarType<?>)new ScalarTypeLocalDateTime(this.jsonDateTime));
        this.addType(OffsetDateTime.class, (ScalarType<?>)new ScalarTypeOffsetDateTime(this.jsonDateTime, zoneId));
        this.addType(ZonedDateTime.class, (ScalarType<?>)new ScalarTypeZonedDateTime(this.jsonDateTime, zoneId));
        this.addType(Instant.class, (ScalarType<?>)new ScalarTypeInstant(this.jsonDateTime));
        this.addType(DayOfWeek.class, new ScalarTypeDayOfWeek());
        this.addType(Month.class, new ScalarTypeMonth());
        this.addType(Year.class, (ScalarType<?>)new ScalarTypeYear());
        this.addType(YearMonth.class, (ScalarType<?>)new ScalarTypeYearMonthDate(this.jsonDate));
        this.addType(MonthDay.class, (ScalarType<?>)new ScalarTypeMonthDay());
        this.addType(OffsetTime.class, (ScalarType<?>)new ScalarTypeOffsetTime());
        this.addType(ZoneId.class, (ScalarType<?>)new ScalarTypeZoneId());
        this.addType(ZoneOffset.class, (ScalarType<?>)new ScalarTypeZoneOffset());
        boolean localTimeNanos = config.isLocalTimeWithNanos();
        this.addType(LocalTime.class, (ScalarType<?>)(localTimeNanos ? new ScalarTypeLocalTimeWithNanos() : new ScalarTypeLocalTime()));
        boolean durationNanos = config.isDurationWithNanos();
        this.addType(Duration.class, (ScalarType<?>)(durationNanos ? new ScalarTypeDurationWithNanos() : new ScalarTypeDuration()));
    }

    private ZoneId zoneId(DatabaseConfig config) {
        String dataTimeZone = config.getDataTimeZone();
        return dataTimeZone == null ? ZoneOffset.systemDefault() : TimeZone.getTimeZone(dataTimeZone).toZoneId();
    }

    private void addType(Class<?> clazz, ScalarType<?> scalarType) {
        this.typeMap.put(clazz, scalarType);
        this.logicalMap.putIfAbsent(clazz.getSimpleName(), scalarType);
    }

    private void initialiseStandard(DatabaseConfig config) {
        DatabasePlatform databasePlatform = config.getDatabasePlatform();
        int platformClobType = databasePlatform.clobDbType();
        int platformBlobType = databasePlatform.blobDbType();
        this.nativeMap.put(5000, this.hstoreType);
        this.addType(Date.class, this.extraTypeFactory.createUtilDate(this.jsonDateTime, this.jsonDate));
        this.addType(Calendar.class, this.extraTypeFactory.createCalendar(this.jsonDateTime));
        this.addType(BigInteger.class, this.extraTypeFactory.createMathBigInteger());
        ScalarTypeBool booleanType = this.extraTypeFactory.createBoolean();
        this.addType(Boolean.class, booleanType);
        this.addType(Boolean.TYPE, booleanType);
        databasePlatform.setDbTrueLiteral(booleanType.getDbTrueLiteral());
        databasePlatform.setDbFalseLiteral(booleanType.getDbFalseLiteral());
        this.nativeMap.put(16, booleanType);
        if (booleanType.jdbcType() == -7) {
            this.nativeMap.put(-7, booleanType);
        }
        PlatformConfig.DbUuid dbUuid = config.getPlatformConfig().getDbUuid();
        if (this.offlineMigrationGeneration || databasePlatform.nativeUuidType() && dbUuid.useNativeType()) {
            this.addType(UUID.class, (ScalarType<?>)new ScalarTypeUUIDNative());
        } else {
            ScalarTypeUUIDBase uuidType = dbUuid.useBinary() ? new ScalarTypeUUIDBinary(dbUuid.useBinaryOptimized()) : new ScalarTypeUUIDVarchar();
            this.addType(UUID.class, (ScalarType<?>)uuidType);
        }
        if (this.offlineMigrationGeneration || this.postgres && !config.getPlatformConfig().isDatabaseInetAddressVarchar()) {
            this.addInetAddressType((ScalarType)new ScalarTypeInetAddressPostgres());
        } else {
            this.addInetAddressType((ScalarType)new ScalarTypeInetAddress());
        }
        if (this.offlineMigrationGeneration || this.postgres) {
            this.addType(Cidr.class, (ScalarType<?>)new ScalarTypeCidr.Postgres());
            this.addType(Inet.class, (ScalarType<?>)new ScalarTypeInet.Postgres());
        } else {
            this.addType(Cidr.class, (ScalarType<?>)new ScalarTypeCidr.Varchar());
            this.addType(Inet.class, (ScalarType<?>)new ScalarTypeInet.Varchar());
        }
        this.addType(File.class, this.fileType);
        this.addType(Locale.class, (ScalarType<?>)new ScalarTypeLocale());
        this.addType(Currency.class, (ScalarType<?>)new ScalarTypeCurrency());
        this.addType(TimeZone.class, (ScalarType<?>)new ScalarTypeTimeZone());
        this.addType(URL.class, (ScalarType<?>)new ScalarTypeURL());
        this.addType(URI.class, (ScalarType<?>)new ScalarTypeURI());
        this.addType(char[].class, (ScalarType<?>)new ScalarTypeCharArray());
        this.addType(Character.TYPE, (ScalarType<?>)new ScalarTypeChar());
        this.addType(String.class, (ScalarType<?>)ScalarTypeString.INSTANCE);
        this.nativeMap.put(12, (ScalarType<?>)ScalarTypeString.INSTANCE);
        this.nativeMap.put(1, (ScalarType<?>)ScalarTypeString.INSTANCE);
        this.nativeMap.put(-1, (ScalarType<?>)new ScalarTypeLongVarchar());
        this.addType(Class.class, (ScalarType<?>)new ScalarTypeClass());
        if (platformClobType == 2005) {
            this.nativeMap.put(2005, (ScalarType<?>)new ScalarTypeClob());
        } else {
            ScalarType<?> platClobScalarType = this.nativeMap.get(platformClobType);
            if (platClobScalarType == null) {
                throw new IllegalArgumentException("Not found dbPlatform clobType " + platformClobType);
            }
            this.nativeMap.put(2005, platClobScalarType);
        }
        ScalarTypeBytesVarbinary varbinaryType = new ScalarTypeBytesVarbinary();
        this.addType(byte[].class, (ScalarType<?>)varbinaryType);
        this.nativeMap.put(-3, (ScalarType<?>)varbinaryType);
        this.nativeMap.put(-2, (ScalarType<?>)new ScalarTypeBytesBinary());
        this.nativeMap.put(-4, (ScalarType<?>)new ScalarTypeBytesLongVarbinary());
        if (platformBlobType == 2004) {
            this.nativeMap.put(2004, (ScalarType<?>)new ScalarTypeBytesBlob());
        } else {
            ScalarType<?> platBlobScalarType = this.nativeMap.get(platformBlobType);
            if (platBlobScalarType == null) {
                throw new IllegalArgumentException("Not found dbPlatform blobType " + platformBlobType);
            }
            this.nativeMap.put(2004, platBlobScalarType);
        }
        ScalarTypeByte byteType = new ScalarTypeByte();
        this.addType(Byte.class, (ScalarType<?>)byteType);
        this.addType(Byte.TYPE, (ScalarType<?>)byteType);
        this.nativeMap.put(-6, (ScalarType<?>)byteType);
        ScalarTypeShort shortType = new ScalarTypeShort();
        this.addType(Short.class, (ScalarType<?>)shortType);
        this.addType(Short.TYPE, (ScalarType<?>)shortType);
        this.nativeMap.put(5, (ScalarType<?>)shortType);
        ScalarTypeInteger integerType = new ScalarTypeInteger();
        this.addType(Integer.class, (ScalarType<?>)integerType);
        this.addType(Integer.TYPE, (ScalarType<?>)integerType);
        this.nativeMap.put(4, (ScalarType<?>)integerType);
        ScalarTypeLong longType = new ScalarTypeLong();
        this.addType(Long.class, (ScalarType<?>)longType);
        this.addType(Long.TYPE, (ScalarType<?>)longType);
        this.nativeMap.put(-5, (ScalarType<?>)longType);
        ScalarTypeDouble doubleType = new ScalarTypeDouble();
        this.addType(Double.class, (ScalarType<?>)doubleType);
        this.addType(Double.TYPE, (ScalarType<?>)doubleType);
        this.nativeMap.put(6, (ScalarType<?>)doubleType);
        this.nativeMap.put(8, (ScalarType<?>)doubleType);
        ScalarTypeFloat floatType = new ScalarTypeFloat();
        this.addType(Float.class, (ScalarType<?>)floatType);
        this.addType(Float.TYPE, (ScalarType<?>)floatType);
        this.nativeMap.put(7, (ScalarType<?>)floatType);
        ScalarTypeBigDecimal bigDecimalType = new ScalarTypeBigDecimal();
        this.addType(BigDecimal.class, (ScalarType<?>)bigDecimalType);
        this.nativeMap.put(3, (ScalarType<?>)bigDecimalType);
        this.nativeMap.put(2, (ScalarType<?>)bigDecimalType);
        ScalarTypeTime timeType = new ScalarTypeTime();
        this.addType(Time.class, (ScalarType<?>)timeType);
        this.nativeMap.put(92, (ScalarType<?>)timeType);
        ScalarTypeDate dateType = new ScalarTypeDate(this.jsonDate);
        this.addType(java.sql.Date.class, (ScalarType<?>)dateType);
        this.nativeMap.put(91, (ScalarType<?>)dateType);
        ScalarTypeTimestamp timestampType = new ScalarTypeTimestamp(this.jsonDateTime);
        this.addType(Timestamp.class, (ScalarType<?>)timestampType);
        this.nativeMap.put(93, (ScalarType<?>)timestampType);
    }

    private void addInetAddressType(ScalarType scalarType) {
        this.addType(InetAddress.class, scalarType);
        this.addType(Inet4Address.class, scalarType);
        this.addType(Inet6Address.class, scalarType);
    }
}

