/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.PropertyJoin;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.query.SqlJoinType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ManyWhereJoins
implements Serializable {
    private static final long serialVersionUID = -6490181101871795417L;
    private final TreeMap<String, PropertyJoin> joins = new TreeMap();
    private Map<String, List<String>> formulaJoinProperties;
    private boolean aggregation;
    private boolean requireOuterJoins;

    public boolean isRequireOuterJoins() {
        return this.requireOuterJoins;
    }

    public void setRequireOuterJoins(boolean requireOuterJoins) {
        this.requireOuterJoins = requireOuterJoins;
    }

    public void add(ElPropertyDeploy elProp) {
        String join = elProp.elPrefix();
        BeanProperty p = elProp.beanProperty();
        if (p instanceof BeanPropertyAssocMany) {
            join = this.addManyToJoin(join, p.name());
        }
        if (join != null) {
            String secondaryTableJoinPrefix;
            this.addJoin(join);
            if (p != null && (secondaryTableJoinPrefix = p.secondaryTableJoinPrefix()) != null) {
                this.addJoin(join + "." + secondaryTableJoinPrefix);
            }
            this.addParentJoins(join);
        }
    }

    private String addManyToJoin(String join, String manyPropName) {
        if (join == null) {
            return manyPropName;
        }
        return join + "." + manyPropName;
    }

    private void addParentJoins(String join) {
        String[] split = SplitName.split((String)join);
        if (split[0] != null) {
            this.addJoin(split[0]);
            this.addParentJoins(split[0]);
        }
    }

    private void addJoin(String property) {
        SqlJoinType joinType = this.requireOuterJoins ? SqlJoinType.OUTER : SqlJoinType.INNER;
        this.joins.put(property, new PropertyJoin(property, joinType));
    }

    public boolean requireSqlDistinct() {
        return !this.aggregation && !this.joins.isEmpty();
    }

    public Collection<PropertyJoin> getPropertyJoins() {
        return this.joins.values();
    }

    public TreeSet<String> getPropertyNames() {
        TreeSet<String> propertyNames = new TreeSet<String>();
        for (PropertyJoin join : this.joins.values()) {
            propertyNames.add(join.getProperty());
        }
        return propertyNames;
    }

    public void addFormulaWithJoin(String prefix, String name) {
        if (this.formulaJoinProperties == null) {
            this.formulaJoinProperties = new HashMap<String, List<String>>();
        }
        this.formulaJoinProperties.computeIfAbsent(prefix, k -> new ArrayList()).add(name);
    }

    public boolean isFormulaWithJoin(String prefix) {
        return this.formulaJoinProperties != null && this.formulaJoinProperties.containsKey(prefix);
    }

    public List<String> getFormulaJoinProperties(String prefix) {
        return this.formulaJoinProperties.get(prefix);
    }

    public void setAggregation() {
        this.aggregation = true;
    }

    public void addAggregationJoin(String property) {
        this.aggregation = true;
        this.joins.put(property, new PropertyJoin(property, SqlJoinType.INNER));
    }
}

