/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeDouble
extends ScalarTypeBase<Double> {
    ScalarTypeDouble() {
        super(Double.class, true, 8);
    }

    public void bind(DataBinder binder, Double value) throws SQLException {
        if (value == null) {
            binder.setNull(8);
        } else {
            binder.setDouble(value.doubleValue());
        }
    }

    public Double read(DataReader dataReader) throws SQLException {
        return dataReader.getDouble();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toDouble((Object)value);
    }

    public Double toBeanType(Object value) {
        return BasicTypeConverter.toDouble((Object)value);
    }

    public String formatValue(Double t) {
        return t.toString();
    }

    public Double parse(String value) {
        return Double.valueOf(value);
    }

    public Double readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readDouble();
    }

    public void writeData(DataOutput dataOutput, Double value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeDouble(value);
        }
    }

    public Double jsonRead(JsonParser parser) throws IOException {
        return parser.getDoubleValue();
    }

    public void jsonWrite(JsonGenerator writer, Double value) throws IOException {
        writer.writeNumber(value.doubleValue());
    }

    public DocPropertyType docType() {
        return DocPropertyType.DOUBLE;
    }
}

