/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeWrapper<B, S>
implements ScalarType<B> {
    private final ScalarType<S> scalarType;
    private final ScalarTypeConverter<B, S> converter;
    private final Class<B> wrapperType;
    private final B nullValue;

    public ScalarTypeWrapper(Class<B> wrapperType, ScalarType<S> scalarType, ScalarTypeConverter<B, S> converter) {
        this.scalarType = scalarType;
        this.converter = converter;
        this.nullValue = converter.getNullValue();
        this.wrapperType = wrapperType;
    }

    public String toString() {
        return "ScalarTypeWrapper " + this.wrapperType + " to " + this.scalarType.type();
    }

    public long asVersion(B value) {
        return this.scalarType.asVersion(this.converter.unwrapValue(value));
    }

    public boolean binary() {
        return this.scalarType.binary();
    }

    public boolean mutable() {
        return this.scalarType.mutable();
    }

    public boolean isDirty(Object value) {
        return this.scalarType.isDirty(value);
    }

    public B readData(DataInput dataInput) throws IOException {
        Object unwrapValue = this.scalarType.readData(dataInput);
        return (B)this.converter.wrapValue(unwrapValue);
    }

    public void writeData(DataOutput dataOutput, B value) throws IOException {
        Object unwrapValue = this.converter.unwrapValue(value);
        this.scalarType.writeData(dataOutput, unwrapValue);
    }

    public void bind(DataBinder binder, B value) throws SQLException {
        if (value == null) {
            this.scalarType.bind(binder, null);
        } else {
            Object sv = this.converter.unwrapValue(value);
            this.scalarType.bind(binder, sv);
        }
    }

    public int jdbcType() {
        return this.scalarType.jdbcType();
    }

    public int length() {
        return this.scalarType.length();
    }

    public Class<B> type() {
        return this.wrapperType;
    }

    public boolean jdbcNative() {
        return false;
    }

    public String formatValue(B v) {
        Object sv = this.converter.unwrapValue(v);
        return this.scalarType.formatValue(sv);
    }

    public B parse(String value) {
        Object sv = this.scalarType.parse(value);
        if (sv == null) {
            return this.nullValue;
        }
        return (B)this.converter.wrapValue(sv);
    }

    public B read(DataReader reader) throws SQLException {
        Object sv = this.scalarType.read(reader);
        if (sv == null) {
            return this.nullValue;
        }
        return (B)this.converter.wrapValue(sv);
    }

    public B toBeanType(Object value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.type().isAssignableFrom(value.getClass())) {
            return (B)value;
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        Object sv = this.scalarType.toBeanType(value);
        return (B)this.converter.wrapValue(sv);
    }

    public Object toJdbcType(Object value) {
        Object sv = this.converter.unwrapValue(value);
        return this.scalarType.toJdbcType(sv);
    }

    public ScalarType<?> getScalarType() {
        return this;
    }

    public B jsonRead(JsonParser parser) throws IOException {
        Object object = this.scalarType.jsonRead(parser);
        return (B)this.converter.wrapValue(object);
    }

    public void jsonWrite(JsonGenerator writer, B beanValue) throws IOException {
        Object unwrapValue = this.converter.unwrapValue(beanValue);
        this.scalarType.jsonWrite(writer, unwrapValue);
    }

    public DocPropertyType docType() {
        return this.scalarType.docType();
    }
}

