/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.ModifyAwareType;
import io.ebean.annotation.MutationDetection;
import io.ebean.core.type.ScalarJsonManager;

final class TypeJsonManager
implements ScalarJsonManager {
    private final boolean postgres;
    private final Object mapper;
    private final MutationDetection mutationDetection;

    TypeJsonManager(boolean postgres, Object mapper, MutationDetection mutationDetection) {
        this.postgres = postgres;
        this.mapper = mapper;
        this.mutationDetection = mutationDetection;
    }

    public MutationDetection mutationDetection() {
        return this.mutationDetection;
    }

    public Object mapper() {
        return this.mapper;
    }

    public String postgresType(int dbType) {
        if (this.postgres) {
            switch (dbType) {
                case 5001: {
                    return "json";
                }
                case 5002: {
                    return "jsonb";
                }
            }
        }
        return null;
    }

    static boolean checkIsDirty(Object value) {
        if (value instanceof ModifyAwareType) {
            return TypeJsonManager.checkModifyAware(value);
        }
        return true;
    }

    private static boolean checkModifyAware(Object value) {
        ModifyAwareType modifyAware = (ModifyAwareType)value;
        if (modifyAware.isMarkedDirty()) {
            modifyAware.setMarkedDirty(false);
            return true;
        }
        return false;
    }
}

