/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DatabasePlatformProvider;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.DbOffline;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

public class DatabasePlatformFactory {
    private final List<DatabasePlatformProvider> providers = new ArrayList<DatabasePlatformProvider>();

    public DatabasePlatformFactory() {
        for (DatabasePlatformProvider platformProvider : ServiceLoader.load(DatabasePlatformProvider.class)) {
            this.providers.add(platformProvider);
        }
    }

    public DatabasePlatform create(DatabaseConfig config) {
        try {
            String offlinePlatform = DbOffline.getPlatform();
            if (offlinePlatform != null) {
                CoreLog.log.log(System.Logger.Level.INFO, "offline platform [{0}]", offlinePlatform);
                return this.byDatabaseName(offlinePlatform);
            }
            if (config.getDatabasePlatformName() != null) {
                return this.byDatabaseName(config.getDatabasePlatformName());
            }
            if (config.getDataSourceConfig().isOffline()) {
                throw new PersistenceException("DatabasePlatformName must be specified with offline mode");
            }
            return this.byDataSource(config.getDataSource());
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private DatabasePlatform byDatabaseName(String dbName) {
        dbName = dbName.toLowerCase();
        for (DatabasePlatformProvider provider : this.providers) {
            if (!provider.match(dbName)) continue;
            return provider.create(dbName);
        }
        throw new RuntimeException("database platform " + dbName + " is not known?");
    }

    private DatabasePlatform byDataSource(DataSource dataSource) {
        DatabasePlatform databasePlatform;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                databasePlatform = this.byDatabaseMeta(connection.getMetaData(), connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
            connection.close();
        }
        return databasePlatform;
    }

    private DatabasePlatform byDatabaseMeta(DatabaseMetaData metaData, Connection connection) throws SQLException {
        String dbProductName = metaData.getDatabaseProductName().toLowerCase();
        int majorVersion = metaData.getDatabaseMajorVersion();
        int minorVersion = metaData.getDatabaseMinorVersion();
        CoreLog.log.log(System.Logger.Level.DEBUG, "platform for productName[{0}] version[{1}.{2}]", dbProductName, majorVersion, minorVersion);
        for (DatabasePlatformProvider provider : this.providers) {
            if (!provider.matchByProductName(dbProductName)) continue;
            return provider.create(majorVersion, minorVersion, metaData, connection);
        }
        if (this.providers.isEmpty()) {
            throw new IllegalStateException("There are no ebean platform providers in the classpath. Add a missing dependency like ebean-h2, ebean-postgres, ebean-mysql etc to support the database [" + dbProductName + "]. Adding a dependency on io.ebean:ebean will add support for all platforms.");
        }
        throw new IllegalStateException("Unable to determine the appropriate ebean platform given database product name [" + dbProductName + "] and ebean platform providers " + this.providers + ". With ebean 13+ we now have separate platforms (ebean-postgres, ebean-mysql etc) and should use database specific platform dependency like ebean-postgres. Note that we can use ebean-platform-all to include all the platforms.");
    }
}

