/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPersistListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ChainedBeanPersistListener
implements BeanPersistListener {
    private final List<BeanPersistListener> list;
    private final BeanPersistListener[] chain;

    ChainedBeanPersistListener(BeanPersistListener c1, BeanPersistListener c2) {
        this(ChainedBeanPersistListener.addList(c1, c2));
    }

    int size() {
        return this.chain.length;
    }

    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    private static List<BeanPersistListener> addList(BeanPersistListener c1, BeanPersistListener c2) {
        ArrayList<BeanPersistListener> addList = new ArrayList<BeanPersistListener>(2);
        addList.add(c1);
        addList.add(c2);
        return addList;
    }

    public ChainedBeanPersistListener(List<BeanPersistListener> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPersistListener[0]);
    }

    public ChainedBeanPersistListener register(BeanPersistListener c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>(this.list);
        newList.add(c);
        return new ChainedBeanPersistListener(newList);
    }

    public ChainedBeanPersistListener deregister(BeanPersistListener c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>(this.list);
        newList.remove(c);
        return new ChainedBeanPersistListener(newList);
    }

    public void deleted(Object bean) {
        for (BeanPersistListener listener : this.chain) {
            listener.deleted(bean);
        }
    }

    public void softDeleted(Object bean) {
        for (BeanPersistListener listener : this.chain) {
            listener.softDeleted(bean);
        }
    }

    public void inserted(Object bean) {
        for (BeanPersistListener listener : this.chain) {
            listener.inserted(bean);
        }
    }

    public void updated(Object bean, Set<String> updatedProperties) {
        for (BeanPersistListener listener : this.chain) {
            listener.updated(bean, updatedProperties);
        }
    }
}

