/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebeaninternal.server.dto.DtoMappingRequest;
import io.ebeaninternal.server.dto.DtoMetaConstructor;
import io.ebeaninternal.server.dto.DtoMetaProperty;
import io.ebeaninternal.server.dto.DtoQueryPlan;
import io.ebeaninternal.server.dto.DtoQueryPlanConPlus;
import io.ebeaninternal.server.dto.DtoQueryPlanConSetter;
import io.ebeaninternal.server.dto.DtoQueryPlanConstructor;
import io.ebeaninternal.server.dto.DtoReadSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class DtoMeta {
    private final Class<?> dtoType;
    private final Map<String, DtoMetaProperty> propMap = new LinkedHashMap<String, DtoMetaProperty>();
    private final Map<Integer, DtoMetaConstructor> constructorMap = new LinkedHashMap<Integer, DtoMetaConstructor>();
    private final DtoMetaConstructor defaultConstructor;
    private final DtoMetaConstructor maxArgConstructor;

    DtoMeta(Class<?> dtoType, List<DtoMetaConstructor> constructors, List<DtoMetaProperty> properties) {
        this.dtoType = dtoType;
        for (DtoMetaProperty property : properties) {
            this.propMap.put(property.getName().toUpperCase(), property);
        }
        int maxArg = 0;
        DtoMetaConstructor defaultConstructor = null;
        DtoMetaConstructor maxArgConstructor = null;
        for (DtoMetaConstructor constructor : constructors) {
            int args = constructor.getArgCount();
            this.constructorMap.put(args, constructor);
            if (args == 0) {
                defaultConstructor = constructor;
                continue;
            }
            if (args <= maxArg) continue;
            maxArgConstructor = constructor;
            maxArg = args;
        }
        this.defaultConstructor = defaultConstructor;
        this.maxArgConstructor = maxArgConstructor;
    }

    public DtoQueryPlan match(DtoMappingRequest request) {
        Object[] cols = request.getColumnMeta();
        int colLen = cols.length;
        DtoMetaConstructor constructor = this.constructorMap.get(colLen);
        if (constructor != null) {
            return new DtoQueryPlanConstructor(request, constructor);
        }
        if (this.maxArgConstructor != null && colLen > this.maxArgConstructor.getArgCount()) {
            return this.matchMaxArgPlusSetters(request);
        }
        if (this.defaultConstructor != null) {
            return this.matchSetters(request);
        }
        String msg = "Unable to map the resultSet columns " + Arrays.toString(cols) + " to the bean type [" + this.dtoType + "] as the number of columns in the resultSet is less than the constructor (and that there is no default constructor) ?";
        throw new IllegalStateException(msg);
    }

    private DtoQueryPlanConPlus matchMaxArgPlusSetters(DtoMappingRequest request) {
        DtoReadSet[] setterProps = request.mapArgPlusSetters(this, this.maxArgConstructor.getArgCount());
        return new DtoQueryPlanConPlus(request, this.maxArgConstructor, setterProps);
    }

    private DtoQueryPlan matchSetters(DtoMappingRequest request) {
        DtoReadSet[] setterProps = request.mapSetters(this);
        return new DtoQueryPlanConSetter(request, this.defaultConstructor, setterProps);
    }

    DtoReadSet findProperty(String label) {
        String upperLabel = label.toUpperCase();
        DtoMetaProperty property = this.propMap.get(upperLabel);
        if (property == null && upperLabel.startsWith("IS_")) {
            property = this.propMap.get(upperLabel.substring(3));
        }
        if (property == null) {
            property = this.propMap.get(upperLabel.replace("_", ""));
        }
        return property;
    }

    Class<?> dtoType() {
        return this.dtoType;
    }
}

