/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.core.PersistRequestUpdateSql;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.BatchDepthComparator;
import io.ebeaninternal.server.persist.BatchDepthOrder;
import io.ebeaninternal.server.persist.BatchedBeanHolder;
import io.ebeaninternal.server.persist.BatchedPstmtHolder;
import io.ebeaninternal.server.persist.BatchedSqlException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;

public final class BatchControl {
    private static final Object DUMMY = new Object();
    private static final BatchDepthComparator depthComparator = new BatchDepthComparator();
    private final BatchedPstmtHolder pstmtHolder = new BatchedPstmtHolder();
    private final HashMap<String, BatchedBeanHolder> beanHoldMap = new HashMap();
    private final IdentityHashMap<Object, Object> persistedBeans = new IdentityHashMap();
    private final BatchDepthOrder depthOrder = new BatchDepthOrder();
    private final SpiTransaction transaction;
    private int batchSize;
    private boolean getGeneratedKeys;
    private boolean batchFlushOnMixed = true;
    private int bufferMax;
    private final Queue[] queues = new Queue[3];

    public BatchControl(SpiTransaction t, int batchSize, boolean getGenKeys) {
        this.transaction = t;
        this.batchSize = batchSize;
        this.getGeneratedKeys = getGenKeys;
        this.transaction.setBatchControl(this);
    }

    public void setBatchFlushOnMixed(boolean flushBatchOnMixed) {
        this.batchFlushOnMixed = flushBatchOnMixed;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 1) {
            this.batchSize = batchSize;
        }
    }

    public void setGetGeneratedKeys(Boolean getGeneratedKeys) {
        if (getGeneratedKeys != null) {
            this.getGeneratedKeys = getGeneratedKeys;
        }
    }

    public int executeStatementOrBatch(PersistRequest request, boolean batch, boolean addBatch) throws BatchedSqlException {
        if (!batch || this.batchFlushOnMixed && !this.isBeansEmpty()) {
            this.flush();
        }
        if (!batch) {
            return request.executeNow();
        }
        if (!addBatch && this.pstmtHolder.maxSize() >= this.batchSize) {
            this.flush();
        }
        request.executeNow();
        return -1;
    }

    public int executeOrQueue(PersistRequestBean<?> request, boolean batch) throws BatchedSqlException {
        if (!batch || this.batchFlushOnMixed && !this.pstmtHolder.isEmpty()) {
            this.flush();
        }
        if (!batch) {
            return request.executeNow();
        }
        if (this.addToBatch(request)) {
            this.flush();
        }
        return -1;
    }

    private boolean addToBatch(PersistRequestBean<?> request) {
        Object alreadyInBatch = this.persistedBeans.put(request.entityBean(), DUMMY);
        if (alreadyInBatch != null) {
            return false;
        }
        BatchedBeanHolder beanHolder = this.beanHolder(request);
        int bufferSize = beanHolder.append(request);
        this.bufferMax = Math.max(this.bufferMax, bufferSize);
        return this.bufferMax >= this.batchSize * 10;
    }

    public BatchedPstmtHolder pstmtHolder() {
        return this.pstmtHolder;
    }

    public boolean isEmpty() {
        return this.isBeansEmpty() && this.pstmtHolder.isEmpty();
    }

    private void flushPstmtHolder() throws BatchedSqlException {
        this.pstmtHolder.flush(this.getGeneratedKeys, false);
    }

    private void flushPstmtHolder(boolean reset) throws BatchedSqlException {
        this.pstmtHolder.flush(this.getGeneratedKeys, reset);
    }

    void executeNow(ArrayList<PersistRequest> list) throws BatchedSqlException {
        for (int i = 0; i < list.size(); ++i) {
            if (i % this.batchSize == 0) {
                this.flushPstmtHolder();
            }
            list.get(i).executeNow();
        }
        this.flushPstmtHolder();
    }

    public void flushOnCommit() throws BatchedSqlException {
        try {
            this.flushBuffer(false);
        }
        finally {
            this.pstmtHolder.clear();
        }
    }

    public void flush() throws BatchedSqlException {
        this.flushBuffer(false);
    }

    public void flushReset() throws BatchedSqlException {
        this.flushBuffer(true);
    }

    public void clear() {
        this.pstmtHolder.clear();
        this.beanHoldMap.clear();
        this.depthOrder.clear();
        this.persistedBeans.clear();
    }

    private void flushBuffer(boolean reset) throws BatchedSqlException {
        this.flushQueue(this.queues[0]);
        this.flushInternal(reset);
        this.flushQueue(this.queues[1]);
        this.flushQueue(this.queues[2]);
    }

    private void flushQueue(Queue queue) throws BatchedSqlException {
        if (queue != null && queue.flush() && !this.pstmtHolder.isEmpty()) {
            this.flushPstmtHolder();
        }
    }

    private void flushInternal(boolean reset) throws BatchedSqlException {
        try {
            this.bufferMax = 0;
            if (!this.pstmtHolder.isEmpty()) {
                this.flushPstmtHolder(reset);
            }
            if (this.isEmpty()) {
                return;
            }
            this.executeAll();
            this.persistedBeans.clear();
            if (reset) {
                this.beanHoldMap.clear();
                this.depthOrder.clear();
            }
        }
        catch (BatchedSqlException e) {
            this.clear();
            throw e;
        }
    }

    private void executeAll() throws BatchedSqlException {
        do {
            Object[] bsArray = this.beanHolderArray();
            Arrays.sort(bsArray, depthComparator);
            if (this.transaction.isLogSummary()) {
                this.transaction.logSummary("BatchControl flush {0}", Arrays.toString(bsArray));
            }
            for (Object beanHolder : bsArray) {
                ((BatchedBeanHolder)beanHolder).executeNow();
            }
        } while (!this.isBeanHoldersEmpty());
    }

    private boolean isBeanHoldersEmpty() {
        for (BatchedBeanHolder beanHolder : this.beanHoldMap.values()) {
            if (beanHolder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private BatchedBeanHolder beanHolder(PersistRequestBean<?> request) {
        int depth = this.transaction.depth();
        BeanDescriptor<?> desc = request.descriptor();
        String key = desc.rootName() + ":" + depth;
        BatchedBeanHolder batchBeanHolder = this.beanHoldMap.get(key);
        if (batchBeanHolder == null) {
            int ordering = this.depthOrder.orderingFor(depth);
            batchBeanHolder = new BatchedBeanHolder(this, desc, ordering);
            this.beanHoldMap.put(key, batchBeanHolder);
        }
        return batchBeanHolder;
    }

    private boolean isBeansEmpty() {
        return this.persistedBeans.isEmpty();
    }

    private BatchedBeanHolder[] beanHolderArray() {
        return this.beanHoldMap.values().toArray(new BatchedBeanHolder[0]);
    }

    public int[] execute(String key, boolean getGeneratedKeys) throws SQLException {
        return this.pstmtHolder.execute(key, getGeneratedKeys);
    }

    public void addToFlushQueue(PersistRequestUpdateSql request, int pos) {
        if (this.queues[pos] == null) {
            this.queues[pos] = new Queue();
        }
        this.queues[pos].add(request);
    }

    private static class Queue {
        private final List<PersistRequestUpdateSql> queue = new ArrayList<PersistRequestUpdateSql>();

        private Queue() {
        }

        boolean flush() {
            if (this.queue.isEmpty()) {
                return false;
            }
            for (PersistRequestUpdateSql request : this.queue) {
                request.executeAddBatch();
            }
            this.queue.clear();
            return true;
        }

        void add(PersistRequestUpdateSql request) {
            this.queue.add(request);
        }
    }
}

