/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarTypeBaseVarchar;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ConvertInetAddresses;
import java.net.InetAddress;
import java.sql.SQLException;

final class ScalarTypeInetAddressPostgres
extends ScalarTypeBaseVarchar<InetAddress> {
    ScalarTypeInetAddressPostgres() {
        super(InetAddress.class, false, 5020);
    }

    public void bind(DataBinder binder, InetAddress value) throws SQLException {
        if (value == null) {
            binder.setNull(1111);
        } else {
            String strValue = this.convertToDbString(value);
            binder.setObject(PostgresHelper.asInet((String)strValue));
        }
    }

    public InetAddress convertFromDbString(String dbValue) {
        try {
            return this.parse(dbValue);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error with InetAddresses [" + dbValue + "] " + e);
        }
    }

    public String convertToDbString(InetAddress beanValue) {
        return this.formatValue(beanValue);
    }

    public String formatValue(InetAddress v) {
        return ConvertInetAddresses.toHostAddress(v);
    }

    public InetAddress parse(String value) {
        try {
            return ConvertInetAddresses.fromHost(value);
        }
        catch (IllegalArgumentException e) {
            throw new TextException("Error with InetAddresses [{}]", value, (Exception)e);
        }
    }
}

