/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;

final class ScalarTypeInstant
extends ScalarTypeBaseDateTime<Instant> {
    ScalarTypeInstant(JsonConfig.DateTime mode) {
        super(mode, Instant.class, false, 93);
    }

    protected String toJsonNanos(Instant value) {
        return this.toJsonNanos(value.getEpochSecond(), value.getNano());
    }

    protected String toJsonISO8601(Instant value) {
        return value.toString();
    }

    protected Instant fromJsonISO8601(String value) {
        return Instant.parse(value);
    }

    public long convertToMillis(Instant value) {
        return value.toEpochMilli();
    }

    public Instant convertFromMillis(long systemTimeMillis) {
        return Instant.ofEpochMilli(systemTimeMillis);
    }

    public Instant convertFromTimestamp(Timestamp ts) {
        return ts.toInstant();
    }

    public Instant convertFromInstant(Instant ts) {
        return ts;
    }

    public Timestamp convertToTimestamp(Instant t) {
        return Timestamp.from(t);
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((Instant)value);
    }

    public Instant toBeanType(Object value) {
        if (value instanceof Timestamp) {
            return this.convertFromTimestamp((Timestamp)value);
        }
        return (Instant)value;
    }
}

