/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionAdd;
import io.ebean.bean.EntityBean;
import io.ebean.common.BeanSet;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BaseCollectionHelp;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class BeanSetHelp<T>
extends BaseCollectionHelp<T> {
    BeanSetHelp(BeanPropertyAssocMany<T> many) {
        super(many);
    }

    BeanSetHelp() {
    }

    @Override
    public final BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        if (bc instanceof BeanSet) {
            BeanSet beanSet = (BeanSet)bc;
            if (beanSet.actualSet() == null) {
                beanSet.setActualSet(new LinkedHashSet());
            }
            return beanSet;
        }
        throw new RuntimeException("Unhandled type " + String.valueOf(bc));
    }

    @Override
    public final Object createEmptyReference() {
        return Collections.EMPTY_SET;
    }

    @Override
    public final BeanCollection<T> createEmptyNoParent() {
        return new BeanSet();
    }

    @Override
    public final BeanCollection<T> createEmpty(EntityBean ownerBean) {
        BeanSet beanSet = new BeanSet(this.loader, ownerBean, this.propertyName);
        if (this.many != null) {
            beanSet.setModifyListening(this.many.modifyListenMode());
        }
        return beanSet;
    }

    @Override
    public final BeanCollection<T> createReference(EntityBean parentBean) {
        BeanSet beanSet = new BeanSet(this.loader, parentBean, this.propertyName);
        beanSet.setModifyListening(this.many.modifyListenMode());
        return beanSet;
    }

    @Override
    public final void refresh(SpiEbeanServer server, Query<?> query, Transaction t, EntityBean parentBean) {
        BeanSet newBeanSet = (BeanSet)server.findSet(query, t);
        this.refresh((BeanCollection<?>)newBeanSet, parentBean);
    }

    @Override
    public final void refresh(BeanCollection<?> bc, EntityBean parentBean) {
        BeanSet newBeanSet = (BeanSet)bc;
        Set current = (Set)this.many.getValue(parentBean);
        newBeanSet.setModifyListening(this.many.modifyListenMode());
        if (current == null) {
            this.many.setValue(parentBean, newBeanSet);
        } else if (current instanceof BeanSet) {
            BeanSet currentBeanSet = (BeanSet)current;
            currentBeanSet.setActualSet(newBeanSet.actualSet());
            currentBeanSet.setModifyListening(this.many.modifyListenMode());
        } else {
            this.many.setValue(parentBean, newBeanSet);
        }
    }

    @Override
    public final void jsonWrite(SpiJsonWriter ctx, String name, Object collection, boolean explicitInclude) throws IOException {
        Set set;
        if (collection instanceof BeanCollection) {
            BeanSet bc = (BeanSet)collection;
            if (!bc.isPopulated()) {
                if (explicitInclude) {
                    bc.size();
                } else {
                    return;
                }
            }
            set = bc.actualSet();
        } else {
            set = (Set)collection;
        }
        this.jsonWriteCollection(ctx, name, set);
    }
}

