/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.IsEmptyExpression;
import java.io.IOException;

final class NullExpression
extends AbstractExpression {
    private final boolean notNull;
    private ElPropertyValue elProperty;
    private boolean assocMany;
    private String propertyPath;

    NullExpression(String propertyName, boolean notNull) {
        super(propertyName);
        this.notNull = notNull;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.elProperty = desc.elGetValue(this.propName);
        if (this.elProperty != null && this.elProperty.isAssocMany()) {
            this.assocMany = true;
            this.propertyPath = SplitName.split((String)this.propName)[0];
            this.propertyContainsMany(this.propertyPath, desc, manyWhereJoin);
        } else {
            if (this.elProperty != null && this.elProperty.containsMany() && !this.notNull) {
                manyWhereJoin.setRequireOuterJoins(true);
            }
            this.propertyContainsMany(this.propName, desc, manyWhereJoin);
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeExists(this.notNull, this.propName);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String nullExpr;
        if (this.assocMany) {
            IsEmptyExpression.isEmptySql(request, this.elProperty, !this.notNull, this.propertyPath);
            return;
        }
        String string = nullExpr = this.notNull ? " is not null" : " is null";
        if (this.elProperty != null && this.elProperty.isAssocId()) {
            request.parse(this.elProperty.assocIdExpression(this.propName, nullExpr));
        } else {
            request.property(this.propName).append(nullExpr);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return true;
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.notNull) {
            builder.append("NotNull[");
        } else {
            builder.append("Null[");
        }
        builder.append(this.propName).append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.notNull);
    }
}

