/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeLoad;
import io.ebeaninternal.server.query.SqlTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class SqlTreeNodeExtraJoin
implements SqlTreeNode {
    private final STreePropertyAssoc assocBeanProperty;
    private final SpiQuery.TemporalMode temporalMode;
    private final String prefix;
    private final boolean manyJoin;
    private final boolean pathContainsMany;
    private List<SqlTreeNode> children;

    SqlTreeNodeExtraJoin(String prefix, STreePropertyAssoc assocBeanProperty, boolean pathContainsMany, SpiQuery.TemporalMode temporalMode) {
        this.prefix = prefix;
        this.assocBeanProperty = assocBeanProperty;
        this.pathContainsMany = pathContainsMany;
        this.temporalMode = temporalMode;
        this.manyJoin = assocBeanProperty instanceof STreePropertyAssocMany;
    }

    @Override
    public SqlTreeLoad createLoad() {
        return null;
    }

    @Override
    public boolean isSingleProperty() {
        return false;
    }

    @Override
    public void buildRawSqlSelectChain(List<String> selectChain) {
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
    }

    @Override
    public void addSoftDeletePredicate(SpiQuery<?> query) {
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public void appendGroupBy(DbSqlContext ctx, boolean subQuery) {
    }

    boolean isManyJoin() {
        return this.manyJoin;
    }

    public String name() {
        return this.prefix;
    }

    public void addChild(SqlTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<SqlTreeNode>();
        }
        this.children.add(child);
    }

    @Override
    public void dependentTables(Set<String> tables) {
        tables.add(this.assocBeanProperty.target().baseTable(SpiQuery.TemporalMode.CURRENT));
        if (this.children != null) {
            for (SqlTreeNode child : this.children) {
                child.dependentTables(tables);
            }
        }
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        BeanPropertyAssocOne oneToOneProp;
        STreePropertyAssocMany manyProp;
        boolean manyToMany = false;
        if (this.assocBeanProperty instanceof STreePropertyAssocMany && (manyProp = (STreePropertyAssocMany)this.assocBeanProperty).hasJoinTable()) {
            manyToMany = true;
            String alias = ctx.tableAlias(this.prefix);
            String[] split = SplitName.split((String)this.prefix);
            String parentAlias = ctx.tableAlias(split[0]);
            String alias2 = alias + "z_";
            TableJoin manyToManyJoin = manyProp.intersectionTableJoin();
            manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
            this.assocBeanProperty.addJoin(joinType, alias2, alias, ctx);
        }
        boolean oneToOneExported = false;
        if (this.assocBeanProperty instanceof BeanPropertyAssocOne && (oneToOneProp = (BeanPropertyAssocOne)this.assocBeanProperty).isOneToOneExported()) {
            oneToOneExported = true;
        }
        if (this.pathContainsMany) {
            joinType = SqlJoinType.OUTER;
        }
        if (!manyToMany) {
            if (this.assocBeanProperty.isFormula()) {
                this.assocBeanProperty.appendFrom(ctx, joinType, null);
            }
            joinType = this.assocBeanProperty.addJoin(joinType, this.prefix, ctx);
            if (!oneToOneExported && this.assocBeanProperty.isTargetSoftDelete() && this.temporalMode != SpiQuery.TemporalMode.SOFT_DELETED) {
                ctx.append(" and ").append(this.assocBeanProperty.softDeletePredicate(ctx.tableAlias(this.prefix)));
            }
        }
        if (this.children != null) {
            ctx.pushJoin(this.prefix);
            ctx.pushTableAlias(this.prefix);
            if (this.manyJoin || this.pathContainsMany) {
                joinType = joinType.autoToOuter();
            }
            for (SqlTreeNode child : this.children) {
                child.appendFrom(ctx, joinType);
            }
            ctx.popTableAlias();
            ctx.popJoin();
        }
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendWhere(DbSqlContext ctx) {
    }

    @Override
    public boolean hasMany() {
        return this.manyJoin;
    }
}

