/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api;

import io.ebean.DocStoreQueueEntry;
import io.ebeanservice.docstore.api.DocStoreUpdate;
import java.util.ArrayList;
import java.util.List;

public final class DocStoreUpdates {
    private final List<DocStoreUpdate> persistEvents = new ArrayList<DocStoreUpdate>();
    private final List<DocStoreUpdate> deleteEvents = new ArrayList<DocStoreUpdate>();
    private final List<DocStoreQueueEntry> nestedEvents = new ArrayList<DocStoreQueueEntry>();
    private final List<DocStoreQueueEntry> queueEntries = new ArrayList<DocStoreQueueEntry>();

    public boolean isEmpty() {
        return this.persistEvents.isEmpty() && this.deleteEvents.isEmpty() && this.nestedEvents.isEmpty() && this.queueEntries.isEmpty();
    }

    public void addPersist(DocStoreUpdate bulkRequest) {
        this.persistEvents.add(bulkRequest);
    }

    public void addDelete(DocStoreUpdate bulkRequest) {
        this.deleteEvents.add(bulkRequest);
    }

    public void addNested(String queueId, String path, Object beanId) {
        this.nestedEvents.add(new DocStoreQueueEntry(DocStoreQueueEntry.Action.NESTED, queueId, path, beanId));
    }

    public void queueIndex(String queueId, Object beanId) {
        this.queueEntries.add(new DocStoreQueueEntry(DocStoreQueueEntry.Action.INDEX, queueId, beanId));
    }

    public void queueDelete(String queueId, Object beanId) {
        this.queueEntries.add(new DocStoreQueueEntry(DocStoreQueueEntry.Action.DELETE, queueId, beanId));
    }

    public void queueNested(String queueId, String path, Object beanId) {
        this.queueEntries.add(new DocStoreQueueEntry(DocStoreQueueEntry.Action.NESTED, queueId, path, beanId));
    }

    public List<DocStoreUpdate> persistEvents() {
        return this.persistEvents;
    }

    public List<DocStoreUpdate> deleteEvents() {
        return this.deleteEvents;
    }

    public List<DocStoreQueueEntry> nestedEvents() {
        return this.nestedEvents;
    }

    public List<DocStoreQueueEntry> queueEntries() {
        return this.queueEntries;
    }
}

