/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.cache.QueryCacheEntryValidate;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheOptions;
import io.ebeaninternal.server.cache.DefaultServerCache;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class DefaultServerCacheConfig {
    private final ServerCacheConfig config;
    private final int maxSize;
    private final int maxIdleSecs;
    private final int maxSecsToLive;
    private final int trimFrequency;
    private final Map<Object, SoftReference<DefaultServerCache.CacheEntry>> map;

    public DefaultServerCacheConfig(ServerCacheConfig config) {
        this(config, new ConcurrentHashMap<Object, SoftReference<DefaultServerCache.CacheEntry>>());
    }

    public DefaultServerCacheConfig(ServerCacheConfig config, Map<Object, SoftReference<DefaultServerCache.CacheEntry>> map) {
        this.config = config;
        this.map = map;
        ServerCacheOptions options = config.getCacheOptions();
        this.maxIdleSecs = options.getMaxIdleSecs();
        this.maxSecsToLive = options.getMaxSecsToLive();
        this.trimFrequency = options.getTrimFrequency();
        this.maxSize = options.getMaxSize();
    }

    public QueryCacheEntryValidate getQueryCacheEntryValidate() {
        return this.config.getQueryCacheEntryValidate();
    }

    public String getName() {
        return this.config.getCacheKey();
    }

    public String getShortName() {
        return this.config.getShortName();
    }

    public Map<Object, SoftReference<DefaultServerCache.CacheEntry>> getMap() {
        return this.map;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxIdleSecs() {
        return this.maxIdleSecs;
    }

    public int getMaxSecsToLive() {
        return this.maxSecsToLive;
    }

    public int determineTrimFrequency() {
        if (this.trimFrequency > 0) {
            return this.trimFrequency;
        }
        if (this.maxIdleSecs > 0) {
            return this.maxIdleSecs / 2 - 1;
        }
        if (this.maxSecsToLive > 0) {
            return this.maxSecsToLive / 2 - 1;
        }
        return 0;
    }

    public long determineTrimOnPut() {
        if (this.maxSize > 0) {
            return this.maxSize / 10;
        }
        return 1000L;
    }
}

