/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.DbForeignKey;
import io.ebean.annotation.FetchPreference;
import io.ebean.annotation.NotNull;
import io.ebean.annotation.TenantId;
import io.ebean.annotation.Where;
import io.ebean.config.NamingConvention;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import io.ebeaninternal.server.deploy.parse.AnnotationAssoc;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import io.ebeaninternal.server.query.SqlJoinType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;

final class AnnotationAssocOnes
extends AnnotationAssoc {
    AnnotationAssocOnes(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig, BeanDescriptorManager factory) {
        super(info, readConfig, factory);
    }

    @Override
    public void parse() {
        for (DeployBeanProperty prop : this.descriptor.propertiesAll()) {
            if (!(prop instanceof DeployBeanPropertyAssocOne)) continue;
            this.readAssocOne((DeployBeanPropertyAssocOne)prop);
        }
    }

    private void readAssocOne(DeployBeanPropertyAssocOne<?> prop) {
        NotNull nonNull;
        FetchPreference fetchPreference;
        PrimaryKeyJoinColumn primaryKeyJoin;
        Where where;
        DbForeignKey dbForeignKey;
        Id id;
        Column column;
        EmbeddedId emId;
        Embedded embedded;
        OneToOne oneToOne;
        ManyToOne manyToOne = this.get(prop, ManyToOne.class);
        if (manyToOne != null) {
            this.readManyToOne(manyToOne, prop);
            if (this.get(prop, TenantId.class) != null) {
                prop.setTenantId();
            }
        }
        if ((oneToOne = this.get(prop, OneToOne.class)) != null) {
            this.readOneToOne(oneToOne, prop);
        }
        if ((embedded = this.get(prop, Embedded.class)) != null) {
            this.readEmbedded(prop, embedded);
        }
        if ((emId = this.get(prop, EmbeddedId.class)) != null) {
            prop.setEmbedded();
            prop.setId();
            prop.setNullable(false);
        }
        if ((column = prop.getMetaAnnotation(Column.class)) != null && !this.isEmpty(column.name())) {
            prop.setDbColumn(column.name());
        }
        if ((id = this.get(prop, Id.class)) != null) {
            this.readIdAssocOne(prop);
        }
        if ((dbForeignKey = this.get(prop, DbForeignKey.class)) != null) {
            prop.setForeignKey(new PropertyForeignKey(dbForeignKey));
        }
        if ((where = prop.getMetaAnnotationWhere(this.platform)) != null) {
            prop.setExtraWhere(this.processFormula(where.clause()));
        }
        if ((primaryKeyJoin = this.get(prop, PrimaryKeyJoinColumn.class)) != null) {
            this.readPrimaryKeyJoin(primaryKeyJoin, prop);
        }
        if ((fetchPreference = this.get(prop, FetchPreference.class)) != null) {
            prop.setFetchPreference(fetchPreference.value());
        }
        if ((nonNull = this.get(prop, NotNull.class)) != null) {
            prop.setNullable(false);
        }
        if (this.readConfig.isValidationNotNull(prop)) {
            prop.setNullable(false);
            prop.getTableJoin().setType(SqlJoinType.INNER);
        }
        BeanTable beanTable = prop.getBeanTable();
        for (JoinColumn joinColumn : this.annotationJoinColumns(prop)) {
            this.setFromJoinColumn(prop, beanTable, joinColumn);
            this.checkForNoConstraint(prop, joinColumn);
        }
        JoinTable joinTable = this.get(prop, JoinTable.class);
        if (joinTable != null) {
            for (JoinColumn joinColumn : joinTable.joinColumns()) {
                this.setFromJoinColumn(prop, beanTable, joinColumn);
            }
        }
        prop.setJoinType(prop.isNullable());
        if (!prop.getTableJoin().hasJoinColumns() && beanTable != null && prop.getMappedBy() == null) {
            NamingConvention namingConvention = this.factory.namingConvention();
            String fkeyPrefix = null;
            if (namingConvention.isUseForeignKeyPrefix()) {
                fkeyPrefix = namingConvention.getColumnFromProperty(this.beanType, prop.getName());
            }
            beanTable.createJoinColumn(fkeyPrefix, prop.getTableJoin(), true, prop.getSqlFormulaSelect());
        }
    }

    private void setFromJoinColumn(DeployBeanPropertyAssocOne<?> prop, BeanTable beanTable, JoinColumn joinColumn) {
        if (beanTable == null) {
            throw new IllegalStateException("Looks like a missing @ManyToOne or @OneToOne on property " + String.valueOf(prop) + " - no related 'BeanTable'");
        }
        prop.getTableJoin().addJoinColumn(this.util, false, joinColumn, beanTable);
        if (!joinColumn.updatable()) {
            prop.setDbUpdateable(false);
        }
        if (!joinColumn.nullable()) {
            prop.setNullable(false);
        }
    }

    private void checkForNoConstraint(DeployBeanPropertyAssocOne<?> prop, JoinColumn joinColumn) {
        try {
            ForeignKey foreignKey = joinColumn.foreignKey();
            if (foreignKey.value() == ConstraintMode.NO_CONSTRAINT) {
                prop.setForeignKey(new PropertyForeignKey());
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void readManyToOne(ManyToOne propAnn, DeployBeanPropertyAssocOne<?> beanProp) {
        this.setCascadeTypes(propAnn.cascade(), beanProp.getCascadeInfo());
        this.setTargetType(propAnn.targetEntity(), beanProp);
        this.setBeanTable(beanProp);
        beanProp.setDbInsertable(true);
        beanProp.setDbUpdateable(true);
        beanProp.setNullable(propAnn.optional());
        beanProp.setFetchType(propAnn.fetch());
    }

    private void readOneToOne(OneToOne propAnn, DeployBeanPropertyAssocOne<?> prop) {
        prop.setOneToOne();
        prop.setDbInsertable(true);
        prop.setDbUpdateable(true);
        prop.setNullable(propAnn.optional());
        prop.setFetchType(propAnn.fetch());
        prop.setMappedBy(propAnn.mappedBy());
        if (this.readOrphanRemoval(propAnn)) {
            prop.setOrphanRemoval();
        }
        if (!"".equals(propAnn.mappedBy())) {
            prop.setOneToOneExported();
        }
        this.setCascadeTypes(propAnn.cascade(), prop.getCascadeInfo());
        this.setTargetType(propAnn.targetEntity(), prop);
        this.setBeanTable(prop);
    }

    private boolean readOrphanRemoval(OneToOne property) {
        try {
            return property.orphanRemoval();
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private void readPrimaryKeyJoin(PrimaryKeyJoinColumn primaryKeyJoin, DeployBeanPropertyAssocOne<?> prop) {
        if (!prop.isOneToOne()) {
            throw new IllegalStateException("Expecting property " + String.valueOf(prop) + " with PrimaryKeyJoinColumn to be a OneToOne?");
        }
        prop.setPrimaryKeyJoin(true);
        if (!primaryKeyJoin.name().isEmpty()) {
            CoreLog.internal.log(System.Logger.Level.INFO, "Automatically determining join columns for @PrimaryKeyJoinColumn - ignoring PrimaryKeyJoinColumn.name attribute [{0}] on {1}", primaryKeyJoin.name(), prop);
        }
        if (!primaryKeyJoin.referencedColumnName().isEmpty()) {
            CoreLog.internal.log(System.Logger.Level.INFO, "Automatically determining join columns for @PrimaryKeyJoinColumn - Ignoring PrimaryKeyJoinColumn.referencedColumnName attribute [{0}] on {1}", primaryKeyJoin.referencedColumnName(), prop);
        }
        BeanTable baseBeanTable = this.factory.beanTable(this.info.getDescriptor().getBeanType());
        String localPrimaryKey = baseBeanTable.getIdColumn();
        String foreignColumn = this.getBeanTable(prop).getIdColumn();
        prop.getTableJoin().addJoinColumn(new DeployTableJoinColumn(localPrimaryKey, foreignColumn, false, false));
    }

    private void readEmbedded(DeployBeanPropertyAssocOne<?> prop, Embedded embedded) {
        if (this.descriptor.isDocStoreOnly() && prop.getDocStoreDoc() == null) {
            prop.setDocStoreEmbedded("");
        }
        prop.setEmbedded();
        prop.setDbInsertable(true);
        prop.setDbUpdateable(true);
        try {
            prop.setColumnPrefix(embedded.prefix());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.readEmbeddedAttributeOverrides(prop);
    }
}

