/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.DbArray;
import io.ebean.annotation.DbJson;
import io.ebean.annotation.DbJsonB;
import io.ebean.annotation.DbJsonType;
import io.ebean.annotation.DbMap;
import io.ebean.annotation.MutationDetection;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.EncryptDeploy;
import io.ebean.config.EncryptDeployManager;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.Encryptor;
import io.ebean.config.NamingConvention;
import io.ebean.config.TableName;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.type.DataEncryptSupport;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeWrapper;
import io.ebeaninternal.server.type.SimpleAesEncryptor;
import io.ebeaninternal.server.type.TypeManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceException;

public final class DeployUtil {
    private static final int dbCLOBType = 2005;
    private static final int dbBLOBType = 2004;
    private static final int DEFAULT_JSON_VARCHAR_LENGTH = 3000;
    private final NamingConvention namingConvention;
    private final TypeManager typeManager;
    private final DatabasePlatform dbPlatform;
    private final EncryptDeployManager encryptDeployManager;
    private final EncryptKeyManager encryptKeyManager;
    private final Encryptor bytesEncryptor;
    private final boolean useValidationNotNull;

    public DeployUtil(TypeManager typeMgr, DatabaseConfig config) {
        this.typeManager = typeMgr;
        this.namingConvention = config.getNamingConvention();
        this.dbPlatform = config.getDatabasePlatform();
        this.encryptDeployManager = config.getEncryptDeployManager();
        this.encryptKeyManager = config.getEncryptKeyManager();
        Encryptor be = config.getEncryptor();
        this.bytesEncryptor = be != null ? be : new SimpleAesEncryptor();
        this.useValidationNotNull = config.isUseValidationNotNull();
    }

    public TypeManager typeManager() {
        return this.typeManager;
    }

    public DatabasePlatform dbPlatform() {
        return this.dbPlatform;
    }

    public NamingConvention namingConvention() {
        return this.namingConvention;
    }

    void checkEncryptKeyManagerDefined(String fullPropName) {
        if (this.encryptKeyManager == null) {
            String msg = "Using encryption on " + fullPropName + " but no EncryptKeyManager defined!";
            throw new PersistenceException(msg);
        }
    }

    EncryptDeploy encryptDeploy(TableName table, String column) {
        if (this.encryptDeployManager == null) {
            return EncryptDeploy.ANNOTATION;
        }
        return this.encryptDeployManager.getEncryptDeploy(table, column);
    }

    DataEncryptSupport createDataEncryptSupport(String table, String column) {
        return new DataEncryptSupport(this.encryptKeyManager, this.bytesEncryptor, table, column);
    }

    void setEnumScalarType(Enumerated enumerated, DeployBeanProperty prop) {
        Class<?> enumType = prop.getPropertyType();
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("Class [" + String.valueOf(enumType) + "] is Not a Enum?");
        }
        try {
            Class<?> enumClass = enumType;
            EnumType type = enumerated != null ? enumerated.value() : null;
            ScalarType<?> scalarType = this.typeManager.enumType(enumClass, type);
            prop.setScalarType(scalarType);
            prop.setDbType(scalarType.jdbcType());
        }
        catch (IllegalStateException e) {
            throw new PersistenceException("Error mapping property " + String.valueOf(prop) + " - " + e.getMessage());
        }
    }

    public void setScalarType(DeployBeanProperty property) {
        if (property.getScalarType() != null) {
            return;
        }
        ScalarType<?> scalarType = this.scalarType(property);
        if (scalarType != null) {
            property.setDbType(scalarType.jdbcType());
            property.setScalarType(scalarType);
            property.checkPrimitiveBoolean();
        }
    }

    private ScalarType<?> scalarType(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        try {
            ScalarType<?> scalarType = this.typeManager.type(propType, property.getDbType());
            if (scalarType != null || property.isTransient()) {
                return scalarType;
            }
            throw new PersistenceException(String.valueOf(property) + " has no ScalarType - type " + propType.getName());
        }
        catch (IllegalArgumentException e) {
            if (property.isTransient()) {
                return null;
            }
            throw e;
        }
    }

    void setDbMap(DeployBeanProperty prop, DbMap dbMap) {
        ScalarType<?> scalarType = this.typeManager.dbMapType();
        int dbType = scalarType.jdbcType();
        prop.setDbType(dbType);
        prop.setScalarType(scalarType);
        if (dbType == 12) {
            int dbLength = dbMap.length();
            int columnLength = dbLength > 0 ? dbLength : 3000;
            prop.setDbLength(columnLength);
        }
    }

    void setDbArray(DeployBeanProperty prop, DbArray dbArray) {
        Object columnDefn;
        Class<?> type;
        ScalarType<?> scalarType;
        if (!dbArray.nullable()) {
            prop.setNullable(false);
        }
        if ((scalarType = this.typeManager.dbArrayType(type = prop.getPropertyType(), prop.getGenericType(), prop.isNullable())) == null) {
            throw new RuntimeException("No ScalarType for @DbArray type for " + String.valueOf(prop));
        }
        int dbType = scalarType.jdbcType();
        prop.setDbType(dbType);
        prop.setScalarType(scalarType);
        if (scalarType instanceof ScalarTypeArray) {
            columnDefn = ((ScalarTypeArray)scalarType).getDbColumnDefn();
            if (dbArray.length() > 0) {
                columnDefn = (String)columnDefn + "(" + dbArray.length() + ")";
            }
        } else {
            throw new RuntimeException("Not mapped to ScalarTypeArray? " + String.valueOf(scalarType.getClass()));
        }
        prop.setDbLength(dbArray.length());
        prop.setDbColumnDefn((String)columnDefn);
    }

    void setDbJsonType(DeployBeanProperty prop, DbJson dbJsonType) {
        int dbType = this.dbJsonStorage(dbJsonType.storage());
        this.setDbJsonType(prop, dbType, dbJsonType.length(), dbJsonType.mutationDetection());
    }

    void setDbJsonBType(DeployBeanProperty prop, DbJsonB dbJsonB) {
        this.setDbJsonType(prop, 5002, dbJsonB.length(), dbJsonB.mutationDetection());
    }

    private void setDbJsonType(DeployBeanProperty prop, int dbType, int dbLength, MutationDetection mutationDetection) {
        prop.setDbType(dbType);
        prop.setMutationDetection(mutationDetection);
        ScalarType<?> scalarType = this.typeManager.dbJsonType(prop, dbType, dbLength);
        if (scalarType == null) {
            throw new RuntimeException("No ScalarType for JSON property " + String.valueOf(prop) + " dbType:" + dbType);
        }
        prop.setScalarType(scalarType);
        if (dbType == 12 || dbLength > 0) {
            int columnLength = dbLength > 0 ? dbLength : 3000;
            prop.setDbLength(columnLength);
        }
    }

    private int dbJsonStorage(DbJsonType dbJsonType) {
        switch (dbJsonType) {
            case JSONB: {
                return 5002;
            }
            case VARCHAR: {
                return 12;
            }
            case CLOB: {
                return 2005;
            }
            case BLOB: {
                return 2004;
            }
        }
        return 5001;
    }

    void setLobType(DeployBeanProperty prop) {
        ScalarType<?> scalarType = prop.getScalarType();
        if (scalarType instanceof ScalarTypeWrapper) {
            int lobType = scalarType.jdbcType() == 12 ? 2005 : 2004;
            prop.setDbType(lobType);
        } else {
            Class<?> type;
            int lobType = this.isClobType(type = prop.getPropertyType()) ? 2005 : 2004;
            scalarType = this.typeManager.type(type, lobType);
            if (scalarType == null) {
                throw new RuntimeException("No ScalarType for LOB type " + String.valueOf(type) + " dbType:" + lobType);
            }
            prop.setDbType(lobType);
            prop.setScalarType(scalarType);
        }
    }

    private boolean isClobType(Class<?> type) {
        return type.equals(String.class);
    }

    boolean isUseValidationNotNull() {
        return this.useValidationNotNull;
    }

    public String convertQuotes(String name) {
        return this.dbPlatform.convertQuotedIdentifiers(name);
    }
}

