/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.visitor;

import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.InheritInfoVisitor;
import io.ebeaninternal.server.deploy.visitor.BeanPropertyVisitor;

public class VisitProperties {
    public static void visit(BeanDescriptor<?> descriptor, BeanPropertyVisitor visitor) {
        new VisitProperties().visitProperties(descriptor, visitor);
    }

    protected void visitProperties(BeanDescriptor<?> desc, BeanPropertyVisitor propertyVisitor) {
        BeanPropertyAssocOne<?> unidirectional;
        BeanProperty idProp = desc.idProperty();
        if (idProp != null) {
            this.visit(propertyVisitor, idProp);
        }
        if ((unidirectional = desc.unidirectional()) != null) {
            this.visit(propertyVisitor, unidirectional);
        }
        for (BeanProperty p : desc.propertiesNonTransient()) {
            if (!p.isDDLColumn()) continue;
            this.visit(propertyVisitor, p);
        }
        this.visitInheritanceProperties(desc, propertyVisitor);
        propertyVisitor.visitEnd();
    }

    protected void visit(BeanPropertyVisitor pv, BeanProperty p) {
        if (p instanceof BeanPropertyAssocMany) {
            pv.visitMany((BeanPropertyAssocMany)p);
        } else if (p instanceof BeanPropertyAssocOne) {
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)p;
            if (assocOne.isEmbedded()) {
                BeanProperty[] embProps;
                pv.visitEmbedded(assocOne);
                for (BeanProperty embProp : embProps = assocOne.properties()) {
                    pv.visitEmbeddedScalar(embProp, assocOne);
                }
            } else if (assocOne.isOneToOneExported()) {
                pv.visitOneExported(assocOne);
            } else {
                pv.visitOneImported(assocOne);
            }
        } else {
            pv.visitScalar(p, true);
        }
    }

    protected void visitInheritanceProperties(BeanDescriptor<?> descriptor, BeanPropertyVisitor pv) {
        InheritInfo inheritInfo = descriptor.inheritInfo();
        if (inheritInfo != null && inheritInfo.isRoot()) {
            inheritInfo.visitChildren(new InheritChildVisitor(this, pv));
        }
    }

    protected static class InheritChildVisitor
    implements InheritInfoVisitor {
        private final VisitProperties owner;
        private final BeanPropertyVisitor pv;

        protected InheritChildVisitor(VisitProperties owner, BeanPropertyVisitor pv) {
            this.owner = owner;
            this.pv = pv;
        }

        @Override
        public void visit(InheritInfo inheritInfo) {
            for (BeanProperty beanProperty : inheritInfo.desc().propertiesLocal()) {
                if (!beanProperty.isDDLColumn()) continue;
                this.owner.visit(this.pv, beanProperty);
            }
        }
    }
}

