/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.server.persist.BatchPostExecute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

final class DB2GetKeys {
    private static Class<? extends PreparedStatement> DB2_PREPARED_STATEMENT;
    private static Method GET_DB_GENERATED_KEYS;

    DB2GetKeys() {
    }

    static boolean getGeneratedKeys(PreparedStatement pstmt, List<BatchPostExecute> list) throws SQLException {
        if (DB2_PREPARED_STATEMENT != null) {
            PreparedStatement db2Stmt = null;
            if (DB2_PREPARED_STATEMENT.isInstance(pstmt)) {
                db2Stmt = pstmt;
            } else if (pstmt.isWrapperFor(DB2_PREPARED_STATEMENT)) {
                db2Stmt = pstmt.unwrap(DB2_PREPARED_STATEMENT);
            }
            if (db2Stmt != null) {
                ResultSet[] result;
                try {
                    result = (ResultSet[])GET_DB_GENERATED_KEYS.invoke((Object)db2Stmt, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new SQLException("Could not get generated keys for DB2", e);
                }
                int index = 0;
                for (ResultSet resultSet : result) {
                    while (resultSet.next()) {
                        Object idValue = resultSet.getObject(1);
                        list.get(index++).setGeneratedKey(idValue);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static {
        try {
            DB2_PREPARED_STATEMENT = Class.forName("com.ibm.db2.jcc.DB2PreparedStatement");
            GET_DB_GENERATED_KEYS = DB2_PREPARED_STATEMENT.getDeclaredMethod("getDBGeneratedKeys", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }
}

