/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.BatchedPstmt;
import io.ebeaninternal.server.persist.BatchedPstmtHolder;
import io.ebeaninternal.server.persist.TrimLogSql;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class PstmtFactory {
    PstmtFactory() {
    }

    CallableStatement cstmt(SpiTransaction t, String sql) throws SQLException {
        Connection conn = t.getInternalConnection();
        return conn.prepareCall(sql);
    }

    PreparedStatement pstmt(SpiTransaction t, String sql, boolean getGeneratedKeys) throws SQLException {
        Connection conn = t.getInternalConnection();
        if (getGeneratedKeys) {
            return conn.prepareStatement(sql, 1);
        }
        return conn.prepareStatement(sql);
    }

    PreparedStatement pstmtBatch(SpiTransaction t, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().pstmtHolder();
        BatchedPstmt existingStmt = batch.batchedPstmt(sql);
        if (existingStmt != null) {
            if (existingStmt.isEmpty() && t.isLogSql()) {
                t.logSql(TrimLogSql.trim(sql), new Object[0]);
            }
            return existingStmt.statement(batchExe);
        }
        if (t.isLogSql()) {
            t.logSql(TrimLogSql.trim(sql), new Object[0]);
        }
        Connection conn = t.getInternalConnection();
        PreparedStatement stmt = conn.prepareStatement(sql);
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, t);
        batch.addStmt(bs, batchExe);
        return stmt;
    }

    CallableStatement cstmtBatch(SpiTransaction t, boolean logSql, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().pstmtHolder();
        CallableStatement stmt = (CallableStatement)batch.stmt(sql, batchExe);
        if (stmt != null) {
            return stmt;
        }
        if (logSql) {
            t.logSql(sql, new Object[0]);
        }
        Connection conn = t.getInternalConnection();
        stmt = conn.prepareCall(sql);
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, t);
        batch.addStmt(bs, batchExe);
        return stmt;
    }
}

