/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.ValuePair;
import io.ebean.Version;
import io.ebean.annotation.Platform;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.JdbcClose;
import io.ebean.util.StringHelper;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.DiffHelp;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQuery;
import io.ebeaninternal.server.query.CQueryBuilder;
import io.ebeaninternal.server.query.CQueryDraftSupport;
import io.ebeaninternal.server.query.CQueryFetchSingleAttribute;
import io.ebeaninternal.server.query.CQueryHistorySupport;
import io.ebeaninternal.server.query.CQueryRowCount;
import io.ebeaninternal.server.query.CQueryUpdate;
import io.ebeaninternal.server.query.OrderVersionDesc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public final class CQueryEngine {
    private static final String T0 = "t0";
    private final int defaultFetchSizeFindList;
    private final int defaultFetchSizeFindEach;
    private final boolean forwardOnlyHintOnFindIterate;
    private final CQueryBuilder queryBuilder;
    private final CQueryHistorySupport historySupport;
    private final DatabasePlatform dbPlatform;

    public CQueryEngine(DatabaseConfig config, DatabasePlatform dbPlatform, Binder binder, Map<String, String> asOfTableMapping, Map<String, String> draftTableMap) {
        this.dbPlatform = dbPlatform;
        this.defaultFetchSizeFindEach = config.getJdbcFetchSizeFindEach();
        this.defaultFetchSizeFindList = config.getJdbcFetchSizeFindList();
        this.forwardOnlyHintOnFindIterate = dbPlatform.forwardOnlyHintOnFindIterate();
        this.historySupport = new CQueryHistorySupport(dbPlatform.historySupport(), asOfTableMapping, config.getAsOfSysPeriod());
        this.queryBuilder = new CQueryBuilder(dbPlatform, binder, this.historySupport, new CQueryDraftSupport(draftTableMap));
    }

    public int forwardOnlyFetchSize() {
        Platform base = this.dbPlatform.platform().base();
        return Platform.MYSQL == base ? Integer.MIN_VALUE : 1;
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        return this.queryBuilder.buildQuery(request);
    }

    public <T> int delete(OrmQueryRequest<T> request) {
        CQueryUpdate query = this.queryBuilder.buildUpdateQuery(true, request);
        request.setCancelableQuery(query);
        return this.executeUpdate(request, query);
    }

    public <T> int update(OrmQueryRequest<T> request) {
        CQueryUpdate query = this.queryBuilder.buildUpdateQuery(false, request);
        request.setCancelableQuery(query);
        return this.executeUpdate(request, query);
    }

    private <T> int executeUpdate(OrmQueryRequest<T> request, CQueryUpdate query) {
        try {
            int rows = query.execute();
            if (request.logSql()) {
                request.logSql("{0}; --bind({1}) --micros({2}) --rows({3})", query.generatedSql(), query.bindLog(), query.micros(), rows);
            }
            return rows;
        }
        catch (SQLException e) {
            throw this.translate(request, query.bindLog(), query.generatedSql(), e);
        }
    }

    public <A extends Collection<?>> A findSingleAttributeList(OrmQueryRequest<?> request, A collection) {
        CQueryFetchSingleAttribute rcQuery = this.queryBuilder.buildFetchAttributeQuery(request);
        request.setCancelableQuery(rcQuery);
        return this.findAttributeCollection(request, rcQuery, collection);
    }

    private <A extends Collection<?>> A findAttributeCollection(OrmQueryRequest<?> request, CQueryFetchSingleAttribute rcQuery, A collection) {
        try {
            rcQuery.findCollection((Collection)collection);
            if (request.logSql()) {
                this.logGeneratedSql(request, rcQuery.generatedSql(), rcQuery.bindLog(), rcQuery.micros());
            }
            if (request.logSummary()) {
                request.transaction().logSummary(rcQuery.summary(), new Object[0]);
            }
            if (request.isQueryCachePut()) {
                request.addDependentTables(rcQuery.dependentTables());
                if (collection instanceof List) {
                    collection = Collections.unmodifiableList((List)collection);
                    request.putToQueryCache(collection);
                    if (Boolean.FALSE.equals(request.query().isReadOnly())) {
                        collection = new ArrayList(collection);
                    }
                } else if (collection instanceof Set) {
                    collection = Collections.unmodifiableSet((Set)collection);
                    request.putToQueryCache(collection);
                    if (Boolean.FALSE.equals(request.query().isReadOnly())) {
                        collection = new LinkedHashSet(collection);
                    }
                }
            }
            return collection;
        }
        catch (SQLException e) {
            throw this.translate(request, rcQuery.bindLog(), rcQuery.generatedSql(), e);
        }
    }

    <T> PersistenceException translate(OrmQueryRequest<T> request, String bindLog, String sql, SQLException e) {
        Transaction t = request.transaction();
        if (t.isLogSummary()) {
            t.logSummary("ERROR executing query, bindLog[{0}] error:{1}", bindLog, StringHelper.removeNewLines((String)e.getMessage()));
        }
        t.connection();
        return this.dbPlatform.translate("Query threw SQLException:" + e.getMessage() + " Bind values:[" + bindLog + "] Query was:" + sql, e);
    }

    public <A> List<A> findIds(OrmQueryRequest<?> request) {
        CQueryFetchSingleAttribute rcQuery = this.queryBuilder.buildFetchIdsQuery(request);
        request.setCancelableQuery(rcQuery);
        return this.findAttributeCollection(request, rcQuery, new ArrayList());
    }

    private <T> void logGeneratedSql(OrmQueryRequest<T> request, String sql, String bindLog, long micros) {
        request.logSql("{0}; --bind({1}) --micros({2})", sql, bindLog, micros);
    }

    public <T> int findCount(OrmQueryRequest<T> request) {
        CQueryRowCount rcQuery = this.queryBuilder.buildRowCountQuery(request);
        request.setCancelableQuery(rcQuery);
        try {
            int count = rcQuery.findCount();
            if (request.logSql()) {
                this.logGeneratedSql(request, rcQuery.generatedSql(), rcQuery.bindLog(), rcQuery.micros());
            }
            if (request.logSummary()) {
                request.transaction().logSummary(rcQuery.summary(), new Object[0]);
            }
            if (request.query().isFutureFetch()) {
                request.transaction().end();
            }
            if (request.isQueryCachePut()) {
                request.addDependentTables(rcQuery.dependentTables());
                request.putToQueryCache(count);
            }
            return count;
        }
        catch (SQLException e) {
            throw this.translate(request, rcQuery.bindLog(), rcQuery.generatedSql(), e);
        }
    }

    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            int iterateBufferSize;
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            if (!cquery.prepareBindExecuteQueryForwardOnly(this.forwardOnlyHintOnFindIterate)) {
                return null;
            }
            if (request.logSql()) {
                this.logSql(cquery);
            }
            if ((iterateBufferSize = request.secondaryQueriesMinBatchSize()) < 1) {
                int queryBatch = request.query().getLazyLoadBatchSize();
                iterateBufferSize = queryBatch > 0 ? queryBatch : 100;
            }
            QueryIterator<T> readIterate = cquery.readIterate(iterateBufferSize, request);
            if (request.logSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindIterate();
            }
            return readIterate;
        }
        catch (SQLException e) {
            try {
                PersistenceException pex = cquery.createPersistenceException(e);
                cquery.close();
                throw pex;
            }
            catch (Throwable throwable) {
                request.rollbackTransIfRequired();
                throw throwable;
            }
        }
    }

    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        Query query = request.query();
        String sysPeriodLower = this.getSysPeriodLower((SpiQuery<T>)query);
        if (query.isVersionsBetween() && !this.historySupport.isStandardsBased()) {
            query.where().lt(sysPeriodLower, (Object)query.getVersionEnd());
            query.where().geOrNull(this.getSysPeriodUpper((SpiQuery<T>)query), (Object)query.getVersionStart());
        }
        query.order().desc(sysPeriodLower);
        request.setCancelableQuery(cquery);
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            cquery.prepareBindExecuteQuery();
            if (request.logSql()) {
                this.logSql(cquery);
            }
            List<Version<T>> versions = cquery.readVersions();
            versions.sort(OrderVersionDesc.INSTANCE);
            this.deriveVersionDiffs(versions, request);
            if (request.logSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            List<Version<T>> list = versions;
            return list;
        }
    }

    private <T> void deriveVersionDiffs(List<Version<T>> versions, OrmQueryRequest<T> request) {
        BeanDescriptor<T> descriptor = request.descriptor();
        if (!versions.isEmpty()) {
            Version<T> current = versions.get(0);
            if (versions.size() > 1) {
                for (int i = 1; i < versions.size(); ++i) {
                    Version<T> next = versions.get(i);
                    this.deriveVersionDiff(current, next, descriptor);
                    current = next;
                }
            }
            current.setDiff(new LinkedHashMap());
        }
    }

    private <T> void deriveVersionDiff(Version<T> current, Version<T> prior, BeanDescriptor<T> descriptor) {
        Map<String, ValuePair> diff = DiffHelp.diff(current.getBean(), prior.getBean(), descriptor);
        current.setDiff(diff);
    }

    private <T> String getSysPeriodLower(SpiQuery<T> query) {
        return this.historySupport.sysPeriodLower(query.getAlias(T0));
    }

    private <T> String getSysPeriodUpper(SpiQuery<T> query) {
        return this.historySupport.sysPeriodUpper(query.getAlias(T0));
    }

    public <T> SpiResultSet findResultSet(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            boolean fwdOnly;
            if (request.isFindIterate()) {
                fwdOnly = this.forwardOnlyHintOnFindIterate;
                if (this.defaultFetchSizeFindEach > 0) {
                    request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
                }
            } else {
                fwdOnly = false;
                if (this.defaultFetchSizeFindList > 0) {
                    request.setDefaultFetchBuffer(this.defaultFetchSizeFindList);
                }
            }
            ResultSet resultSet = cquery.prepareResultSet(fwdOnly);
            if (request.logSql()) {
                this.logSql(cquery);
            }
            return new SpiResultSet(cquery.pstmt(), resultSet);
        }
        catch (SQLException e) {
            JdbcClose.close((Statement)cquery.pstmt());
            throw cquery.createPersistenceException(e);
        }
    }

    <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        request.setCancelableQuery(cquery);
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            if (this.defaultFetchSizeFindList > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindList);
            }
            if (!cquery.prepareBindExecuteQuery()) {
                BeanCollection<T> beanCollection = null;
                return beanCollection;
            }
            if (request.logSql()) {
                this.logSql(cquery);
            }
            BeanCollection<T> beanCollection = cquery.readCollection();
            if (request.logSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            request.executeSecondaryQueries(false);
            if (request.isQueryCachePut()) {
                request.addDependentTables(cquery.dependentTables());
            }
            BeanCollection<T> beanCollection2 = beanCollection;
            return beanCollection2;
        }
    }

    public <T> T find(OrmQueryRequest<T> request) {
        EntityBean bean = null;
        request.setCancelableQuery(cquery);
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            cquery.prepareBindExecuteQuery();
            if (request.logSql()) {
                this.logSql(cquery);
            }
            if (cquery.readBean()) {
                bean = cquery.next();
            }
            if (request.logSummary()) {
                this.logFindBeanSummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFind(bean);
            }
            request.executeSecondaryQueries(false);
            EntityBean entityBean = bean;
            return (T)entityBean;
        }
    }

    private void logSql(CQuery<?> query) {
        query.transaction().logSql("{0}; --bind({1}) --micros({2})", query.generatedSql(), query.bindLog(), query.micros());
    }

    private void logFindBeanSummary(CQuery<?> q) {
        Query query = q.request().query();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.origin() == null ? null : node.origin().key();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindBean ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.beanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.queryExecutionTimeMicros());
        msg.append("] rows[").append(q.loadedRowDetail());
        msg.append("] bind[").append(q.bindLog()).append("]");
        q.transaction().logSummary(msg.toString(), new Object[0]);
    }

    private void logFindManySummary(CQuery<?> q) {
        Query query = q.request().query();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.origin() == null ? null : node.origin().key();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindMany ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.beanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.queryExecutionTimeMicros());
        msg.append("] rows[").append(q.loadedRowDetail());
        msg.append("] predicates[").append(q.logWhereSql());
        msg.append("] bind[").append(q.bindLog()).append("]");
        q.transaction().logSummary(msg.toString(), new Object[0]);
    }
}

