/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.TenantSchemaProvider;
import io.ebean.datasource.DataSourcePool;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

final class MultiTenantDbSchemaSupplier
implements DataSourceSupplier {
    private final CurrentTenantProvider tenantProvider;
    private final DataSource dataSource;
    private final DataSource readOnlyDataSource;
    private final SchemaDataSource schemaDataSource;
    private final SchemaDataSource readOnly;

    MultiTenantDbSchemaSupplier(CurrentTenantProvider tenantProvider, DataSource dataSource, DataSource readOnlyDataSource, TenantSchemaProvider schemaProvider) {
        this.tenantProvider = tenantProvider;
        this.dataSource = dataSource;
        this.readOnlyDataSource = readOnlyDataSource;
        this.schemaDataSource = new SchemaDataSource(dataSource, schemaProvider, tenantProvider);
        this.readOnly = readOnlyDataSource == null ? null : new SchemaDataSource(readOnlyDataSource, schemaProvider, tenantProvider);
    }

    @Override
    public Object currentTenantId() {
        return this.tenantProvider.currentId();
    }

    @Override
    public DataSource dataSource() {
        return this.schemaDataSource;
    }

    @Override
    public DataSource readOnlyDataSource() {
        return this.readOnly;
    }

    @Override
    public Connection connection(Object tenantId) throws SQLException {
        return this.schemaDataSource.getConnectionForTenant(tenantId);
    }

    @Override
    public Connection readOnlyConnection(Object tenantId) throws SQLException {
        return this.readOnly.getConnectionForTenant(tenantId);
    }

    @Override
    public void shutdown(boolean deregisterDriver) {
        if (this.readOnlyDataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.readOnlyDataSource).shutdown();
        }
        if (this.dataSource instanceof DataSourcePool) {
            ((DataSourcePool)this.dataSource).shutdown();
        }
    }

    private static class SchemaDataSource
    implements DataSource {
        private final DataSource dataSource;
        private final TenantSchemaProvider schemaProvider;
        private final CurrentTenantProvider tenantProvider;

        SchemaDataSource(DataSource dataSource, TenantSchemaProvider schemaProvider, CurrentTenantProvider tenantProvider) {
            this.dataSource = dataSource;
            this.schemaProvider = schemaProvider;
            this.tenantProvider = tenantProvider;
        }

        Connection getConnectionForTenant(Object tenantId) throws SQLException {
            Connection connection = this.dataSource.getConnection();
            connection.setSchema(this.schemaProvider.schema(tenantId));
            return connection;
        }

        private String tenantSchema() {
            return this.schemaProvider.schema(this.tenantProvider.currentId());
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.dataSource.getConnection();
            connection.setSchema(this.tenantSchema());
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.dataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.dataSource.isWrapperFor(iface);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.dataSource.getParentLogger();
        }
    }
}

