/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.TenantDataSourceProvider;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

final class MultiTenantDbSupplier
implements DataSourceSupplier {
    private final CurrentTenantProvider tenantProvider;
    private final TenantDataSourceProvider dataSourceProvider;

    MultiTenantDbSupplier(CurrentTenantProvider tenantProvider, TenantDataSourceProvider dataSourceProvider) {
        this.tenantProvider = tenantProvider;
        this.dataSourceProvider = dataSourceProvider;
    }

    @Override
    public Object currentTenantId() {
        return this.tenantProvider.currentId();
    }

    @Override
    public DataSource readOnlyDataSource() {
        return null;
    }

    @Override
    public DataSource dataSource() {
        return this.dataSourceProvider.dataSource(this.tenantProvider.currentId());
    }

    @Override
    public Connection connection(Object tenantId) throws SQLException {
        return this.dataSourceProvider.dataSource(tenantId).getConnection();
    }

    @Override
    public Connection readOnlyConnection(Object tenantId) throws SQLException {
        throw new SQLException("Not currently supported");
    }

    @Override
    public void shutdown(boolean deregisterDriver) {
        this.dataSourceProvider.shutdown(deregisterDriver);
    }
}

